<?php
/**
 * Custom defined widgets
 */

add_action( 'widgets_init', 'ozy_custom_widgets' );

function ozy_custom_widgets() {
	register_widget( 'OZY_Testimonial_Widget' );
	register_widget( 'OZY_OpeningTime_Widget' );
	register_widget( 'OZY_LatestPosts_Widget' );
	register_widget( 'OZY_CustomMenu_Widget' );
}

/**
 * Testimonial
 */

class OZY_Testimonial_Widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'testimonial', 'description' => __('This widget will help you to display a testimonial box.', 'ozy-coiffeur-essentials') );		
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'testimonial-widget' );		
		parent::__construct( 'testimonial-widget', __('(Coiffeur) Testimonial Box', 'ozy-coiffeur-essentials'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );
		//Variables from the widget settings.
		$title 	= $instance['title'];
		$content= $instance['content'];

		echo $before_widget;

		echo '<div class="testimonial-box">' . PHP_EOL;
		
		echo '<p>';
		echo $content;
		echo '<i class="oic-quote-1 icon-1"></i><i class="oic-quote-1 icon-2"></i>';		
		echo '</p>';
		echo '<h6>' . $title . '</h6>';
		echo '</div>' . PHP_EOL;
		
		echo $after_widget;
	}

	// Update the widget 	 
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		//Strip tags from title and name to remove HTML 
		$instance['title'] 	= strip_tags( $new_instance['title'] );
		$instance['content']= strip_tags( $new_instance['content'] );

		return $instance;
	}

	
	function form( $instance ) {

		//Set up some default widget settings.
		$defaults = array( 'title' => '', 'content' => '' );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'content' )); ?>"><?php _e('Content:', 'ozy-coiffeur-essentials'); ?></label>
			<textarea id="<?php echo esc_attr($this->get_field_id( 'content' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'content' )); ?>" style="width:100%;" rows="4"><?php echo esc_attr($instance['content']); ?></textarea>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e('Title:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($instance['title']); ?>" style="width:100%;" />
		</p>

	<?php
	}
}

/**
 * Opening Time
 */

class OZY_OpeningTime_Widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'openingtime', 'description' => __('This widget will help you to display a table of opening/closing time.', 'ozy-coiffeur-essentials') );
		
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'openingtime-widget' );
		
		parent::__construct( 'openingtime-widget', __('(Coiffeur) Opening/Closing Time', 'ozy-coiffeur-essentials'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );
		//Variables from the widget settings.
		$title 	= $instance['title'];
		
		$dayname_1 	= $instance['dayname_1'];
		$dayname_2 	= $instance['dayname_2'];
		$dayname_3 	= $instance['dayname_3'];
		$dayname_4 	= $instance['dayname_4'];
		$dayname_5 	= $instance['dayname_5'];
		$dayname_6 	= $instance['dayname_6'];
		$dayname_7 	= $instance['dayname_7'];

		$time_1 	= $instance['time_1'];
		$time_2 	= $instance['time_2'];
		$time_3 	= $instance['time_3'];
		$time_4 	= $instance['time_4'];
		$time_5 	= $instance['time_5'];
		$time_6 	= $instance['time_6'];
		$time_7 	= $instance['time_7'];

		echo $before_widget;

		echo '<div class="opening-time">' . PHP_EOL;
		if ( $title ) {
			echo '<h4 class="footer-widget-title">' . $title . '</h4>';
		}
		
		for($i = 1;$i<=7;$i++) {
			echo '<dl>';
			echo '<dt>'. ${"dayname_" . $i} . '</dt>';
			echo '<dd>'. ${"time_" . $i} . '</dd>';
			echo '</dl>';
		}
		
		echo '</div>' . PHP_EOL;
		
		echo $after_widget;
	}

	// Update the widget 	 
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		//Strip tags from title and name to remove HTML 
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['dayname_1'] = strip_tags( $new_instance['dayname_1'] );
		$instance['dayname_2'] = strip_tags( $new_instance['dayname_2'] );
		$instance['dayname_3'] = strip_tags( $new_instance['dayname_3'] );
		$instance['dayname_4'] = strip_tags( $new_instance['dayname_4'] );
		$instance['dayname_5'] = strip_tags( $new_instance['dayname_5'] );
		$instance['dayname_6'] = strip_tags( $new_instance['dayname_6'] );
		$instance['dayname_7'] = strip_tags( $new_instance['dayname_7'] );

		$instance['time_1'] = strip_tags( $new_instance['time_1'] );
		$instance['time_2'] = strip_tags( $new_instance['time_2'] );
		$instance['time_3'] = strip_tags( $new_instance['time_3'] );
		$instance['time_4'] = strip_tags( $new_instance['time_4'] );
		$instance['time_5'] = strip_tags( $new_instance['time_5'] );
		$instance['time_6'] = strip_tags( $new_instance['time_6'] );
		$instance['time_7'] = strip_tags( $new_instance['time_7'] );

		return $instance;
	}

	
	function form( $instance ) {

		//Set up some default widget settings.
		$defaults = array( 
			'title' => __('OPENING / CLOSING TIME', 'ozy-coiffeur-essentials'),
			'dayname_1' => __('Monday', 'ozy-coiffeur-essentials'),
			'dayname_2' => __('Tuesday', 'ozy-coiffeur-essentials'),
			'dayname_3' => __('Wednesday', 'ozy-coiffeur-essentials'),
			'dayname_4' => __('Thursday', 'ozy-coiffeur-essentials'),
			'dayname_5' => __('Friday', 'ozy-coiffeur-essentials'),
			'dayname_6' => __('Saturday', 'ozy-coiffeur-essentials'),
			'dayname_7' => __('Sunday', 'ozy-coiffeur-essentials'),
			'time_1' => __('08:00 - 17:30', 'ozy-coiffeur-essentials'),
			'time_2' => __('08:00 - 17:30', 'ozy-coiffeur-essentials'),
			'time_3' => __('08:00 - 17:30', 'ozy-coiffeur-essentials'),
			'time_4' => __('08:00 - 17:30', 'ozy-coiffeur-essentials'),
			'time_5' => __('08:00 - 17:30', 'ozy-coiffeur-essentials'),
			'time_6' => __('12:00 - 17:30', 'ozy-coiffeur-essentials'),
			'time_7' => __('CLOSED', 'ozy-coiffeur-essentials')
		);
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e('Title:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($instance['title']); ?>" style="width:100%;" />
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dayname_1' )); ?>"><?php _e('Day Name #1:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'dayname_1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dayname_1' )); ?>" value="<?php echo esc_attr($instance['dayname_1']) ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'time_1' )); ?>"><?php _e('Time:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'time_1' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'time_1' )); ?>" value="<?php echo esc_attr($instance['time_1']) ?>" style="width:100%;" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dayname_2' )); ?>"><?php _e('Day Name #2:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'dayname_2' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dayname_2' )); ?>" value="<?php echo esc_attr($instance['dayname_2']) ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'time_2' )); ?>"><?php _e('Time:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'time_2' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'time_2' )); ?>" value="<?php echo esc_attr($instance['time_2']) ?>" style="width:100%;" />
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dayname_3' )); ?>"><?php _e('Day Name #3:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'dayname_3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dayname_3' )); ?>" value="<?php echo esc_attr($instance['dayname_3']) ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'time_3' )); ?>"><?php _e('Time:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'time_3' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'time_3' )); ?>" value="<?php echo esc_attr($instance['time_3']) ?>" style="width:100%;" />
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dayname_4' )); ?>"><?php _e('Day Name #4:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'dayname_4' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dayname_4' )); ?>" value="<?php echo esc_attr($instance['dayname_4']) ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'time_4' )); ?>"><?php _e('Time:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'time_4' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'time_4' )); ?>" value="<?php echo esc_attr($instance['time_4']) ?>" style="width:100%;" />
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dayname_5' )); ?>"><?php _e('Day Name #5:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'dayname_5' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dayname_5' )); ?>" value="<?php echo esc_attr($instance['dayname_5']) ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'time_5' )); ?>"><?php _e('Time:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'time_5' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'time_5' )); ?>" value="<?php echo esc_attr($instance['time_5']) ?>" style="width:100%;" />
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dayname_6' )); ?>"><?php _e('Day Name #6:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'dayname_6' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dayname_6' )); ?>" value="<?php echo esc_attr($instance['dayname_6']) ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'time_6' )); ?>"><?php _e('Time:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'time_6' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'time_6' )); ?>" value="<?php echo esc_attr($instance['time_6']) ?>" style="width:100%;" />
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'dayname_7' )); ?>"><?php _e('Day Name #7:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'dayname_7' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'dayname_7' )); ?>" value="<?php echo esc_attr($instance['dayname_7']) ?>" style="width:100%;" />
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'time_7' )); ?>"><?php _e('Time:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'time_7' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'time_7' )); ?>" value="<?php echo esc_attr($instance['time_7']) ?>" style="width:100%;" />
		</p>                                        
               

	<?php
	}
}

/**
 * Custom Menu
 */

class OZY_CustomMenu_Widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'custommenu', 'description' => __('This widget will display custom menu from selected menu.', 'ozy-coiffeur-essentials') );
		
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'custommenu-widget' );
		
		parent::__construct( 'custommenu-widget', __('(Coiffeur) Custom Menu', 'ozy-coiffeur-essentials'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );
		
		global $ozyHelper;
		
		$title 			= isset($instance['title']) ? apply_filters( 'widget_title', $instance['title'] ) : '';
		$active_menu	= isset($instance['active_menu']) ? $instance['active_menu'] : '';
		if(is_user_logged_in()) {
			$active_menu	= isset($instance['active_menu_logged_in']) ? $instance['active_menu_logged_in'] : '';
		}		
		
		echo $before_widget;

		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; };
		
		if($active_menu) {
			$args = array( 'menu_class' => 'menu', 'menu' => $active_menu, 'walker' => new BootstrapNavMenuWalker('0') );
			wp_nav_menu( $args );
		}
		
		echo $after_widget;
	}

	// Update the widget 	 
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		//Strip tags from variables to remove HTML 
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['active_menu'] = strip_tags( $new_instance['active_menu'] );
		$instance['active_menu_logged_in'] = strip_tags( $new_instance['active_menu_logged_in'] );

		return $instance;
	}

	
	function form( $instance ) {

		//Set up some default widget settings.
		$defaults = array( 'title' => __('Custom Menu', 'ozy-coiffeur-essentials'), 'active_menu' => '', 'active_menu_logged_in' => '' );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e('Title:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($instance['title']); ?>" style="width:100%;" />
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'active_menu' )); ?>"><?php _e('Menu:', 'ozy-coiffeur-essentials'); ?></label>
			<?php
				$menus = get_terms('nav_menu');
			?>
            <select id="<?php echo esc_attr($this->get_field_id( 'active_menu' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'active_menu' )); ?>" style="width:100%;">
            	<?php
					foreach($menus as $menu){
					   	echo '<option value="'. esc_attr($menu->slug) .'" '. selected( $menu->slug, $instance['active_menu'], false ) .'>'. $menu->name .'</option>' . PHP_EOL;
					}
				?>
            </select>
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'active_menu_logged_in' )); ?>"><?php _e('Menu Logged-In:', 'ozy-coiffeur-essentials'); ?></label>
			<?php
				$menus = get_terms('nav_menu');
			?>
            <select id="<?php echo esc_attr($this->get_field_id( 'active_menu_logged_in' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'active_menu_logged_in' )); ?>" style="width:100%;">
            	<?php
					foreach($menus as $menu){
					   	echo '<option value="'. esc_attr($menu->slug) .'" '. selected( $menu->slug, $instance['active_menu_logged_in'], false ) .'>'. $menu->name .'</option>' . PHP_EOL;
					}
				?>
            </select>
		</p>        

	<?php
	}
}

/**
 * Latest Posts
 */

class OZY_LatestPosts_Widget extends WP_Widget {

	function __construct() {
		$widget_ops = array( 'classname' => 'latestposts', 'description' => __('This widget will display latest posts in multiple view modes.', 'ozy-coiffeur-essentials') );
		
		$control_ops = array( 'width' => 300, 'height' => 350, 'id_base' => 'latestposts-widget' );
		
		parent::__construct( 'latestposts-widget', __('(Coiffeur) Latest Posts', 'ozy-coiffeur-essentials'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );
		
		global $ozyHelper;
		
		echo $before_widget;

		$title 			= isset($instance['title']) ? apply_filters( 'widget_title', $instance['title'] ) : '';
		$type 			= isset($instance['type']) ? $instance['type'] : 'list_with_thumbs';
		$post_type 		= isset($instance['post_type']) ? $instance['post_type'] : 'post';
		$order 			= isset($instance['order']) ? $instance['order'] : 'ASC';
		$orderby 		= isset($instance['orderby']) ? $instance['orderby'] : 'title';
		$posts_per_page = isset($instance['post_per_page']) && (int)$instance['post_per_page'] > 0 ? $instance['post_per_page'] : 9;
		
		$args = array(
			'post_type' 			=> $post_type,
			'posts_per_page'		=> $posts_per_page,
			'orderby' 				=> $orderby,
			'order' 				=> $order,
			'ignore_sticky_posts' 	=> 1,
			'meta_key' 				=> '_thumbnail_id'
		);

		if ( !empty( $title ) ) { echo $before_title . $title . $after_title; };
		
		$the_query = new WP_Query( $args );

		switch($type) {
			case 'thumbs':		
				echo '<div class="ozy-latest-posts">' . PHP_EOL;
				while ( $the_query->have_posts() ) {
					$the_query->the_post();
					echo '<a href="' . get_permalink() . '" title="' . esc_attr( get_the_title() ) . '">';
					echo get_the_post_thumbnail(get_the_ID(), 'thumbnail');
					echo '<span>'. get_the_title() .'</span>';
					echo '</a>';
				}
				echo '</div>' . PHP_EOL;			
				break;
			case 'list_with_thumbs':
				echo '<ul class="ozy-latest-posts-with-thumbs">' . PHP_EOL;
				while ( $the_query->have_posts() ) {
					$the_query->the_post();			
					echo '<li><a href="' . get_permalink() . '" title="' . esc_attr( get_the_title() ) . '">';
					echo get_the_post_thumbnail(get_the_ID(), 'thumbnail');
					echo '<span>';
					echo '<strong>' . get_the_title() . '</strong>';
					echo '<small>' . get_the_date() . '</small>';
					echo '</span>';
					echo '</a></li>';
				}
				echo '</ul>' . PHP_EOL;	
				break;
			case 'simple_list':
				echo '<ul class="ozy-simple-latest-posts">' . PHP_EOL;
				while ( $the_query->have_posts() ) {
					$the_query->the_post();			
					echo '<li><a href="' . get_permalink() . '" title="' . esc_attr( get_the_title() ) . '">';
					echo '<strong>' . get_the_title() . '</strong>';
					echo '</a>';
					echo '<small>' . get_the_date() . '</small></li>';
				}
				echo '</ul>' . PHP_EOL;	
				break;
		}
		
		
		wp_reset_query();
		
		echo $after_widget;
	}

	// Update the widget 	 
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;

		//Strip tags from variables to remove HTML 
		$instance['type'] = strip_tags( $new_instance['type'] );
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['post_type'] = strip_tags( $new_instance['post_type'] );
		$instance['order'] = strip_tags( $new_instance['order'] );
		$instance['orderby'] = strip_tags( $new_instance['orderby'] );
		$instance['post_per_page'] = strip_tags( $new_instance['post_per_page'] );

		return $instance;
	}

	
	function form( $instance ) {

		//Set up some default widget settings.
		$defaults = array( 'title' => __('Latest Posts', 'ozy-coiffeur-essentials'), 'type' => 'list_with_thumbs', 'post_type' => 'post', 'order' => 'ASC', 'orderby' => 'title', 'post_per_page' => 6 );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'title' )); ?>"><?php _e('Title:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'title' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" value="<?php echo esc_attr($instance['title']); ?>" style="width:100%;" />
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'type' )); ?>"><?php _e('Type:', 'ozy-coiffeur-essentials'); ?></label>
			<?php
				$type_arr = array('list_with_thumbs', 'simple_list', 'thumbs');
			?>
            <select id="<?php echo esc_attr($this->get_field_id( 'type' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'type' )); ?>" style="width:100%;">
            	<?php
					foreach ( $type_arr as $type ) {
					   	echo '<option value="'. esc_attr($type) .'" '. selected( $type, $instance['type'], false ) .'>'. $type .'</option>' . PHP_EOL;
					}
				?>
            </select>
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'post_type' )); ?>"><?php _e('Post Type:', 'ozy-coiffeur-essentials'); ?></label>
			<?php
				$args = array(
				   'public'   => true,
				   '_builtin' => false
				);
				$post_types = get_post_types( $args, 'names' );
				$post_types['post'] = 'post';
				$post_types['page'] = 'page';
			?>
            <select id="<?php echo esc_attr($this->get_field_id( 'post_type' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'post_type' )); ?>" style="width:100%;">
            	<?php
					foreach ( $post_types as $post_type ) {
					   	echo '<option value="'. esc_attr($post_type) .'" '. selected( $post_type, $instance['post_type'], false ) .'>'. $post_type .'</option>' . PHP_EOL;
					}
				?>
            </select>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'order' )); ?>"><?php _e('Order:', 'ozy-coiffeur-essentials'); ?></label>
			<?php
				$order_arr = array('ASC', 'DESC');
			?>
            <select id="<?php echo esc_attr($this->get_field_id( 'order' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'order' )); ?>" style="width:100%;">
            	<?php
					foreach ( $order_arr as $order ) {
					   	echo '<option value="'. esc_attr($order) .'" '. selected( $order, $instance['order'], false ) .'>'. $order .'</option>' . PHP_EOL;
					}
				?>
            </select>
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>"><?php _e('Order By:', 'ozy-coiffeur-essentials'); ?></label>
			<?php
				$orderby_arr = array('ID', 'title', 'date', 'rand', 'comment_count');
			?>
            <select id="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'orderby' )); ?>" style="width:100%;">
            	<?php
					foreach ( $orderby_arr as $orderby ) {
					   	echo '<option value="'. esc_attr($orderby) .'" '. selected( $orderby, $instance['orderby'], false ) .'>'. $orderby .'</option>' . PHP_EOL;
					}
				?>
            </select>
		</p>
        
		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'post_per_page' )); ?>"><?php _e('Count:', 'ozy-coiffeur-essentials'); ?></label>
			<input id="<?php echo esc_attr($this->get_field_id( 'post_per_page' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'post_per_page' )); ?>" value="<?php echo esc_attr($instance['post_per_page']); ?>" style="width:100%;" />
		</p>        

	<?php
	}
}
?>