<?php
/**
 * Plugin Name: Coiffeur Theme Essentials
 * Plugin URI: http://themeforest.net/user/freevision/portfolio
 * Description: This plugin will enable Visual Shortcodes for Visual Composer and Custom Post types like Announcements and few other features for your COIFFEUR theme.
 * Version: 3.3
 * Author: freevision
 * Text Domain: ozy-coiffeur-essentials
 * Domain Path: /translate
 */

if (!defined('ABSPATH')) die('No direct access allowed');

define( 'OZY_COIFFEUR_ESSENTIALS_ACTIVATED', 1 );

/**
 * Custom post types
 */
function ozy_plugin_create_post_types() {	
	//Load plugin textdomain.
	load_plugin_textdomain( 'ozy-coiffeur-essentials', false, basename( dirname( __FILE__ ) ) . '/translate/' );

	$essentials_options = get_option('ozy_coiffeur_essentials');
	
	//Announcements
	register_post_type( 'ozy_announcements',
		array(
			'labels' => array(
				'name' => __( 'Announcements', 'ozy-coiffeur-essentials'),
				'singular_name' => __( 'Announcement', 'ozy-coiffeur-essentials'),
				'add_new' => __( 'Add Announcement Item', 'ozy-coiffeur-essentials'),
				'edit_item' => __( 'Edit Announcement Item', 'ozy-coiffeur-essentials'),
				'new_item' => __( 'New Announcement Item', 'ozy-coiffeur-essentials'),
				'view_item' => __( 'View Announcement Item', 'ozy-coiffeur-essentials'),
				'search_items' => __( 'Search Announcement Items', 'ozy-coiffeur-essentials'),
				'not_found' => __( 'No Announcement Items found', 'ozy-coiffeur-essentials'),
				'not_found_in_trash' => __( 'No Announcement Items found in Trash', 'ozy-coiffeur-essentials')				
			),
			'can_export' => true,
			'public' => true,
			'sort' => true,
			'has_archive' => true,
			'rewrite' => array('slug' => 'announcement', 'with_front' => true),
			'supports' => array('title','editor','thumbnail'),
			'menu_icon' => 'dashicons-lightbulb'
		)
	);
	
	//User managaged sidebars
	register_post_type( 'ozy_sidebars',
		array(
			'labels' => array(
				'name' => __( 'Sidebars', 'ozy-coiffeur-essentials'),
				'singular_name' => __( 'Sidebars', 'ozy-coiffeur-essentials'),
				'add_new' => 'Add Sidebar',
				'add_new_item' => 'Add Sidebar',
				'edit_item' => 'Edit Sidebar',
				'new_item' => 'New Sidebar',
				'view_item' => 'View Sidebars',
				'search_items' => 'Search Sidebar',
				'not_found' => 'No Sidebar found',
				'not_found_in_trash' => 'No Sidebar found in Trash'				
			),
			'can_export' => true,
			'public' => true,
			'exclude_from_search' => true,
			'publicly_queryable' => false,				
			'has_archive' => false,
			'rewrite' => false,
			'supports' => array('title'),
			'taxonomies' => array(''),
			'menu_icon' => 'dashicons-align-left'
		)
	);
	
	//User managaged sidebars
	register_post_type( 'ozy_fonts',
		array(
			'labels' => array(
				'name' => __( 'Custom Fonts', 'ozy-coiffeur-essentials'),
				'singular_name' => __( 'Custom Fonts', 'ozy-coiffeur-essentials'),
				'add_new' => 'Add Font',
				'add_new_item' => 'Add Font',
				'edit_item' => 'Edit Font',
				'new_item' => 'New Font',
				'view_item' => 'View Font',
				'search_items' => 'Search Font',
				'not_found' => 'No Font found',
				'not_found_in_trash' => 'No Font found in Trash'				
			),
			'can_export' => true,
			'public' => true,
			'exclude_from_search' => true,
			'publicly_queryable' => false,				
			'has_archive' => false,
			'rewrite' => false,
			'supports' => array('title'),
			'taxonomies' => array(''),
			'menu_icon' => 'dashicons-editor-textcolor'
		)
	);

}
add_action( 'init', 'ozy_plugin_create_post_types', 0 );

/**
 * Options panel for this plugin
 */
class OzyEssentialsOptionsPage_Coiffeur
{
    /**
     * Holds the values to be used in the fields callbacks
     */
    private $options;

    /**
     * Start up
     */
    public function __construct()
    {
        add_action( 'admin_menu', array( $this, 'add_plugin_page' ) );
        add_action( 'admin_init', array( $this, 'page_init' ) );
    }

    /**
     * Add options page
     */
    public function add_plugin_page()
    {
        // This page will be under "Settings"
        add_options_page(
            'Settings Admin', 
            'Coiffeur Essentials', 
            'manage_options', 
            'ozy-coiffeur-essentials-setting-admin', 
            array( $this, 'create_admin_page' )
        );
    }

    /**
     * Options page callback
     */
    public function create_admin_page()
    {
        // Set class property
        $this->options = get_option( 'ozy_coiffeur_essentials' );
        ?>
        <div class="wrap">
            <h2>Coiffeur Essentials Options</h2>           
            <form method="post" action="options.php">
            <?php
                // This prints out all hidden setting fields
                settings_fields( 'ozy_coiffeur_essentials_option_group' );
                do_settings_sections( 'ozy-coiffeur-essentials-setting-admin' );
				do_settings_sections( 'ozy-coiffeur-essentials-setting-admin-twitter' );
			
                submit_button(); 
            ?>
            </form>
        </div>
        <?php
    }

    /**
     * Register and add settings
     */
    public function page_init()
    {        
        register_setting(
            'ozy_coiffeur_essentials_option_group', // Option group
            'ozy_coiffeur_essentials', // Option name
            array( $this, 'sanitize' ) // Sanitize
        );

        add_settings_section(
            'ozy-coiffeur-essentials-setting-admin-twitter', 
            'Twitter Parameters', 
            array( $this, 'print_twitter_section_info' ),
            'ozy-coiffeur-essentials-setting-admin-twitter'
        );			
		
        add_settings_field(
            'twitter_consumer_key', 
            'Consumer Key', 
            array( $this, 'field_callback_twitter_consumer_key' ), 
            'ozy-coiffeur-essentials-setting-admin-twitter', 
            'ozy-coiffeur-essentials-setting-admin-twitter'
        );

		add_settings_field(
            'twitter_secret_key', 
            'Secret Key', 
            array( $this, 'field_callback_twitter_secret_key' ), 
            'ozy-coiffeur-essentials-setting-admin-twitter', 
            'ozy-coiffeur-essentials-setting-admin-twitter'
        );
		
		add_settings_field(
            'twitter_token_key', 
            'Access Token Key', 
            array( $this, 'field_callback_twitter_token_key' ), 
            'ozy-coiffeur-essentials-setting-admin-twitter', 
            'ozy-coiffeur-essentials-setting-admin-twitter'
        );
		
		add_settings_field(
            'twitter_token_secret_key', 
            'Access Token Secret Key', 
            array( $this, 'field_callback_twitter_token_secret_key' ), 
            'ozy-coiffeur-essentials-setting-admin-twitter', 
            'ozy-coiffeur-essentials-setting-admin-twitter'
        );
    }

    /**
     * Sanitize each setting field as needed
     *
     * @param array $input Contains all settings fields as array keys
     */
    public function sanitize( $input )
    {
		if( !empty( $input['twitter_consumer_key'] ) )
            $input['twitter_consumer_key'] = sanitize_text_field( $input['twitter_consumer_key'] );

		if( !empty( $input['twitter_secret_key'] ) )
            $input['twitter_secret_key'] = sanitize_text_field( $input['twitter_secret_key'] );

        if( !empty( $input['twitter_token_key'] ) )
            $input['twitter_token_key'] = sanitize_text_field( $input['twitter_token_key'] );

        if( !empty( $input['twitter_token_secret_key'] ) )
            $input['twitter_token_secret_key'] = sanitize_text_field( $input['twitter_token_secret_key'] );		

        return $input;
    }

    /** 
     * Print the Section text
     */
    public function print_twitter_section_info()
    {
        print 'Enter required parameters of your Twitter Dev. account <a href="https://dev.twitter.com/apps" target="_blank">https://dev.twitter.com/apps</a>';
    }

    /** 
     * Get the settings option array and print one of its values : Twitter Consumer Key
     */	
    public function field_callback_twitter_consumer_key()
    {
        printf(
            '<input type="text" id="twitter_consumer_key" name="ozy_coiffeur_essentials[twitter_consumer_key]" value="%s" />',
            (!isset($this->options['twitter_consumer_key']) ? '' : esc_attr( $this->options['twitter_consumer_key']))
        );
    }

    /** 
     * Get the settings option array and print one of its values : Twitter Secret Key
     */	
    public function field_callback_twitter_secret_key()
    {
        printf(
            '<input type="text" id="twitter_secret_key" name="ozy_coiffeur_essentials[twitter_secret_key]" value="%s" />',
            (!isset($this->options['twitter_secret_key']) ? '' : esc_attr( $this->options['twitter_secret_key']))
        );		
    }

    /** 
     * Get the settings option array and print one of its values : Twitter Token Key
     */	
    public function field_callback_twitter_token_key()
    {
        printf(
            '<input type="text" id="twitter_token_key" name="ozy_coiffeur_essentials[twitter_token_key]" value="%s" />',
            (!isset($this->options['twitter_token_key']) ? '' : esc_attr( $this->options['twitter_token_key']))
        );		
    }

    /** 
     * Get the settings option array and print one of its values : Twitter Token Secret Key
     */
    public function field_callback_twitter_token_secret_key()
    {
        printf(
            '<input type="text" id="twitter_token_secret_key" name="ozy_coiffeur_essentials[twitter_token_secret_key]" value="%s" />',
            (!isset($this->options['twitter_token_secret_key']) ? '' : esc_attr( $this->options['twitter_token_secret_key']))
        );		
    }

}

/** 
 * Register activation redirection
 */
register_activation_hook(__FILE__, 'ozy_essentials_plugin_activate');
add_action('admin_init', 'ozy_essentials_plugin_activate_redirect');

function ozy_essentials_plugin_activate() {
    add_option('ozy_essentials_plugin_activate_redirect', true);
}

function ozy_essentials_plugin_activate_redirect() {
    if (get_option('ozy_essentials_plugin_activate_redirect', false)) {
        delete_option('ozy_essentials_plugin_activate_redirect');
        wp_redirect('options-general.php?page=ozy-coiffeur-essentials-setting-admin');
    }
}

/**
 * We need this plugin to work only on admin side
 */

if( is_admin() ) {
    $ozy_essentials_options_page = new OzyEssentialsOptionsPage_Coiffeur();
}

/**
* Update Notifier
*/
require(plugin_dir_path( __FILE__ ) . 'updater/update-notifier.php');
define( 'OZY_NOTIFIER_THEME_NAME', 'Coiffeur' );
define( 'OZY_NOTIFIER_THEME_FOLDER_NAME', 'coiffeur' );
define( 'OZY_NOTIFIER_XML_FILE', 'http://s3-eu-west-1.amazonaws.com/themeversion/coiffeur.xml' );
define( 'OZY_NOTIFIER_CACHE_INTERVAL', 43200);

/**
* ozy_add_extra_page
*
* We are adding and extra page to include documentation into to the admin.
*/
function ozy_add_extra_page() {
	add_menu_page(
		__('Documentation','ozy-coiffeur-essentials'), 
		__('Documentation','ozy-coiffeur-essentials'), 
		'read',
		'ozy-coiffeur-documentation', 
		'ozy_coiffeur_documentation', 
		'dashicons-editor-help' 
	);
}
add_action('admin_menu', 'ozy_add_extra_page');

function ozy_coiffeur_documentation() {
	echo '<iframe src="https://doc.freevision.me/coiffeur/" id="ozy-help-iframe" width="100%" height="800px" frameborder="0"></iframe>';
}

/*
* Widgets
*/
require_once plugin_dir_path( __FILE__ ) . 'ozy-coiffeur-essentials-widgets.php';

/**
 *	Samples Importer
 */
if(is_admin()){
	require_once plugin_dir_path( __FILE__ ) . 'ozy-coiffeur-essentials-importer-init.php';
}

/**
* Curl operations
*/
function ozy_fetchCurlData($url) {
	if(function_exists('curl_version')) {
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true); 
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 	
		curl_setopt($ch, CURLOPT_TIMEOUT, 20);
		$result = curl_exec($ch);
		curl_close($ch);
		return $result;
	}else{
		return '-10';
	}
}

if(!function_exists('coiffeur_timestampdiff')) {
	function coiffeur_timestampdiff($qw, $saw) {
		$datetime1 = new DateTime("@"."$qw");
		$datetime2 = new DateTime("@"."$saw");
		$interval = $datetime1->diff($datetime2);
		
		return $interval->format('%I');
	}
}

/**
* coiffeur_hook_save_post_clear_instagram_ajax_cache
*
* Will clear Instagram JSON data stored in DB to make sure if user changed settings of the shortcode
*/

add_action( 'save_post', 'coiffeur_hook_save_post_clear_instagram_ajax_cache', 10, 3 );

function coiffeur_hook_save_post_clear_instagram_ajax_cache( $post_ID, $post, $update ) {
	update_option('coiffeur_freevision_instagram_cache', '');
	update_option('coiffeur_freevision_instagram_cache_time', '');
}

/**
* coiffeur_ajax_instagram
*
* Instagram JSON data, to make sure not loading from remote service for each call to avoid exceeding the limit of use
*/
function coiffeur_ajax_instagram() {
	$date = new DateTime(); $api_key = '';

	$request_user_id 		= isset($_GET["request_user_id"]) ? sanitize_text_field($_GET["request_user_id"]) : '';
	$request_access_token 	= isset($_GET["request_access_token"]) ? sanitize_text_field($_GET["request_access_token"]) : '';
	$request_num_photos 	= isset($_GET["request_num_photos"]) ? sanitize_text_field($_GET["request_num_photos"]) : '';
	
	if(trim($request_user_id) != '' && trim($request_access_token) != '' && trim($request_num_photos) != '') {
		if(get_option('coiffeur_freevision_instagram_cache_time') != '' && coiffeur_timestampdiff($date->getTimestamp(), get_option('coiffeur_freevision_instagram_cache_time')) < 30) { //check if weather data 30 minutes old 		
			echo get_option('coiffeur_freevision_instagram_cache');
			exit();			
		}else{			
			$request = wp_remote_get('https://graph.instagram.com/'. $request_user_id .'/media?fields=id,username&access_token=' . $request_access_token);
			if( is_wp_error( $request ) ) {
				echo '{"error":"Instagram Service Error: '. $request->get_error_message() .'"}';
				exit();
			}
			$body = wp_remote_retrieve_body( $request );
			$data = json_decode( $body );
			if( ! empty( $data ) ) {			
				if(isset($data->data)) {					
					$output = ''; $max_num_photos_counter = 0;

					if(isset($data->data[0]->username)) $output .= '<span class="alternate-text-color" id="instagram-feed-user-name-label">@'. $data->data[0]->username .'</span>';

					$output .= '<ul class="ozy-instagram-gallery new">';
					foreach($data->data as $d) {
						if(isset($d->id) && isset($d->username)) {
							$media_request = wp_remote_get('https://graph.instagram.com/'. $d->id .'?fields=id,media_type,media_url,thumbnail_url,username,timestamp,permalink,caption&access_token=' . $request_access_token);
							if( is_wp_error( $media_request ) ) {
								echo '{"error":"Instagram Service Error: '. $media_request->get_error_message() .'"}';
								exit();
							}							
							$media_body = wp_remote_retrieve_body( $media_request );
							$media_data = json_decode( $media_body );
							if( ! empty( $media_data ) ) {
								if(isset($media_data->media_url) && isset($media_data->permalink) && isset($media_data->media_type)) {
									if($media_data->media_type == 'VIDEO') {
										$output .= '<li class="video-item"><a href="'. $media_data->permalink .'" target="_blank"><img src="'. $media_data->thumbnail_url .'"></a></li>';
									}else if($media_data->media_type == 'IMAGE'){
										$output .= '<li class="image-item"><a href="'. $media_data->permalink .'" target="_blank"><img src="'. $media_data->media_url .'"></a></li>';
									}									
									
									$max_num_photos_counter++;
									if($max_num_photos_counter > $request_num_photos) break;
								}							
							}else{
								echo '{"error":"No media found"}'; exit();
							}
						}
					}
					$output .= '</ul>';

					update_option('coiffeur_freevision_instagram_cache', $output);
					update_option('coiffeur_freevision_instagram_cache_time', $date->getTimestamp());					
					
					echo $output; exit();
				}else{
					echo '{"error":"Invalid Request #1"}'; exit();
				}
			}else{
				echo '{"error":"Invalid Request #2"}'; exit();
			}
		}
	}else{		
		echo '{"error":"Missing parameters #3"}'; exit();
	}	

	exit();

}
add_action( 'wp_ajax_nopriv_coiffeur_ajax_instagram', 'coiffeur_ajax_instagram' ); 
add_action( 'wp_ajax_coiffeur_ajax_instagram', 'coiffeur_ajax_instagram' ); 

/**
 * Shortcodes
 */

if ( ! function_exists( 'is_plugin_active' ) ) require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
if(is_plugin_active("js_composer/js_composer.php") && function_exists('vc_map') && function_exists('vc_set_as_theme')) {

	//Icon Selector Attribute Type
	function ozy_select_an_icon_settings_field($settings, $value) {
	   //$dependency = vc_generate_dependencies_attributes($settings);
	   return '<div class="select_an_icon">'
				 .'<input name="'.$settings['param_name']
				 .'" id="field_'.$settings['param_name']
				 .'_select" class="wpb_vc_param_value wpb-textinput '
				 .$settings['param_name'].' '.$settings['type'].'_field" type="text" value="'
				 .$value.'"/>'
			 .'</div>';
	}

	vc_add_shortcode_param('select_an_icon', 'ozy_select_an_icon_settings_field', get_template_directory_uri() .'/scripts/admin/admin.js');

	$add_css_animation = array(
		"type" => "dropdown",
		"heading" => __("CSS Animation", "ozy-coiffeur-essentials"),
		"param_name" => "css_animation",
		"admin_label" => true,
		"value" => array(__("No", "ozy-coiffeur-essentials") => '', __("Top to bottom", "ozy-coiffeur-essentials") => "top-to-bottom", __("Bottom to top", "ozy-coiffeur-essentials") => "bottom-to-top", __("Left to right", "ozy-coiffeur-essentials") => "left-to-right", __("Right to left", "ozy-coiffeur-essentials") => "right-to-left", __("Appear from center", "ozy-coiffeur-essentials") => "appear"),
		"description" => __("Select type of animation if you want this element to be animated when it enters into the browsers viewport. Note: Works only in modern browsers.", "ozy-coiffeur-essentials")
	);

	$animate_css_effects = array("flash","bounce","shake","tada","swing","wobble","pulse","flip","flipInX","flipOutX","flipInY","flipOutY","fadeIn","fadeInUp","fadeInDown","fadeInLeft","fadeInRight","fadeInUpBig","fadeInDownBig","fadeInLeftBig","fadeInRightBig","fadeOut","fadeOutUp","fadeOutDown","fadeOutLeft","fadeOutRight","fadeOutUpBig","fadeOutDownBig","fadeOutLeftBig","fadeOutRightBig","bounceIn","bounceInDown","bounceInUp","bounceInLeft","bounceInRight","bounceOut","bounceOutDown","bounceOutUp","bounceOutLeft","bounceOutRight","rotateIn","rotateInDownLeft","rotateInDownRight","rotateInUpLeft","rotateInUpRight","rotateOut","rotateOutDownLeft","rotateOutDownRight","rotateOutUpLeft","rotateOutUpRight","hinge","rollIn","rollOut");

	/**
	* Price List
	*/
	if (!function_exists('ozy_vc_pricelistwrapper')) {
		function ozy_vc_pricelistwrapper( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_pricelistwrapper', $atts);
			extract(shortcode_atts(array(
				'title' => '',
				'sub_title' => '',
				'columnt_title1' => '',
				'columnt_title2' => '',
				'columnt_title3' => '',
				'columnt_title4' => ''
			), $atts));

			$output = '<div class="ozy-price-list ozy-border-color">';
			if($title) $output.= '<h3>'. esc_attr($title) .'</h3>';
			if($sub_title) $output.= '<p>'. esc_attr($sub_title) .'</p>';
			$output.= '<table>';
			$output.= '<tr>';
			$output.= '<th>&nbsp;</th>';
			$output.= '<th>'. esc_attr($columnt_title1) .'</th>';
			if($columnt_title2) $output.= '<th>'. esc_attr($columnt_title2) .'</th>';
			if($columnt_title3) $output.= '<th>'. esc_attr($columnt_title3) .'</th>';
			if($columnt_title4) $output.= '<th>'. esc_attr($columnt_title4) .'</th>';
			$output.= '</tr>';		
			$output.= do_shortcode($content); 
			$output.= '</table>';
			$output.= '</div>';

			return $output;
		}
		
		add_shortcode('ozy_vc_pricelistwrapper', 'ozy_vc_pricelistwrapper');
		
		vc_map( array(
			"name" => __("Price List", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_pricelistwrapper",
			"as_parent" => array('only' => 'ozy_vc_pricelist'),
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => __("Title", "ozy-coiffeur-essentials"),
					"param_name" => "title",
					"value" => "",
					"admin_label" => true
				),array(
					"type" => "textfield",
					"heading" => __("Sub Title", "ozy-coiffeur-essentials"),
					"param_name" => "sub_title",
					"value" => "",
					"admin_label" => true
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Columnt Title #1", "ozy-coiffeur-essentials"),
					"param_name" => "columnt_title1",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Columnt Title #2", "ozy-coiffeur-essentials"),
					"param_name" => "columnt_title2",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Columnt Title #3", "ozy-coiffeur-essentials"),
					"param_name" => "columnt_title3",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Columnt Title #4", "ozy-coiffeur-essentials"),
					"param_name" => "columnt_title4",
					"admin_label" => false,
					"value" => ""
				)				
		   ),
		   "js_view" => 'VcColumnView'
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Pricelistwrapper extends WPBakeryShortCodesContainer{}

	if (!function_exists('ozy_vc_pricelist')) {
		function ozy_vc_pricelist( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_pricelist', $atts);
			extract(shortcode_atts(array(
				'icon' => '',
				'custom_icon' => '',
				'label_field' => '',
				'value_field1' => '',
				'value_field2' => '',
				'value_field3' => '',
				'value_field4' => '',
				'featured' => 'no',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}
			
			$custom_icon = wp_get_attachment_image_src($custom_icon, 'full');
			if(isset($custom_icon[0])) {
				$icon = '';
				$custom_icon = $custom_icon[0];
			}			
			
			$output = '<tr class="'. ($featured === 'yes' ? 'featured' : '') .'">';
			$output.= '<td class="label">';
			if($icon) $output.= '<i class="'. esc_attr($icon) .'"></i>';
			if($custom_icon) $output.= '<img src="'. esc_url($custom_icon) .'" alt=""/>';
			$output.= esc_attr($label_field) . '</td>';
			$output.= '<td class="v">' . esc_attr($value_field1) . '</td>';
			if($value_field2) $output.= '<td class="v">' . esc_attr($value_field2) . '</td>';
			if($value_field3) $output.= '<td class="v">' . esc_attr($value_field3) . '</td>';
			if($value_field4) $output.= '<td class="v">' . esc_attr($value_field4) . '</td>';
			$output.= '</tr>';
			return $output;
		}
		
		add_shortcode( 'ozy_vc_pricelist', 'ozy_vc_pricelist' );
		
		vc_map( array(
			"name" => __("Price List Row", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_pricelist",
			"content_element" => true,
			"as_child" => array('only' => 'ozy_vc_pricelistwrapper'),
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "select_an_icon",
					"heading" => __("Icon", "ozy-coiffeur-essentials"),
					"param_name" => "icon",
					"value" => '',
					"admin_label" => false
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Custom Icon", "ozy-coiffeur-essentials"),
					"param_name" => "custom_icon",
					"description" => __("When this option used, Icon will be ignored", "ozy-coiffeur-essentials"),
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Label", "ozy-coiffeur-essentials"),
					"param_name" => "label_field",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Value #1", "ozy-coiffeur-essentials"),
					"param_name" => "value_field1",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Value #2", "ozy-coiffeur-essentials"),
					"param_name" => "value_field2",
					"admin_label" => true,
					"description" => __("This field is not required. Fill only when you need multiple columns on your row", "ozy-coiffeur-essentials"),
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Value #3", "ozy-coiffeur-essentials"),
					"param_name" => "value_field3",
					"admin_label" => true,
					"description" => __("This field is not required. Fill only when you need multiple columns on your row", "ozy-coiffeur-essentials"),
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Value #4", "ozy-coiffeur-essentials"),
					"param_name" => "value_field4",
					"admin_label" => true,
					"description" => __("This field is not required. Fill only when you need multiple columns on your row", "ozy-coiffeur-essentials"),
					"value" => ""
				),array(
					"type" => "dropdown",
					"heading" => __("Featured", "ozy-coiffeur-essentials"),
					"param_name" => "featured",
					"value" => array("no", "yes"),
					"admin_label" => false
				),$add_css_animation
		   )
		) );	
	}

	class WPBakeryShortCode_Ozy_Vc_Pricelist extends WPBakeryShortCode{}

	/**
	* Pretty Map
	*/
	if (!function_exists('ozy_vc_prettymap')) {
		function ozy_vc_prettymap( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_prettymap', $atts);
			extract(shortcode_atts(array(
				'address'		=> '',
				'zoom'			=> '13',
				'custom_icon'	=> '',
				'hue'			=> '#ff0000',
				'saturation'	=> '-30',
				'lightness' 	=> '0',
				'height'		=> '350px',
				'api_key'		=> ''
			), $atts));
			
			$custom_icon = wp_get_attachment_image_src($custom_icon, 'full');
			if(isset($custom_icon[0])) {
				$custom_icon = $custom_icon[0];
			}
			
			//wp_enqueue_script('googlemaps', '//maps.google.com/maps/api/js?sensor=false&language=en', array('jquery'), null, true );
			wp_enqueue_script('googlemaps', '//maps.google.com/maps/api/js?'. ($api_key?'key=' . $api_key .'&':'') .'sensor=false&language=en', array('jquery'), null, true );
			
			return '<div class="ozy-google-map" 
			data-address="'. esc_attr($address) .'" 
			data-zoom="'. esc_attr($zoom) .'" 
			data-hue="'. esc_attr($hue) .'" 
			data-saturation="'. esc_attr($saturation) .'" 
			data-lightness="'. esc_attr($lightness) .'" 
			data-icon="'. esc_attr(esc_url($custom_icon)) .'" style="height:'. esc_attr($height) .'"></div>';
		}
		
		add_shortcode('ozy_vc_prettymap', 'ozy_vc_prettymap');
		
		vc_map( array(
			"name" => __("Custom Google Map", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_prettymap",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Google Maps API Key", "ozy-coiffeur-essentials"),
					"param_name" => "api_key",
					"admin_label" => false,
					"value" => "",
					'description' => wp_kses(__('<a href="http://freevision.me/google-maps-key/" target="_blank">Learn how to get an API Key.</a>', 'ozy-coiffeur-essentials'),array('a' => array('href' => array(), 'target' => array()))),					
				),			
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Height", "ozy-coiffeur-essentials"),
					"param_name" => "height",
					"admin_label" => true,
					"value" => "350px"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Address", "ozy-coiffeur-essentials"),
					"param_name" => "address",
					"admin_label" => true,
					"value" => __("Melbourne, Australia", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Zoom Level", "ozy-coiffeur-essentials"),
					"param_name" => "zoom",
					"admin_label" => true,
					"value" => "13"
				),			
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Custom Icon", "ozy-coiffeur-essentials"),
					"param_name" => "custom_icon",
					"description" => __("You can select a custom icon for your pin on the map", "ozy-coiffeur-essentials"),
					"admin_label" => false,
					"value" => ""
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Hue Color", "ozy-coiffeur-essentials"),
					"param_name" => "hue",
					"admin_label" => false,
					"value" => "#FF0000"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Saturation", "ozy-coiffeur-essentials"),
					"param_name" => "saturation",
					"admin_label" => true,
					"value" => "-30"
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Lightness", "ozy-coiffeur-essentials"),
					"param_name" => "lightness",
					"admin_label" => true,
					"value" => "0"
				)		
		   )
		) );
	}

	/**
	* Image Box With Caption
	*/
	if (!function_exists('ozy_vc_imageboxwithcaption')) {
		function ozy_vc_imageboxwithcaption( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_imageboxwithcaption', $atts);
			extract(shortcode_atts(array(
				'image'			=> '',
				'caption'		=> '',
				'icon'			=> '',
				'fn_color'		=> '#ffffff',
				'bg_color'		=> '#000000',
				'tag' 			=> 'SEE MORE',
				'link'			=> '',
				'link_target'	=> '_self',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		
			
			$rand_id = "image-with-caption-" . rand(1,10000);
			
			$output = '<a href="'. esc_attr($link) .'" target="'. esc_attr($link_target) .'" class="ozy-image-with-caption" id="'. $rand_id .'">' . PHP_EOL;

			$image = wp_get_attachment_image_src($image, 'full');
			if(isset($image[0])) {
				$output .= '<figure>';
				if($icon) {
					$output .= '<span><i class="'. esc_attr($icon) .'"></i></span>';
				}
				$output .= '<img src="'. $image[0] .'" alt="' . esc_attr($caption) . '"/>';
				$output .= '</figure>';
			}
			
			$output .= '<section>';
			$output .= '<h5>'. esc_attr($caption) .'</h5>';
			if(esc_attr($tag)) {
				$output .= '<span class="tag">'. esc_attr($tag) .'</span>';
			}	
			$output .= '</section>';
				
			//$output .= do_shortcode( $content );
			$output .= PHP_EOL .'</a>';
			
			global $ozyHelper;
			$ozyHelper->set_footer_style("#$rand_id h5,#$rand_id {color:". esc_attr($fn_color) ." !important;}");
			$ozyHelper->set_footer_style("#$rand_id span.tag{background-color:". esc_attr($fn_color) .";color:". esc_attr($bg_color) .";}");
			$ozyHelper->set_footer_style("#$rand_id figure>span{background-color:". $ozyHelper->hex2rgba($bg_color, '0.7') .";}");		
			$ozyHelper->set_footer_style("#$rand_id>section{background-color:". $bg_color .";}");
			
			return $output;
		}
		
		add_shortcode('ozy_vc_imageboxwithcaption', 'ozy_vc_imageboxwithcaption');
		
		vc_map( array(
			"name" => __("Image Box With Caption", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_imageboxwithcaption",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Image", "ozy-coiffeur-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => ""
				),		
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Caption", "ozy-coiffeur-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => __("Box Title", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "select_an_icon",
					"heading" => __("Hover Icon", "ozy-coiffeur-essentials"),
					"param_name" => "icon",
					"value" => '',
					"admin_label" => false
				),			
				array(
					"type" => "colorpicker",
					"heading" => __("Foreground Color", "ozy-coiffeur-essentials"),
					"param_name" => "fn_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Tag Background Color", "ozy-coiffeur-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "#000000"
				),					
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Tag", "ozy-coiffeur-essentials"),
					"param_name" => "tag",
					"admin_label" => true,
					"value" => __("SEE MORE", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => true
				),
				array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				),	
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   )
		) );
	}

	/**
	* Colored Content Box
	*/
	if (!function_exists('ozy_vc_coloredcontentbox')) {
		function ozy_vc_coloredcontentbox( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_coloredcontentbox', $atts);
			extract(shortcode_atts(array(
				'image'			=> '',
				'caption'		=> 'Caption Goes Here',
				'hover_caption' => 'SHOP NOW',
				'fn_color'		=> '#ffffff',
				'bg_color'		=> '#e42039',
				'tag' 			=> 'SAY SOMETHING',
				'link'			=> '',
				'link_target'	=> '_self',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		
			
			$rand_id = "fancybox-" . rand(1,10000);
			
			$output = '<a href="'. esc_attr($link) .'" target="'. esc_attr($link_target) .'" class="ozy-colored-content-box" id="'. $rand_id .'">' . PHP_EOL;

			$image = wp_get_attachment_image_src($image, 'full');
			if(isset($image[0])) {
				$output .= '<img src="'. $image[0] .'" alt="' . esc_attr($caption) . '"/>';
			}
			
			$output .= '<section class="overlay">';
			$output .= '<span class="caption heading-font">'. esc_attr($caption) .'</span>';
			if(esc_attr($tag)) {
				$output .= '<span class="tag">'. esc_attr($tag) .'</span>';
			}	
			$output .= '</section>';
			$output .= '<section class="overlay-two">';
			$output .= '<h3 class="ozy-vertical-centered-element">'. esc_attr($hover_caption) .'</h3>';
			$output .= '</section>';
				
			//$output .= do_shortcode( $content );
			$output .= PHP_EOL .'</a>';
			
			global $ozyHelper;
			$ozyHelper->set_footer_style("#$rand_id>section>span,#$rand_id>section>h3{color:". esc_attr($fn_color) .";}");
			$ozyHelper->set_footer_style("#$rand_id>section>span.caption{background-color:". $bg_color .";color:". esc_attr($fn_color) .";}");
			$ozyHelper->set_footer_style("#$rand_id>section.overlay-two{background-color:". $bg_color .";}");		
			$ozyHelper->set_footer_style("#$rand_id:hover>section.overlay-two{background-color:". $ozyHelper->hex2rgba($bg_color, '0.7') .";}");
			
			return $output;
		}
		
		add_shortcode('ozy_vc_coloredcontentbox', 'ozy_vc_coloredcontentbox');
		
		vc_map( array(
			"name" => __("Colored Cotent Box", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_coloredcontentbox",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Image", "ozy-coiffeur-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => ""
				),		
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Caption", "ozy-coiffeur-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => __("Caption Goes Here", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Hover Caption", "ozy-coiffeur-essentials"),
					"param_name" => "hover_caption",
					"admin_label" => false,
					"value" => __("SHOP NOW", "ozy-coiffeur-essentials")
				),			
				array(
					"type" => "colorpicker",
					"heading" => __("Foreground Color", "ozy-coiffeur-essentials"),
					"param_name" => "fn_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Tag Background Color", "ozy-coiffeur-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "#e42039"
				),					
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Tag", "ozy-coiffeur-essentials"),
					"param_name" => "tag",
					"admin_label" => true,
					"value" => __("SAY SOMETHING", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => true
				),
				array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				),	
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   )
		) );
	}

	/**
	* Fancy Image Box
	*/
	if (!function_exists('ozy_vc_fancyimagebox')) {
		function ozy_vc_fancyimagebox( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_fancyimagebox', $atts);
			extract(shortcode_atts(array(
				'image'			=> '',
				'caption'		=> '',
				'excerpt'		=> '',
				'fn_color'		=> '#ffffff',
				'bg_color'		=> '#000000',
				'tag' 			=> 'MORE',
				'link'			=> '',
				'link_target'	=> '_self',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		
			
			$rand_id = "fancybox-" . rand(1,10000);
			
			$output = '<a href="'. esc_attr($link) .'" target="'. esc_attr($link_target) .'" class="ozy-fancyimagebox" id="'. $rand_id .'">' . PHP_EOL;

			$image = wp_get_attachment_image_src($image, 'full');
			if(isset($image[0])) {
				$output .= '<img src="'. $image[0] .'" alt="' . esc_attr($caption) . '"/>';
			}
			
			$output .= '<section>';
			$output .= '<h2 style="display:none">'. esc_attr($caption) .'</h2>';
			$output .= '<section>';	
			if(esc_attr($tag)) {
				$output .= '<span class="tag">'. esc_attr($tag) .'</span>';
			}	
			$output .= '<h2>'. esc_attr($caption) .'</h2>';
			if(esc_attr($excerpt)) {
				$output .= '<span class="line"></span>';
				$output .= '<p>'. esc_attr($excerpt) .'</p>';
			}
			$output .= '</section>';
			$output .= '</section>';
				
			//$output .= do_shortcode( $content );
			$output .= PHP_EOL .'</a>';
			
			global $ozyHelper;
			$ozyHelper->set_footer_style("#$rand_id h2,#$rand_id p,#$rand_id {color:". esc_attr($fn_color) ." !important;}");
			$ozyHelper->set_footer_style("#$rand_id>section>section>span{border-color:". esc_attr($fn_color) .";}");
			$ozyHelper->set_footer_style("#$rand_id>section>section>span.tag{background-color:". $ozyHelper->hex2rgba($bg_color, '0.4') .";}");		
			
			return $output;
		}
		
		add_shortcode('ozy_vc_fancyimagebox', 'ozy_vc_fancyimagebox');
		
		vc_map( array(
			"name" => __("Fancy Image Box", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_fancyimagebox",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Image", "ozy-coiffeur-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => ""
				),		
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Caption", "ozy-coiffeur-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => __("Box Title", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "textarea",
					"class" => "",
					"heading" => __("Excerpt", "ozy-coiffeur-essentials"),
					"param_name" => "excerpt",
					"admin_label" => false
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Foreground Color", "ozy-coiffeur-essentials"),
					"param_name" => "fn_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),
				array(
					"type" => "colorpicker",
					"heading" => __("Tag Background Color", "ozy-coiffeur-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "#000000"
				),					
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Tag", "ozy-coiffeur-essentials"),
					"param_name" => "tag",
					"admin_label" => true,
					"value" => __("MORE", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => true
				),
				array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				),	
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   )
		) );
	}

	/**
	* Fancy Post Accordion
	*/
	if (!function_exists('ozy_vc_fancypostaccordion_feed')) {
		function ozy_vc_fancypostaccordion_feed( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_fancypostaccordion_feed', $atts);
			extract(shortcode_atts(array(
				'link_caption' 		=> 'Find out more →',
				'link_target'		=> '_self',
				'posts_per_page'	=> '6',
				'css_animation' 	=> ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		

			$output = '<div class="ozy-fancyaccordion-feed">' . PHP_EOL;

			$args = array(
				'post_type' 			=> 'post',
				'posts_per_page'		=> esc_attr($posts_per_page),
				'orderby' 				=> 'date',
				'order' 				=> 'DESC',
				'ignore_sticky_posts' 	=> 1,
			);

			$the_query = new WP_Query( $args );
				
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$output .= '<a href="'. get_permalink() .'" target="'. esc_attr($link_target) .'" class="ozy-border-color"><span>';
				$output .= '<div class="d ozy-border-color"><h3>'. get_the_date('d.m.Y') .'</h3></div>';
				$output .= '<h3 class="t">'. get_the_title() .'</h3>';
				
				$categories = get_the_terms(get_the_ID(), 'category');
				if(is_array($categories)) {
					$output .= '<span class="category generic-button">';
					$comma = '';			
					foreach ($categories as $cat) {
						$output .= $comma . $cat->name;
						$comma = ', ';
					}
					$output .= '</span>';
				}
				
				$output .= '<span class="plus-icon"><span class="h"></span><span class="v"></span></span>';
				$output .= '</span></a>';
				$output .= '<div class="panel ozy-border-color"><div>' . ozy_excerpt_max_charlength(200, true, false) . '<p>';
				$output .= '<a href="'. get_permalink() .'">'. esc_attr($link_caption) .'</a>';
				$output .= '</p></div></div>';
			}
			wp_reset_postdata();
			
			$output.= do_shortcode( $content );
			$output.= PHP_EOL .'</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_fancypostaccordion_feed', 'ozy_vc_fancypostaccordion_feed');
		
		vc_map( array(
			"name" => __("Fancy Post List", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_fancypostaccordion_feed",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link Caption", "ozy-coiffeur-essentials"),
					"param_name" => "link_caption",
					"admin_label" => true,
					"value" => __("Find out more →", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				),					
				array(
					"type" => "dropdown",
					"heading" => __("Item Count", "ozy-coiffeur-essentials"),
					"param_name" => "posts_per_page",
					"value" => array("6", "1", "2", "3", "4", "5", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"),
					"admin_label" => true,
					"description" => __("How many post will be shown on the list.", "ozy-coiffeur-essentials")
				),
				$add_css_animation
		   )
		) );
	}

	/**
	* Post List With Title
	*/
	if (!function_exists('ozy_vc_postlistwithtitle_feed')) {
		function ozy_vc_postlistwithtitle_feed( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_postlistwithtitle_feed', $atts);
			extract(shortcode_atts(array(
				'posts_per_page'	=> '8',
				'extra_css'			=> '',
				'css_animation' 	=> ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		

			$output = '<div class="ozy-postlistwithtitle-feed">' . PHP_EOL;

			$args = array(
				'post_type' 			=> 'post',
				'posts_per_page'		=> esc_attr($posts_per_page),
				'orderby' 				=> 'date',
				'order' 				=> 'DESC',
				'ignore_sticky_posts' 	=> 1
			);

			$the_query = new WP_Query( $args );
				
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				$output .= '<a href="'. get_permalink() .'" class="ozy-border-color">';
				$output .= '<h2>'. get_the_title() .'</h2>';
				$output .= '<p>'. get_the_date() .'</p>';
				$output .= '<p>';
				$output .= strip_tags(get_the_category_list(', '));
				$output .= '</p>';
				$output .= '</a>';
			}
			wp_reset_postdata();
			
			$output.= do_shortcode( $content );
			$output.= PHP_EOL .'</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_postlistwithtitle_feed', 'ozy_vc_postlistwithtitle_feed');
		
		vc_map( array(
			"name" => __("Post List With Title", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_postlistwithtitle_feed",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => __("Post Count", "ozy-coiffeur-essentials"),
					"param_name" => "posts_per_page",
					"value" => "8",
					"admin_label" => true
				),		
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   )
		) );
	}

	/**
	* Mail Chimp
	*/
	if (!function_exists('ozy_vc_mailchimp') && function_exists('mailchimpSF_signup_form')) {
		function ozy_vc_mailchimp( $atts, $content = null ) {	    
			$atts = vc_map_get_attributes('ozy_vc_mailchimp', $atts);
			extract(shortcode_atts(array(
				'css_animation' => ''
				), $atts ) 
			);
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}
			
			return '<div class="wpb_content_element">'. do_shortcode('[mailchimpsf_form]') .'</div>';		
		}
		
		add_shortcode('ozy_vc_mailchimp', 'ozy_vc_mailchimp');
		
		vc_map( array(
			"name" => __("Mail Chimp", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_mailchimp",
			"content_element" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				$add_css_animation	
		   )
		) );
	}

	/**
	* Anything Wrapper 2
	*/
	if (!function_exists('ozy_vc_anywrapper2')) {
		function ozy_vc_anywrapper2( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_anywrapper2', $atts);
			extract(shortcode_atts(array(
				'vertical_position' => 'center',
				'horizontal_position' => 'center',
				'width' => '50%',
				'text_align' => 'left',
				'padding_top' => '30px',
				'padding_right' => '30px',
				'padding_bottom' => '30px',
				'padding_left' => '30px'
			), $atts));
			
			$style = 'ozy-anything-wrapper-x';
			$style .= ' v-' . $vertical_position;
			$style .= ' h-' . $horizontal_position;
			
			return '<div class="'. $style .'" style="text-align:'. esc_attr($text_align) .';width:'. esc_attr($width) .';padding:'. esc_attr($padding_top) .' '. esc_attr($padding_right) .' '. esc_attr($padding_bottom) .' '. esc_attr($padding_left) .'">'. do_shortcode($content) .'</div>';
		}
		
		add_shortcode('ozy_vc_anywrapper2', 'ozy_vc_anywrapper2');
		
		vc_map( array(
			"name" => __("Anything Wrapper 2", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_anywrapper2",
			"as_parent" => array('except' => 'ozy_vc_iabox,ozy_vc_flipbox'),
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Vertical Position", "ozy-coiffeur-essentials"),
					"param_name" => "vertical_position",
					"admin_label" => true,
					"value" => array("center","top","bottom")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Horizontal Position", "ozy-coiffeur-essentials"),
					"param_name" => "horizontal_position",
					"admin_label" => true,
					"value" => array("center","left","right")
				),
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Width", "ozy-coiffeur-essentials"),
					"param_name" => "width",
					"admin_label" => true,
					"value" => "50%"
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Text Align", "ozy-coiffeur-essentials"),
					"param_name" => "text_align",
					"admin_label" => true,
					"value" => array("left","center","right")
				),						
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding Top", "ozy-coiffeur-essentials"),
					"param_name" => "padding_top",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding Right", "ozy-coiffeur-essentials"),
					"param_name" => "padding_right",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding Bottom", "ozy-coiffeur-essentials"),
					"param_name" => "padding_bottom",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding Left", "ozy-coiffeur-essentials"),
					"param_name" => "padding_left",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				)									
		   ),
		   "js_view" => 'VcColumnView'
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Anywrapper2 extends WPBakeryShortCodesContainer{}

	/**
	* Anything Wrapper
	*/
	if (!function_exists('ozy_vc_anywrapper')) {
		function ozy_vc_anywrapper( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_anywrapper', $atts);
			extract(shortcode_atts(array(
				'padding_top' => '30px',
				'padding_right' => '30px',
				'padding_bottom' => '30px',
				'padding_left' => '30px'
			), $atts));
			
			return '<div class="ozy-anything-wrapper" style="display:inline-block;width:100%;padding:'. esc_attr($padding_top) .' '. esc_attr($padding_right) .' '. esc_attr($padding_bottom) .' '. esc_attr($padding_left) .'">'. do_shortcode($content) .'</div>';
		}
		
		add_shortcode('ozy_vc_anywrapper', 'ozy_vc_anywrapper');
		
		vc_map( array(
			"name" => __("Anything Wrapper", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_anywrapper",
			"as_parent" => array('except' => 'ozy_vc_iabox,ozy_vc_flipbox'),
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding Top", "ozy-coiffeur-essentials"),
					"param_name" => "padding_top",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding Right", "ozy-coiffeur-essentials"),
					"param_name" => "padding_right",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding Bottom", "ozy-coiffeur-essentials"),
					"param_name" => "padding_bottom",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding Left", "ozy-coiffeur-essentials"),
					"param_name" => "padding_left",
					"admin_label" => true,
					"value" => array("30px","0","5px","10px","15px","20px","25px","35px","40px","45px","50px","55px","60px","65px","70px","75px","80px","85px","90px","95px","100px","105px","110px","115px","120px","125px","130px","135px","140px","145px","150px","155px","160px","165px","170px","175px","180px","185px","190px","195px","200px")
				)									
		   ),
		   "js_view" => 'VcColumnView'
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Anywrapper extends WPBakeryShortCodesContainer{}

	/**
	* Styled Heading
	*/
	if (!function_exists('ozy_vc_sheading')) {
		function ozy_vc_sheading( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_sheading', $atts);
			extract(shortcode_atts(array(
				'caption' 		=> '',
				'caption_size'	=> 'h1',
				'caption_position'=> 'center',
				'border_style'	=> 'solid',
				'border_size'	=> '1px',
				'accent_color' 	=> '#000',
				'bg_color' 		=> '',
				'padding' 		=> '5px',
				'css_animation' => ''
				), $atts ) 
			);
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}

			$padding = esc_attr($padding) . ' ' . ((int)esc_attr($padding)+5) . 'px';

			return '<div class="wpb_content_element" style="text-align:'. esc_attr($caption_position) .';"><'. esc_attr($caption_size) .' style="border:'. esc_attr($border_size) .' '. esc_attr($border_style) .' '. esc_attr($accent_color) . (esc_attr($bg_color) ? ';background-color:' . esc_attr($bg_color) : '') .';color:'. esc_attr($accent_color) .';padding:'. $padding .';display:inline-block;">'. esc_attr($caption) .'</'. esc_attr($caption_size) .'></div>';//line-height:inherit;
		}

		add_shortcode('ozy_vc_sheading', 'ozy_vc_sheading');

		vc_map( array(
		   "name" => __("Styled Heading", "ozy-coiffeur-essentials"),
		   "base" => "ozy_vc_sheading",
		   "class" => "",
		   "controls" => "full",
		   'category' => 'by OZY',
		   "icon" => "icon-wpb-ozy-el",
		   "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Caption", "ozy-coiffeur-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => __("Enter your caption here", "ozy-coiffeur-essentials"),
					"description" => __("Caption of the component.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Caption Size", "ozy-coiffeur-essentials"),
					"param_name" => "caption_size",
					"admin_label" => true,
					"value" => array("h1", "h2", "h3", "h4", "h5", "h6")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Caption Position", "ozy-coiffeur-essentials"),
					"param_name" => "caption_position",
					"admin_label" => true,
					"value" => array("center", "left", "right")
				),						
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Border Style", "ozy-coiffeur-essentials"),
					"param_name" => "border_style",
					"admin_label" => true,
					"value" => array("solid","dotted","dashed","double")
				),
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Border Size", "ozy-coiffeur-essentials"),
					"param_name" => "border_size",
					"admin_label" => true,
					"value" => array("0","1px","2px","3px","4px","5px","6px","7px","8px","9px","10px")
				),			
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Accent Color", "ozy-coiffeur-essentials"),
					"param_name" => "accent_color",
					"admin_label" => false,
					"value" => "#000"
				),
				array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Background Color", "ozy-coiffeur-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "#fff"
				),			
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Padding", "ozy-coiffeur-essentials"),
					"param_name" => "padding",
					"admin_label" => true,
					"value" => array("5px","10px","15px","20px","25px","30px","35px","40px","45px","50px")
				),$add_css_animation
			)
		) );
	}

	/**
	* Flip Box
	*/
	if (!function_exists('ozy_vc_flipbox')) {
		function ozy_vc_flipbox( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_flipbox', $atts);
			extract(shortcode_atts(array(
				'front_icon' => '',
				'front_title' => '',
				'front_excerpt' => '',
				'front_bg_color' => '',
				'front_fg_color' => '#222222',
				'front_bg_image' => '',
				'back_icon' => '',
				'back_title' => '',
				'back_excerpt' => '',
				'back_bg_color' => '#222222',
				'back_fg_color' => '#ffffff',
				'back_bg_image' => '',
				'direction' => 'horizontal',
				'height' => '427',
				'link' => '',
				'link_target' => '_self'
			), $atts));

			global $ozyHelper;

			$front_bg_image = wp_get_attachment_image_src(esc_attr($front_bg_image), 'full');
			$back_bg_image 	= wp_get_attachment_image_src(esc_attr($back_bg_image), 'full');
			
			$front_bg 	= $ozyHelper->background_style_render(esc_attr($front_bg_color), (isset($front_bg_image[0]) ? $front_bg_image[0]:''), '', '', '', '', '', '');
			$back_bg 	= $ozyHelper->background_style_render(esc_attr($back_bg_color), (isset($back_bg_image[0]) ? $back_bg_image[0]:''), '', '', '', '', '', '');
			
			return '<div class="flip-container '. esc_attr($direction) .' wpb_content_element" ontouchstart="this.classList.toggle(\'hover\');" style="height:'. esc_attr($height).'px;">
					<a class="flipper" '. (esc_attr($link) ? 'href="'. esc_attr($link) .'" target="'. esc_attr($link_target) .'"' : '') .'>
						<span class="front" style="'. $front_bg .'">
							'. (esc_attr($front_icon) ? '<i style="color:'. esc_attr($front_fg_color) .'" class="'. esc_attr($front_icon) .'"></i>' : '') .'
							'. (esc_attr($front_title) ? '<h3 style="color:'. esc_attr($front_fg_color) .'">'. esc_attr($front_title) .'</h3>' : '') .'
							'. (esc_attr($front_excerpt) ? '<p style="color:'. esc_attr($front_fg_color) .'">'. nl2br(strip_tags($front_excerpt)) .'</p>' : '') .'
						</span>
						<span class="back" style="'. $back_bg .'">
							'. (esc_attr($back_icon) ? '<i style="color:'. esc_attr($back_fg_color) .'" class="'. esc_attr($back_icon) .'"></i>' : '') .'
							'. (esc_attr($back_title) ? '<h3 style="color:'. esc_attr($back_fg_color) .'">'. esc_attr($back_title) .'</h3>' : '') .'
							'. (esc_attr($back_excerpt) ? '<p style="color:'. esc_attr($back_fg_color) .'">'. nl2br(strip_tags($back_excerpt)) .'</p>' : '') .'
						</span>
					</a>
				</div>';		
		}
		
		add_shortcode( 'ozy_vc_flipbox', 'ozy_vc_flipbox' );
		
		vc_map( array(
			"name" => __("Flip Box", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_flipbox",
			"content_element" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "select_an_icon",
					"heading" => __("Front Icon", "ozy-coiffeur-essentials"),
					"param_name" => "front_icon",
					"value" => '',
					"admin_label" => false
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Front Title", "ozy-coiffeur-essentials"),
					"param_name" => "front_title",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textarea",
					"class" => "",
					"heading" => __("Front Excerpt", "ozy-coiffeur-essentials"),
					"param_name" => "front_excerpt",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Front Background Image", "ozy-coiffeur-essentials"),
					"param_name" => "front_bg_image",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Front Background Color", "ozy-coiffeur-essentials"),
					"param_name" => "front_bg_color",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Front Foreground Color", "ozy-coiffeur-essentials"),
					"param_name" => "front_fg_color",
					"admin_label" => true,
					"value" => "#222222"
				),array(
					"type" => "select_an_icon",
					"heading" => __("Back Icon", "ozy-coiffeur-essentials"),
					"param_name" => "back_icon",
					"value" => '',
					"admin_label" => false
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Back Title", "ozy-coiffeur-essentials"),
					"param_name" => "back_title",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textarea",
					"class" => "",
					"heading" => __("Back Excerpt", "ozy-coiffeur-essentials"),
					"param_name" => "back_excerpt",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Back Background Image", "ozy-coiffeur-essentials"),
					"param_name" => "back_bg_image",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Back Background Color", "ozy-coiffeur-essentials"),
					"param_name" => "back_bg_color",
					"admin_label" => true,
					"value" => "#222222"
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Back Foreground Color", "ozy-coiffeur-essentials"),
					"param_name" => "back_fg_color",
					"admin_label" => true,
					"value" => "#ffffff"
				),array(
					"type" => "dropdown",
					"heading" => __("Direction", "ozy-coiffeur-essentials"),
					"param_name" => "direction",
					"value" => array("horizontal", "vertical"),
					"admin_label" => true
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Height", "ozy-coiffeur-essentials"),
					"param_name" => "height",
					"admin_label" => true,
					"value" => "427",
					"description" => __("Please enter only integer values. Will be processed in pixels.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				)
		   )
		) );	
	}

	/**
	* Textillate
	*/
	if (!function_exists('ozy_vc_textillate')) {
		function ozy_vc_textillate( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_textillate', $atts);
			extract(shortcode_atts(array(
				'size' 				=> '22px',
				'display_time' 		=> '2000',
				'font_color' 		=> '#000000',
				'font_weight' 		=> '300',
				'in_effect' 		=> 'fadeInLeftBig',
				'in_effect_type'	=> 'sequence',
				'out_effect' 		=> 'hinge',
				'out_effect_type'	=> 'shuffle',
				'loop'				=> 'true',
				'align'				=> ''
			), $atts));
			
			switch ($align) {
				case 'right':
					$align = 'width:100%;display:inline-block;text-align:right;';
					break;
				case 'center':
					$align = 'width:100%;display:inline-block;text-align:center;';
					break;
				default:
					$align = '';
			}
			
			$output = '<div class="ozy-tlt" style="'. $align .'color:'. esc_attr($font_color) .';font-weight:'. esc_attr($font_weight) .';font-size:'. esc_attr($size) .'px;line-height:'. ((int)esc_attr($size)+10) .'px" data-display_time="'. esc_attr($display_time) .'" data-in_effect="'. esc_attr($in_effect) .'" data-in_effect_type="'. esc_attr($in_effect_type) .'" data-out_effect="'. esc_attr($out_effect) .'" data-out_effect_type="'. esc_attr($out_effect_type) .'" data-loop="'. esc_attr($loop) .'">';
			$content = explode("<br />", $content);
			if(is_array($content)) {
				$output.= '<ul class="ozy-tlt-texts" style="display: none">';
				foreach($content as $line) {
					$output.= '<li>'. trim($line) .'</li>';
				}
				$output.= '</ul>';
			}
			$output.= '</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_textillate', 'ozy_vc_textillate');

		vc_map( array(
			"name" => __("Textillate", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_textillate",
			"content_element" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textarea",
					"class" => "",
					"heading" => __("Content", "ozy-coiffeur-essentials"),
					"param_name" => "content",
					"admin_label" => true,
					"description" => __('Each line will be processed as a slide.', 'ozy-coiffeur-essentials'),
					"value" => ""
				),array(
					"type" => "dropdown",
					"heading" => __("Size", "ozy-coiffeur-essentials"),
					"param_name" => "size",
					"value" => array("12", "14", "16", "18", "20", "22", "24", "26", "28", "30", "32", "34", "36", "38", "40", "42", "44", "46", "48", "50", "52", "54", "56", "58", "60", "62", "64", "66", "68", "70", "72", "74", "76", "78", "80", "90", "92", "94", "96", "98", "100"),
					"admin_label" => true
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Display Time", "ozy-coiffeur-essentials"),
					"param_name" => "display_time",
					"admin_label" => true,
					"description" => __('Sets the minimum display time for each text before it is replaced.', 'ozy-coiffeur-essentials'),
					"value" => "2000"
				),array(
					"type" => "dropdown",
					"heading" => __("Loop", "ozy-coiffeur-essentials"),
					"param_name" => "loop",
					"value" => array("true", "false"),
					"admin_label" => true
				),array(
					"type" => "colorpicker",
					"heading" => __("Color", "ozy-coiffeur-essentials"),
					"param_name" => "font_color",
					"admin_label" => false,
					"value" => "",
					"description" => __("Color of your text.", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"heading" => __("Font Weight", "ozy-coiffeur-essentials"),
					"param_name" => "font_weight",
					"value" => array("300", "100", "200", "400", "500" , "600", "700", "800", "900"),
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => __("In Animation Effect", "ozy-coiffeur-essentials"),
					"param_name" => "in_effect",
					"value" => $animate_css_effects,
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => __("In Animation Type", "ozy-coiffeur-essentials"),
					"param_name" => "in_effect_type",
					"value" => array("sequence", "reverse", "sync", "shuffle"),
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => __("Out Animation Effect", "ozy-coiffeur-essentials"),
					"param_name" => "out_effect",
					"value" => $animate_css_effects,
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => __("Out Animation Type", "ozy-coiffeur-essentials"),
					"param_name" => "out_effect_type",
					"value" => array("sequence", "reverse", "sync", "shuffle"),
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => __("Text Align", "ozy-coiffeur-essentials"),
					"param_name" => "align",
					"value" => array("left", "center", "right"),
					"admin_label" => true
				)								
		   )
		) );
	}


	/**
	* Floating Box
	*/
	if (!function_exists('ozy_vc_floatingbox')) {
		function ozy_vc_floatingbox( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_floatingbox', $atts);
			extract(shortcode_atts(array(
				'height' => '300px',
				'align' => 'left'
			), $atts));
			
			return '<div class="ozy-floating-box" style="height:'. esc_attr($height) .';text-align:'. esc_attr($align) .'"><div>'. do_shortcode($content) .'</div></div>';
		}
		
		add_shortcode('ozy_vc_floatingbox', 'ozy_vc_floatingbox');
		
		vc_map( array(
			"name" => __("Floating Box", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_floatingbox",
			"as_parent" => array('except ' => ''),
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"heading" => __("Height", "ozy-coiffeur-essentials"),
					"param_name" => "height",
					"value" => "300px",
					"description" => __("Please set same height as your row height as initial value, in order to make it work as expected", "ozy-coiffeur-essentials"),
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => __("Content Align", "ozy-coiffeur-essentials"),
					"param_name" => "align",
					"value" => array("left", "center", "right"),
					"admin_label" => true
				)			
		   ),
		   "js_view" => 'VcColumnView'
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Floatingbox extends WPBakeryShortCodesContainer{}

	/**
	* Morph Text
	*/
	if (!function_exists('ozy_vc_morphtext')) {
		function ozy_vc_morphtext( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_morphtext', $atts);
			extract(shortcode_atts(array(
				'text_before'	=> '',
				'text_after' 	=> '',
				'text_rotate'	=> '',
				'size' 			=> 'h1',
				'font_color' 	=> '#000000',
				'rotating_color'=> '#000000',
				'separator' 	=> ',',
				'effect' 		=> 'bounceIn',
				'speed' 		=> '2000'
			), $atts));
			
			return '<div><'. esc_attr($size) .' class="ozy-morph-text" style="color:'. esc_attr($font_color) .'" data-separator="'. esc_attr($separator) .'" data-effect="'. esc_attr($effect) .'" data-speed="'. esc_attr($speed) .'"><span class="bt">'. esc_attr($text_before) .'</span> <span class="text-rotate" style="color:'. esc_attr($rotating_color) .'">'. esc_attr($text_rotate) .'</span> '. esc_attr($text_after) .'</'. esc_attr($size) .'"></div>';
		}
		
		add_shortcode('ozy_vc_morphtext', 'ozy_vc_morphtext');

		vc_map( array(
			"name" => __("Morph Text", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_morphtext",
			"content_element" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Before Rotating Text", "ozy-coiffeur-essentials"),
					"param_name" => "text_before",
					"admin_label" => true,
					"description" => __('This text will be shown before rotating text.', 'ozy-coiffeur-essentials'),
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("After Rotating Text", "ozy-coiffeur-essentials"),
					"param_name" => "text_after",
					"admin_label" => true,
					"description" => __('This text will be shown after rotating text.', 'ozy-coiffeur-essentials'),
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Rotating Text", "ozy-coiffeur-essentials"),
					"param_name" => "text_rotate",
					"admin_label" => true,
					"description" => __('Use separator between words, default ",". Seperator could be managed by the box below.', 'ozy-coiffeur-essentials'),
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Separator", "ozy-coiffeur-essentials"),
					"param_name" => "separator",
					"admin_label" => true,
					"description" => __('If you don\'t want commas to be the separator, you can define a new separator (|, &, * etc.) by yourself using this field.', 'ozy-coiffeur-essentials'),
					"value" => ","
				),array(
					"type" => "dropdown",
					"heading" => __("Size", "ozy-coiffeur-essentials"),
					"param_name" => "size",
					"value" => array("h1", "h2", "h3", "h4", "h5", "h6"),
					"admin_label" => true
				),array(
					"type" => "colorpicker",
					"heading" => __("Color", "ozy-coiffeur-essentials"),
					"param_name" => "font_color",
					"admin_label" => false,
					"value" => "",
					"description" => __("Color of your text.", "ozy-coiffeur-essentials")
				),array(
					"type" => "colorpicker",
					"heading" => __("Rotating Text Color", "ozy-coiffeur-essentials"),
					"param_name" => "rotating_color",
					"admin_label" => false,
					"value" => "",
					"description" => __("Color of your rotating text.", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"heading" => __("Effect", "ozy-coiffeur-essentials"),
					"param_name" => "effect",
					"value" => $animate_css_effects,
					"admin_label" => true
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Speed", "ozy-coiffeur-essentials"),
					"param_name" => "speed",
					"admin_label" => true,
					"description" => __('How many milliseconds until the next word show.', 'ozy-coiffeur-essentials'),
					"value" => "2000"
				)						
		   )
		) );
	}

	/**
	* Spacer
	*/
	if (!function_exists('ozy_vc_spacer')) {
		function ozy_vc_spacer( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_spacer', $atts);
			extract(shortcode_atts(array(
				'size' 			=> '30px'
			), $atts));
			
			return '<div style="height:'. esc_attr($size) .'" class="ozy-spacer"></div>';
		}
		
		add_shortcode('ozy_vc_spacer', 'ozy_vc_spacer');

		vc_map( array(
			"name" => __("Spacer", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_spacer",
			"content_element" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Size", "ozy-coiffeur-essentials"),
					"param_name" => "size",
					"admin_label" => true,
					"description" => __('Enter size like 10px, 3em. Please don\'t use percentage values.', 'ozy-coiffeur-essentials'),
					"value" => "30px"
				)
		   )
		) );
	}

	/**
	* Royal Slider
	*/
	if (!function_exists('ozy_vc_slider')) {
		function ozy_vc_slider( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_slider', $atts);
			extract(shortcode_atts(array(
				'size' => 'auto',
				'width' => '100%',
				'height' => '',
				'slider_style' => 'horizontal'
			), $atts));
			
			wp_enqueue_script('royalslider');
			wp_enqueue_style('royalslider');
			wp_enqueue_style('rs-minimal-white');
			
			if('horizontal' === esc_attr($slider_style)) {
				$slider_style = esc_attr($slider_style);
			}else if('vertical' == esc_attr($slider_style)){
				$slider_style = '-' . esc_attr($slider_style);
			}		
			//wp_enqueue_style('rs-minimal-white');
			
			$style = '';
			if(trim($width)) {
				$style .= 'width:' . esc_attr($width) . ';';
			}
			if(trim($height)) {
				$style .= 'height:' . esc_attr($height);
			}
			
			$size_arr = array('auto' => 'auto-height-slider', 'fixed' => 'fixed-slider');
			
			if('full' != esc_attr($size)) {
				return '<div class="royalSlider rsMinW '. (strtr(esc_attr($size), $size_arr)) . ' ozy-slider ' . $slider_style .'" data-orientation="'. (esc_attr($slider_style)===''?'horizontal':'vertical') .'" style="'. $style .'">' . PHP_EOL . do_shortcode( $content ) . PHP_EOL .'</div>';
			}else{
				return '<div class="royalSlider rsMinW " data-orientation="'. (esc_attr($slider_style)===''?'horizontal':'vertical') .'" id="royal-classic-full">' . PHP_EOL . ozy_fix_unwanted_p(do_shortcode( $content )) . PHP_EOL .'</div>';
			}
		}
		
		add_shortcode('ozy_vc_slider', 'ozy_vc_slider');
		
		vc_map( array(
			"name" => __("Royal Slider", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_slider",
			"as_parent" => array('only' => 'ozy_vc_slide'),
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",	
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => __("Size", "ozy-coiffeur-essentials"),
					"param_name" => "size",
					"value" => array("auto", "fixed"),
					"admin_label" => true
				),		
				array(
					"type" => "textfield",
					"heading" => __("Width", "ozy-coiffeur-essentials"),
					"param_name" => "width",
					"value" => "100%",
					"admin_label" => true
				),		
				array(
					"type" => "textfield",
					"heading" => __("Height", "ozy-coiffeur-essentials"),
					"param_name" => "height",
					"value" => "",
					"admin_label" => true
				),
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   ),
		   "js_view" => 'VcColumnView'
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Slider extends WPBakeryShortCodesContainer{}

	if (!function_exists('ozy_vc_slide')) {
		function ozy_vc_slide( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_slide', $atts);
			extract(shortcode_atts(array(
				'src' => '',
				'video' => '',
				'caption_align' => 'BottomLeft', //BottomLeft,BottomRight
				'caption_style' => 'Black' //Black,White

			), $atts));
			
			$thumb = wp_get_attachment_image_src($src, 'full');
			if(isset($thumb[0])) {
				$src = $thumb[0];
			}
			
			$output = '<div class="rsContent" data-rsDelay="6000">';
			if($video) {
				$output.= '<a class="rsImg" data-rsvideo="'. esc_attr($video) .'" href="'. esc_attr($src) .'"></a>';
			}else{
				$output.= '<img class="rsImg" src="'. esc_attr($src) .'"/>';
			}
			if(trim($content)) {
				$output.= '<div class="infoBlock infoBlock'. esc_attr($caption_align) .' infoBlock'. esc_attr($caption_style) .' rsABlock" data-fade-effect="fa;se" data-move-offset="100" data-move-effect="bottom" data-speed="500">';
				$output.= str_replace('<br />', '', do_shortcode($content));
				$output.= '</div>';
			}
			$output.= '</div>';
			
			return $output;
		}
		
		add_shortcode( 'ozy_vc_slide', 'ozy_vc_slide' );
		
		vc_map( array(
			"name" => __("Royal Slider Slide", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_slide",
			"content_element" => true,
			"as_child" => array('only' => 'ozy_vc_slider'),
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Image", "ozy-coiffeur-essentials"),
					"param_name" => "src",
					"admin_label" => false,
					"value" => "",
					"description" => __("Select images for your slider.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Video Path", "ozy-coiffeur-essentials"),
					"param_name" => "video",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textarea_html",
					"class" => "",
					"heading" => __("Caption", "ozy-coiffeur-essentials"),
					"param_name" => "content",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "dropdown",
					"heading" => __("Caption Align", "ozy-coiffeur-essentials"),
					"param_name" => "caption_align",
					"value" => array("BottomLeft", "BottomRight"),
					"admin_label" => true
				),array(
					"type" => "dropdown",
					"heading" => __("Caption Style", "ozy-coiffeur-essentials"),
					"param_name" => "caption_style",
					"value" => array("Black", "White"),
					"admin_label" => true
				)
		   )
		) );	
	}

	class WPBakeryShortCode_Ozy_Vc_Slide extends WPBakeryShortCode{}

	/**
	* Instagram Carousel Feeder
	*/
	if (!function_exists('ozy_vc_instagramcarousel')) {
		function ozy_vc_instagramcarousel( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_instagramcarousel', $atts);
			extract(shortcode_atts(array(
				'user'			=> 'self',
				'autoplay'		=> '',
				'items'			=> '',
				'singleitem'	=> '',
				'slidespeed'	=> '',
				'autoheight'	=> '',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if(is_user_logged_in()) {
				return '<span class="alternate-text-color">' . __("This shortcode has been deprecated, please use *NEW* Instagram Feed [ozy_vc_instagram_new] instead.", "ozy-coiffeur-essentials") . '</span>';
			}
			return "";
		}
		
		add_shortcode('ozy_vc_instagramcarousel', 'ozy_vc_instagramcarousel');
		
		vc_map( array(
			"name" => __("Instagram Carousel", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_instagramcarousel",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			"deprecated" => "6.2",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("User ID", "ozy-coiffeur-essentials"),
					"param_name" => "user",
					"admin_label" => true,
					"value" => "self",
					"description" => __('Get your credentials manually <a href="http://freevision.me/instagram" class="open_instagram_credentials" target="_blank">get your user id and access token key here</a>.', "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Auto Play", "ozy-coiffeur-essentials"),
					"param_name" => "autoplay",
					"value" => array("true", "false", "1000", "2000", "3000", "4000", "5000", "6000", "7000", "8000", "9000", "10000"),
					"admin_label" => true,
					"description" => __("Change to any available integrer for example 3000 to play every 3 seconds. If you set it true default speed will be 5 seconds.", "ozy-coiffeur-essentials")
				),		
				array(
					"type" => "dropdown",
					"heading" => __("Item Count", "ozy-coiffeur-essentials"),
					"param_name" => "items",
					"value" => array("3", "1", "2", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"),
					"admin_label" => true,
					"description" => __("This variable allows you to set the maximum amount of items displayed at a time with the widest browser width.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Show Single Item?", "ozy-coiffeur-essentials"),
					"param_name" => "singleitem",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => __("Display only one item. Set Item Count to 1 to make it work as expected.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Slide Speed", "ozy-coiffeur-essentials"),
					"param_name" => "slidespeed",
					"value" => array("200", "100", "300", "400", "500", "600", "700", "800", "900", "1000", "1100", "1200", "1300", "1400", "1500", "1600", "1700", "1800", "1900", "2000"),
					"admin_label" => true,
					"description" => __("Slide speed in milliseconds.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Auto Height", "ozy-coiffeur-essentials"),
					"param_name" => "autoheight",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => __("Add height to owl-wrapper-outer so you can use diffrent heights on slides. Use it only for one item per page setting.", "ozy-coiffeur-essentials")
				),		
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   )
		) );
	}
	
	/**
	* Instagram Feed NEW
	*/
	if (!function_exists('ozy_vc_instagram_new')) {
		function ozy_vc_instagram_new( $atts, $content = null ) {
            $atts = vc_map_get_attributes('ozy_vc_instagram_new', $atts);
			extract(shortcode_atts(array(
				'user_id' => '',
				'num_items' => '10',
				'access_token' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_style( 'animate-css' );
				$css_animation = ' wpb_animate_when_almost_visible wpb_'. esc_attr($css_animation) .' '. esc_attr($css_animation) .' wpb_start_animation animated ';
			}

			return '<div class="ozy-instagram-gallery-wrapper '. $css_animation . '"><ul class="ozy-instagram-gallery new" data-userid="'. esc_attr($user_id) .'" data-numitems="'. esc_attr($num_items) .'" data-accesstoken="'. esc_attr($access_token) .'"></ul></div>';			
		}

		add_shortcode('ozy_vc_instagram_new', 'ozy_vc_instagram_new');
		
		vc_map( array(
			"name" => esc_attr__("*NEW* Instagram Feed", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_instagram_new",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("User ID", "ozy-coiffeur-essentials"),
					"param_name" => "user_id",
					"admin_label" => true,
					"value" => "",
					"description" => __('Get your credentials manually <a href="https://freevision.me/instagram" class="open_instagram_credentials" target="_blank">get your user id and access token key here</a>.', 'ozy-coiffeur-essentials'),
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Access Token Key", "ozy-coiffeur-essentials"),
					"param_name" => "access_token",
					"description" => __('Get your credentials manually <a href="https://freevision.me/instagram" class="open_instagram_credentials" target="_blank">get your user id and access token key here</a>.', 'ozy-coiffeur-essentials'),
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => esc_attr__("Number Of Items", "ozy-coiffeur-essentials"),
					"param_name" => "num_items",
					"admin_label" => true,
					"value" => "10",
				),$add_css_animation
		   )
		) );	
	}

	/**
	* WooCommerce Carousel
	*/
	if (!function_exists('ozy_vc_woocarousel')) {
		function ozy_vc_woocarousel( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_woocarousel', $atts);
			extract(shortcode_atts(array(
				'autoplay'		=> '',
				'items'			=> '',
				'singleitem'	=> '',
				'slidespeed'	=> '',
				'autoheight'	=> '',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if(!class_exists('woocommerce')) {
				return '<div>'. __('WooCommerce Plugin is not installed or activated', 'ozy-coiffeur-essentials') .'</div>';
			}
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		

			$output = '<div class="ozy-owlcarousel woocommerce-carousel '. $css_animation .'" data-autoplay="'. esc_attr($autoplay) .'" data-items="'. esc_attr($items) .'" data-singleitem="'. esc_attr($singleitem) .'" data-slidespeed="'. esc_attr($slidespeed) .'" data-paginationSpeed="800" data-autoheight="'. esc_attr($autoheight) .'">' . PHP_EOL;

			$args = array(
				'post_type' 			=> 'product',
				'posts_per_page'		=> '8',
				'orderby' 				=> 'date',
				'order' 				=> 'DESC',
				'ignore_sticky_posts' 	=> 1,							
				'meta_key' 				=> '_thumbnail_id'
			);

			$the_query = new WP_Query( $args );
				
			while ( $the_query->have_posts() ) {
				$the_query->the_post();
				global $product;
				
				$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'showbiz');

				$output .= '<div class="item item-extended">';
				$output .= '<figure>';
				if(isset($thumb[0])) {$output .= '<img class="lazyOwl" src="'. get_template_directory_uri() .'/images/blank-large.gif" data-src="'. $thumb[0] .'" alt="'. get_the_title() .'"/>';}else{$output .= '<img class="lazyOwl" src="'. get_template_directory_uri() .'/images/blank-large.gif" data-src="'. get_template_directory_uri() .'/images/blank-large.gif" alt=""/>';}
				$output .= '<div class="overlay">';
				$output .= '<div>';

				if ($product->is_in_stock()) {
					$link = array(
						'url' => '',
						'label' => '',
						'class' => ''
					);
					
					$handler = apply_filters( 'woocommerce_add_to_cart_handler', $product->get_type(), $product );
					
					switch ( $handler ) {
						case "variable" :
							$link['url'] = apply_filters( 'variable_add_to_cart_url', get_permalink( $product->get_id() ) );
							$link['label'] = apply_filters( 'variable_add_to_cart_text', __( 'SELECT OPTIONS', 'ozy-coiffeur-essentials' ) );
							break;
						case "grouped" :
							$link['url'] = apply_filters( 'grouped_add_to_cart_url', get_permalink( $product->get_id() ) );
							$link['label'] = apply_filters( 'grouped_add_to_cart_text', __( 'VIEW OPTIONS', 'ozy-coiffeur-essentials' ) );
							break;
						case "external" :
							$link['url'] = apply_filters( 'external_add_to_cart_url', get_permalink( $product->get_id() ) );
							$link['label'] = apply_filters( 'external_add_to_cart_text', __( 'READ MORE', 'ozy-coiffeur-essentials' ) );
							break;
						default :
							if ( $product->is_purchasable() ) {
								$link['url'] = apply_filters( 'add_to_cart_url', esc_url( $product->add_to_cart_url() ) );
								$link['label'] = apply_filters( 'add_to_cart_text', __( 'ADD TO CART', 'ozy-coiffeur-essentials' ) );
								$link['class'] = apply_filters( 'add_to_cart_class', 'add_to_cart_button' );
							} else {
								$link['url'] = apply_filters( 'not_purchasable_url', get_permalink( $product->get_id() ) );
								$link['label'] = apply_filters( 'not_purchasable_text', __( 'READ MORE', 'ozy-coiffeur-essentials' ) );
							}
						break;
					}
					$output .= apply_filters( 'woocommerce_loop_add_to_cart_link', 
						sprintf('<a href="%s" rel="nofollow" data-product_id="%s" data-product_sku="%s" class="%s button product_type_%s"><div class="btn-basket">%s</div></a>', 
						esc_url( $link['url'] ), 
						esc_attr( $product->get_id() ), 
						esc_attr( $product->get_sku() ), 
						esc_attr( $link['class'] ), 
						esc_attr( $product->get_type() ), 
						esc_html( $link['label'] ) ), $product, $link );
					$output .= '<a href="'. get_permalink() .'" class="product-details">'. __('SEE PRODUCT DETAILS', 'ozy-coiffeur-essentials') .'</a>';
				}else{
					$output .= '<a href="' . apply_filters( 'out_of_stock_add_to_cart_url', get_permalink( $product->get_id() ) ) .'" class="button">'. apply_filters( 'out_of_stock_add_to_cart_text', __( 'READ MORE', 'ozy-coiffeur-essentials' ) ) .'</a>';
				}
							
				$output .= '</div>';
				$output .= '</div>';
				$output .= '</figure>';
				$output .= '<div class="info">';
				$output .= '<h3 class="content-color">'. get_the_title() .'</h3>';
				$output .= '<h5 class="content-color-alternate">'. $product->get_price_html().'</h5>';
				$output .= '</div>';

				$output .= '</div>';			
			}
			wp_reset_postdata();
			
			$output.= do_shortcode( $content );
			$output.= PHP_EOL .'</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_woocarousel', 'ozy_vc_woocarousel');
		
		vc_map( array(
			"name" => __("WooCommerce Product Carousel", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_woocarousel",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(			
				array(
					"type" => "dropdown",
					"heading" => __("Auto Play", "ozy-coiffeur-essentials"),
					"param_name" => "autoplay",
					"value" => array("true", "false", "1000", "2000", "3000", "4000", "5000", "6000", "7000", "8000", "9000", "10000"),
					"admin_label" => true,
					"description" => __("Change to any available integrer for example 3000 to play every 3 seconds. If you set it true default speed will be 5 seconds.", "ozy-coiffeur-essentials")
				),		
				array(
					"type" => "dropdown",
					"heading" => __("Item Count", "ozy-coiffeur-essentials"),
					"param_name" => "items",
					"value" => array("3", "1", "2", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"),
					"admin_label" => true,
					"description" => __("This variable allows you to set the maximum amount of items displayed at a time with the widest browser width.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Show Single Item?", "ozy-coiffeur-essentials"),
					"param_name" => "singleitem",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => __("Display only one item. Set Item Count to 1 to make it work as expected.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Slide Speed", "ozy-coiffeur-essentials"),
					"param_name" => "slidespeed",
					"value" => array("200", "100", "300", "400", "500", "600", "700", "800", "900", "1000", "1100", "1200", "1300", "1400", "1500", "1600", "1700", "1800", "1900", "2000"),
					"admin_label" => true,
					"description" => __("Slide speed in milliseconds.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Auto Height", "ozy-coiffeur-essentials"),
					"param_name" => "autoheight",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => __("Add height to owl-wrapper-outer so you can use diffrent heights on slides. Use it only for one item per page setting.", "ozy-coiffeur-essentials")
				),		
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   )
		) );
	}


	/**
	* Owl Carousel Feeder
	*/
	if (!function_exists('ozy_vc_owlcarousel_feed')) {
		function ozy_vc_owlcarousel_feed( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_owlcarousel_feed', $atts);
			extract(shortcode_atts(array(
				'bg_color'		=> '',
				'link_caption' 	=> 'Find out more →',
				'link_target'	=> '',
				'default_overlay' => 'off',
				'autoplay'		=> '',
				'items'			=> '',
				'singleitem'	=> '',
				'slidespeed'	=> '',
				'autoheight'	=> '',
				'extra_css'		=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		

			$output = '<div class="ozy-owlcarousel with-feed '. $css_animation .'" data-autoplay="'. esc_attr($autoplay) .'" data-items="'. esc_attr($items) .'" data-singleitem="'. esc_attr($singleitem) .'" data-slidespeed="'. esc_attr($slidespeed) .'" data-paginationSpeed="800" data-autoheight="'. esc_attr($autoheight) .'">' . PHP_EOL;

			$args = array(
				'post_type' 			=> 'post',
				'posts_per_page'		=> '8',
				'orderby' 				=> 'date',
				'order' 				=> 'DESC',
				'ignore_sticky_posts' 	=> 1,							
				'meta_key' 				=> '_thumbnail_id'
			);

			$the_query = new WP_Query( $args );
				
			while ( $the_query->have_posts() ) {
				$the_query->the_post();

				$thumb = wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()), 'showbiz');

				$style = esc_attr($bg_color) ? ' style="background-color:'. esc_attr($bg_color) .';" ' : ''; //height:278px;
				$output .= '<div class="item item-extended" '. $style .'>';
				if(isset($thumb[0])) {
					$output .= '<img class="lazyOwl" src="'. get_template_directory_uri() .'/images/blank-large.gif" data-src="'. $thumb[0] .'" alt="'. get_the_title() .'"/>';
				}else{
					$output .= '<img class="lazyOwl" src="'. get_template_directory_uri() .'/images/blank-large.gif" data-src="'. get_template_directory_uri() .'/images/blank-large.gif" alt=""/>';
				}
				$output .= '<a href="'. get_permalink() .'" target="'. esc_attr($link_target) .'">';
				if(esc_attr($default_overlay) === 'on') {
					$output .= '<div class="overlay-two">';
					$output .= '<div>';
					$output .= '<h2>'. get_the_title() .'</h2>';
					$output .= '<h5>'. get_the_date() .'</h5>';
					$output .= '</div>';			
					$output .= '</div>';
				}
				$output .= '</a>';
				$output .= '</div>';			
			}
			wp_reset_postdata();
			
			$output.= do_shortcode( $content );
			$output.= PHP_EOL .'</div>';
			
			return $output;
		}
		
		add_shortcode('ozy_vc_owlcarousel_feed', 'ozy_vc_owlcarousel_feed');
		
		vc_map( array(
			"name" => __("Owl Carousel Feed", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_owlcarousel_feed",
			"content_element" => true,
			"show_settings_on_create" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "colorpicker",
					"heading" => __("Carousel Background", "ozy-coiffeur-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "",
					"description" => __("Not requrired. Select a background color for your item.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Hover Overlay?", "ozy-coiffeur-essentials"),
					"param_name" => "default_overlay",
					"value" => array("off", "on"),
					"admin_label" => false,
					"description" => __("ON/OFF default overlay on your items.", "ozy-coiffeur-essentials")
				),		
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link Caption", "ozy-coiffeur-essentials"),
					"param_name" => "link_caption",
					"admin_label" => true,
					"value" => __("Find out more →", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				),					
				array(
					"type" => "dropdown",
					"heading" => __("Auto Play", "ozy-coiffeur-essentials"),
					"param_name" => "autoplay",
					"value" => array("true", "false", "1000", "2000", "3000", "4000", "5000", "6000", "7000", "8000", "9000", "10000"),
					"admin_label" => true,
					"description" => __("Change to any available integrer for example 3000 to play every 3 seconds. If you set it true default speed will be 5 seconds.", "ozy-coiffeur-essentials")
				),		
				array(
					"type" => "dropdown",
					"heading" => __("Item Count", "ozy-coiffeur-essentials"),
					"param_name" => "items",
					"value" => array("3", "1", "2", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"),
					"admin_label" => true,
					"description" => __("This variable allows you to set the maximum amount of items displayed at a time with the widest browser width.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Show Single Item?", "ozy-coiffeur-essentials"),
					"param_name" => "singleitem",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => __("Display only one item. Set Item Count to 1 to make it work as expected.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Slide Speed", "ozy-coiffeur-essentials"),
					"param_name" => "slidespeed",
					"value" => array("200", "100", "300", "400", "500", "600", "700", "800", "900", "1000", "1100", "1200", "1300", "1400", "1500", "1600", "1700", "1800", "1900", "2000"),
					"admin_label" => true,
					"description" => __("Slide speed in milliseconds.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Auto Height", "ozy-coiffeur-essentials"),
					"param_name" => "autoheight",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => __("Add height to owl-wrapper-outer so you can use diffrent heights on slides. Use it only for one item per page setting.", "ozy-coiffeur-essentials")
				),		
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   )
		) );
	}

	/**
	* Owl Carousel
	*/
	if (!function_exists('ozy_vc_owlcarousel_wrapper')) {
		function ozy_vc_owlcarousel_wrapper( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_owlcarousel_wrapper', $atts);
			extract(shortcode_atts(array(
				'autoplay'		=> 'true',
				'items'			=> '4',
				'singleitem'	=> 'false',
				'slidespeed'	=> '200',
				'autoheight'	=> 'false',
				'extra_css'		=> '',
				'css_animation' => '',
				'bullet_nav'	=> 'on'
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		

			return '<div class="ozy-owlcarousel '. (esc_attr($bullet_nav) != 'on' ? 'navigation-off' : '') .' '. $css_animation .'" data-autoplay="'. esc_attr($autoplay) .'" data-items="'. esc_attr($items) .'" data-singleitem="'. esc_attr($singleitem) .'" data-slidespeed="'. esc_attr($slidespeed) .'" data-paginationSpeed="800" data-autoheight="'. esc_attr($autoheight) .'">' . PHP_EOL . do_shortcode( $content ) . PHP_EOL .'</div>';
		}
		
		add_shortcode('ozy_vc_owlcarousel_wrapper', 'ozy_vc_owlcarousel_wrapper');
		
		vc_map( array(
			"name" => __("Owl Carousel", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_owlcarousel_wrapper",
			"as_parent" => array('only' => 'ozy_vc_owlcarousel,ozy_vc_owlcarousel2'), //vc_single_image
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => __("Auto Play", "ozy-coiffeur-essentials"),
					"param_name" => "autoplay",
					"value" => array("true", "false", "1000", "2000", "3000", "4000", "5000", "6000", "7000", "8000", "9000", "10000"),
					"admin_label" => true,
					"description" => __("Change to any available integrer for example 3000 to play every 3 seconds. If you set it true default speed will be 5 seconds.", "ozy-coiffeur-essentials")
				),		
				array(
					"type" => "dropdown",
					"heading" => __("Item Count", "ozy-coiffeur-essentials"),
					"param_name" => "items",
					"value" => array("4", "1", "2", "3", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16"),
					"admin_label" => true,
					"description" => __("This variable allows you to set the maximum amount of items displayed at a time with the widest browser width.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Show Single Item?", "ozy-coiffeur-essentials"),
					"param_name" => "singleitem",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => __("Display only one item. Set Item Count to 1 to make it work as expected.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Slide Speed", "ozy-coiffeur-essentials"),
					"param_name" => "slidespeed",
					"value" => array("200", "100", "300", "400", "500", "600", "700", "800", "900", "1000", "1100", "1200", "1300", "1400", "1500", "1600", "1700", "1800", "1900", "2000"),
					"admin_label" => true,
					"description" => __("Slide speed in milliseconds.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Auto Height", "ozy-coiffeur-essentials"),
					"param_name" => "autoheight",
					"value" => array("false", "true"),
					"admin_label" => true,
					"description" => __("Add height to owl-wrapper-outer so you can use diffrent heights on slides. Use it only for one item per page setting.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Bullet Navigation", "ozy-coiffeur-essentials"),
					"param_name" => "bullet_nav",
					"value" => array("on", "off"),
					"admin_label" => true
				),		
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   ),
		   "js_view" => 'VcColumnView'
		) );
	}

	if (!function_exists('ozy_vc_owlcarousel')) {
		function ozy_vc_owlcarousel( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_owlcarousel', $atts);
			extract(shortcode_atts(array(
				'src' 			=> '',
				'img_size'		=> 'full',
				'link'			=> '',
				'link_target'	=> ''
			), $atts));

			$output = '';

			$img_size = strpos(strtolower(esc_attr($img_size)), "x") > -1 ? explode('x', esc_attr($img_size)) : $img_size;
			$thumb = wp_get_attachment_image_src($src, $img_size);

			if(isset($thumb[0])) {
				if(esc_attr($link)) $output = '<a href="'. esc_attr($link) .'" target="'. esc_attr($link_target) .'">';
				$output .= '<div class="item"><img class="lazyOwl" data-src="'. $thumb[0] .'" src="'. get_template_directory_uri() .'/images/blank-large.gif" alt="'. esc_attr($img_size) .'"/></div>';
				if(esc_attr($link)) $output .= '</a>';
			}
			
			return $output;
		}
		
		add_shortcode('ozy_vc_owlcarousel', 'ozy_vc_owlcarousel');

		vc_map( array(
			"name" => __("Owl Carousel Item", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_owlcarousel",
			"content_element" => true,
			"as_child" => array('only' => 'ozy_vc_owlcarousel_wrapper'),
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Carousel Image", "ozy-coiffeur-essentials"),
					"param_name" => "src",
					"admin_label" => false,
					"value" => "",
					"description" => __("Select images for your slider.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"heading" => __("Image size", "ozy-coiffeur-essentials"),
					"param_name" => "img_size",
					"value" => "full",
					"description" => __("Enter image size. Example: 'thumbnail', 'medium', 'large', 'full' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use 'thumbnail' size.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				),$add_css_animation
		   )
		) );
	}

	if (!function_exists('ozy_vc_owlcarousel2')) {
		function ozy_vc_owlcarousel2( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_owlcarousel2', $atts);
			extract(shortcode_atts(array(
				'src' 			=> '',
				'bg_color'		=> '',
				'icon' 			=> '',
				'icon_src'		=> '',
				'title' 		=> '',
				'excerpt' 		=> '',
				'link_caption' 	=> 'Find out more →',
				'link' 			=> '',
				'link_target'	=> '_self',
				'img_size'		=> 'full',
				'default_overlay' => 'off',
				'overlay_bg' 	=> '',
				'title_size'	=> 'h2'
			), $atts));

			$output = '';

			$img_size = strpos(strtolower(esc_attr($img_size)), "x") > -1 ? explode('x', esc_attr($img_size)) : $img_size;
			$thumb = wp_get_attachment_image_src($src, $img_size);

			$style = esc_attr($bg_color) ? ' style="background-color:'. esc_attr($bg_color) .';" ' : ''; //height:278px;
			$output = '<div class="item item-extended" '. $style .'>';
			if(isset($thumb[0])) {
				$output .= '<img src="'. $thumb[0] .'" alt=""/>';
			}else{
				$output .= '<img src="'. get_template_directory_uri() .'/images/blank-large.gif" alt=""/>';
			}
			$output .= '<a'. ($link ? ' href="'. esc_attr($link) .'" target="'. esc_attr($link_target) .'"':'') .'>';
			$output .= '<div class="overlay-one '.(esc_attr($default_overlay) === 'on' ? 'overlay-one-bg' : '').'">';
			if(esc_attr($icon_src)) {// && isset($icon_thumb[0])
				$icon_thumb = wp_get_attachment_image_src($icon_src, 'full');
				$output .= '<span><img src="'. $icon_thumb[0] .'" alt="'. esc_attr($title) .'"/></span>';
			}else{
				if(esc_attr($icon)){
					$output .= '<span class="'. esc_attr($icon) .'"></span>';
				}else{
					$output .= '<'. $title_size .'>'. esc_attr($title) .'</'. $title_size .'>';
				}
			}
			$output .= '</div>';
			$output .= '<div class="overlay-two"'. ($overlay_bg ? ' style="background-color:'. esc_attr($overlay_bg) .'"':'') .'>';
			$output .= '<p>'. esc_attr($excerpt);
			if($link) {
				$output .= '<span>'. esc_attr($link_caption) .'</span>';
			}
			$output .= '</p>';
			$output .= '</div>';
			$output .= '</a>';
			$output .= '</div>';

			
			return $output;
		}
		
		add_shortcode('ozy_vc_owlcarousel2', 'ozy_vc_owlcarousel2');

		vc_map( array(
			"name" => __("Owl Carousel Extended Item", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_owlcarousel2",
			"content_element" => true,
			"as_child" => array('only' => 'ozy_vc_owlcarousel_wrapper'),
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Carousel Image", "ozy-coiffeur-essentials"),
					"param_name" => "src",
					"admin_label" => false,
					"value" => "",
					"description" => __("Select images for your slider.", "ozy-coiffeur-essentials")
				),array(
					"type" => "colorpicker",
					"heading" => __("Carousel Background", "ozy-coiffeur-essentials"),
					"param_name" => "bg_color",
					"admin_label" => false,
					"value" => "",
					"description" => __("Not requrired. Select a background color for your item.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Title", "ozy-coiffeur-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "select_an_icon",
					"heading" => __("or Icon", "ozy-coiffeur-essentials"),
					"param_name" => "icon",
					"value" => '',
					"admin_label" => false,
					"description" => __("Once you select an Icon, title will not be shown on overlay.", "ozy-coiffeur-essentials")
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("or Image Icon", "ozy-coiffeur-essentials"),
					"param_name" => "icon_src",
					"admin_label" => false,
					"value" => "",
					"description" => __("Once you select an Image Icon, title or Icon will not be shown on overlay.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"heading" => __("Image size", "ozy-coiffeur-essentials"),
					"param_name" => "img_size",
					"value" => "full",
					"description" => __("Enter image size. Example: 'thumbnail', 'medium', 'large', 'full' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use 'thumbnail' size.", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"heading" => __("Default Overlay?", "ozy-coiffeur-essentials"),
					"param_name" => "default_overlay",
					"value" => array("off", "on", "_parent"),
					"admin_label" => false,
					"description" => __("ON/OFF default overlay on your items.", "ozy-coiffeur-essentials")
				),array(
					"type" => "colorpicker",
					"heading" => __("Overlay Background Color", "ozy-coiffeur-essentials"),
					"param_name" => "overlay_bg",
					"value" => "",
					"admin_label" => false
				),array(
					"type" => "textarea",
					"class" => "",
					"heading" => __("Excerpt", "ozy-coiffeur-essentials"),
					"param_name" => "excerpt",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link Caption", "ozy-coiffeur-essentials"),
					"param_name" => "link_caption",
					"admin_label" => true,
					"value" => __("Find out more →", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				)
		   )
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Owlcarousel_Wrapper extends WPBakeryShortCodesContainer{}
	class WPBakeryShortCode_Ozy_Vc_Owlcarousel extends WPBakeryShortCode{}
	class WPBakeryShortCode_Ozy_Vc_Owlcarousel2 extends WPBakeryShortCode{}

	/**
	* Owl Carousel Single
	*/
	if (!function_exists('ozy_vc_owlcarousel_single_wrapper')) {
		function ozy_vc_owlcarousel_single_wrapper( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_owlcarousel_single_wrapper', $atts);
			extract(shortcode_atts(array(
				'autoplay'		=> 'true',
				'items'			=> '1',
				'singleitem'	=> 'true',
				'slidespeed'	=> '200',
				'autoheight'	=> 'false',
				'extra_css'		=> '',
				'css_animation' => '',
				'bullet_nav'	=> 'on'
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		

			return '<div class="ozy-owlcarousel single '. (esc_attr($bullet_nav) != 'on' ? 'navigation-off' : '') .' '. $css_animation .'" data-autoplay="'. esc_attr($autoplay) .'" data-items="'. esc_attr($items) .'" data-singleitem="'. esc_attr($singleitem) .'" data-slidespeed="'. esc_attr($slidespeed) .'" data-paginationSpeed="800" data-autoheight="'. esc_attr($autoheight) .'">' . PHP_EOL . do_shortcode( $content ) . PHP_EOL .'</div>';
		}
		
		add_shortcode('ozy_vc_owlcarousel_single_wrapper', 'ozy_vc_owlcarousel_single_wrapper');
		
		vc_map( array(
			"name" => __("Simple Slider", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_owlcarousel_single_wrapper",
			"as_parent" => array('only' => 'ozy_vc_owlcarousel_single'),
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "dropdown",
					"heading" => __("Auto Play", "ozy-coiffeur-essentials"),
					"param_name" => "autoplay",
					"value" => array("true", "false", "1000", "2000", "3000", "4000", "5000", "6000", "7000", "8000", "9000", "10000"),
					"admin_label" => true,
					"description" => __("Change to any available integrer for example 3000 to play every 3 seconds. If you set it true default speed will be 5 seconds.", "ozy-coiffeur-essentials")
				),		
				array(
					"type" => "dropdown",
					"heading" => __("Slide Speed", "ozy-coiffeur-essentials"),
					"param_name" => "slidespeed",
					"value" => array("200", "100", "300", "400", "500", "600", "700", "800", "900", "1000", "1100", "1200", "1300", "1400", "1500", "1600", "1700", "1800", "1900", "2000"),
					"admin_label" => true,
					"description" => __("Slide speed in milliseconds.", "ozy-coiffeur-essentials")
				),
				array(
					"type" => "dropdown",
					"heading" => __("Bullet Navigation", "ozy-coiffeur-essentials"),
					"param_name" => "bullet_nav",
					"value" => array("on", "off"),
					"admin_label" => true
				),		
				$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   ),
		   "js_view" => 'VcColumnView'
		) );
	}

	if (!function_exists('ozy_vc_owlcarousel_single')) {
		function ozy_vc_owlcarousel_single( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_owlcarousel_single', $atts);
			extract(shortcode_atts(array(
				'src' 				=> '',
				'img_size'			=> 'full',
				'link'				=> '',
				'link_caption'		=> 'Find Out More',
				'link_target'		=> '',
				'caption'			=> '',
				'excerpt'			=> '',
				'caption_position'	=> '',
				'fn_color'			=> '#ffffff',
				'link_style'		=> 'frame'
			), $atts));

			$output = '';

			$img_size = strpos(strtolower(esc_attr($img_size)), "x") > -1 ? explode('x', esc_attr($img_size)) : $img_size;
			$thumb = wp_get_attachment_image_src($src, $img_size);
			$rand_id = 'owl-item-' . rand(1, 10000);
			
			if(isset($thumb[0])) {
				$output .= '<div class="item '. $rand_id .'" style="width:'. $thumb[1] .'px;height:'. $thumb[2] .'px;background-image:url('. esc_url( $thumb[0] ) .')">';
				$output .= '<img src="'. esc_url( $thumb[0] ) .'" alt="'. esc_attr($img_size) .'" style="visibility:hidden;"/>';
				$output .= '<div class="caption">';
				if($caption || $excerpt) {
					$output .= '<h1>'. $caption .'</h1>'. ($excerpt ? '<p>'. $excerpt .'</p>' : '');
				}
				if(esc_attr($link)) {
					$output .= '<a href="'. esc_attr($link) .'" target="'. esc_attr($link_target) .'" class="'. esc_attr($link_style) .'">'. $link_caption .'</a>';
				}
				$output .= '</div>';
				$output .= '</div>';
				
				global $ozyHelper;
				$ozyHelper->set_footer_style('.' . $rand_id . ' .caption{text-align:'. $caption_position .'}');
				$ozyHelper->set_footer_style('.' . $rand_id . ' .caption a{border-color:'. $fn_color .';}');
				$ozyHelper->set_footer_style('.' . $rand_id . ' .caption h1,.' . $rand_id . ' .caption p,.' . $rand_id . ' .caption a{color:'. $fn_color .' !important;}');
				
			}
			
			return $output;
		}
		
		add_shortcode('ozy_vc_owlcarousel_single', 'ozy_vc_owlcarousel_single');

		vc_map( array(
			"name" => __("Simple Slider - Slide", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_owlcarousel_single",
			"content_element" => true,
			"as_child" => array('only' => 'ozy_vc_owlcarousel_single_wrapper'),
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Carousel Image", "ozy-coiffeur-essentials"),
					"param_name" => "src",
					"admin_label" => false,
					"value" => "",
					"description" => __("Select images for your slider.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"heading" => __("Image size", "ozy-coiffeur-essentials"),
					"param_name" => "img_size",
					"value" => "full",
					"description" => __("Enter image size. Example: 'thumbnail', 'medium', 'large', 'full' or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height). Leave empty to use 'thumbnail' size.", "ozy-coiffeur-essentials")
				),array(
					"type" => "colorpicker",
					"heading" => __("Foreground Color", "ozy-coiffeur-essentials"),
					"param_name" => "fn_color",
					"admin_label" => false,
					"value" => "#ffffff"
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Caption", "ozy-coiffeur-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Excerpt", "ozy-coiffeur-essentials"),
					"param_name" => "excerpt",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "dropdown",
					"heading" => __("Caption Position", "ozy-coiffeur-essentials"),
					"param_name" => "caption_position",
					"value" => array("left", "right", "center"),
					"admin_label" => false
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link Caption", "ozy-coiffeur-essentials"),
					"param_name" => "link_caption",
					"admin_label" => true,
					"value" => __("Find Out More", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "dropdown",
					"heading" => __("Link Target", "ozy-coiffeur-essentials"),
					"param_name" => "link_target",
					"value" => array("_self", "_blank", "_parent"),
					"admin_label" => false,
					"description" => __("Select link target window.", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"heading" => __("Link Style", "ozy-coiffeur-essentials"),
					"param_name" => "link_style",
					"value" => array("frame", "generic-button"),
					"admin_label" => false
				)//,$add_css_animation
		   )
		) );
	}

	class WPBakeryShortCode_Ozy_Vc_Owlcarousel_single_Wrapper extends WPBakeryShortCodesContainer{}
	class WPBakeryShortCode_Ozy_Vc_Owlcarousel_single extends WPBakeryShortCode{}

	/**
	* Counter
	*/
	if (!function_exists('ozy_vc_count_to')) {
		function ozy_vc_count_to( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_count_to', $atts);
			extract(shortcode_atts(array(
				'color' 		=> '#000000',
				'from'			=> 0,
				'to'			=> 100,
				'subtitle' 		=> '',
				'sign'			=> '',
				'signpos'		=> 'right',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}		
			
			return '<div class="ozy-counter wpb_content_element '. $css_animation .'" style="color:'. esc_attr($color) .'"><div class="timer" data-sign="'. esc_attr($sign) .'" data-signpos="'. esc_attr($signpos) .'" data-from="'. esc_attr($from) .'" data-to="'. esc_attr($to) .'">'. esc_attr($from) .'</div><div class="hr" style="background-color:'. esc_attr($color) .'"></div>'. (esc_attr($subtitle) ? '<span>'. esc_attr($subtitle) .'</span>' : '') .'</div>';
		}
		
		add_shortcode('ozy_vc_count_to', 'ozy_vc_count_to');
		
		vc_map( array(
			"name" => __("Count To", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_count_to",
			"icon" => "",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Sub Title", "ozy-coiffeur-essentials"),
					"param_name" => "subtitle",
					"admin_label" => true,
					"value" => "",
					"description" => __("Counter title.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("From", "ozy-coiffeur-essentials"),
					"param_name" => "from",
					"admin_label" => true,
					"value" => "0",
					"description" => __("Counter start from", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("To", "ozy-coiffeur-essentials"),
					"param_name" => "to",
					"admin_label" => true,
					"value" => "100",
					"description" => __("Counter count to", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Sign", "ozy-coiffeur-essentials"),
					"param_name" => "sign",
					"admin_label" => true,
					"value" => "",
					"description" => __("Enter a sign like % or whatever you like", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"heading" => __("Sign Position", "ozy-coiffeur-essentials"),
					"param_name" => "signpos",
					"value" => array('right', 'left'),
					"admin_label" => false,
					"description" => __("Select position of your sign.", "ozy-coiffeur-essentials")
				),array(
					"type" => "colorpicker",
					"heading" => __("Forecolor", "ozy-coiffeur-essentials"),
					"param_name" => "color",
					"value" => "#000000",
					"admin_label" => false
				),$add_css_animation
		   )
		) );	
	}

	/**
	* Twitter Slider
	*/
	if (!function_exists('ozy_vc_twitter_ticker')) {
		function ozy_vc_twitter_ticker( $atts, $content = null ) {
		
			$essentials_options = get_option('ozy_coiffeur_essentials');
			if( is_array($essentials_options) && 
				isset($essentials_options['twitter_consumer_key']) && 
				isset($essentials_options['twitter_secret_key']) &&
				isset($essentials_options['twitter_token_key']) &&
				isset($essentials_options['twitter_token_secret_key']) ) 
			{
				$atts = vc_map_get_attributes('ozy_vc_twitter_ticker', $atts);
				extract(shortcode_atts(array(
					'count' => '10',
					'screenname' => 'ozythemes',
					'forecolor' => ''
				), $atts));	
			
				wp_enqueue_script('royalslider');
				wp_enqueue_style('royalslider');			
				
				require_once("classes/ozy_twitteroauth.php"); //Path to twitteroauth library
				
				if(!function_exists('getConnectionWithAccessToken')) {
					function getConnectionWithAccessToken($cons_key, $cons_secret, $oauth_token, $oauth_token_secret) {
						$connection = new TwitterOAuth($cons_key, $cons_secret, $oauth_token, $oauth_token_secret);
						return $connection;
					}
				}

				$connection = getConnectionWithAccessToken(
					$essentials_options['twitter_consumer_key'],
					$essentials_options['twitter_secret_key'],
					$essentials_options['twitter_token_key'],
					$essentials_options['twitter_token_secret_key']
				);
				 
				$tweets = $connection->get("https://api.twitter.com/1.1/statuses/user_timeline.json?screen_name=". esc_attr($screenname) ."&count=". esc_attr($count));

				if(!function_exists('makeLinks')) {
					function makeLinks($str) {    
						return preg_replace('/(https?):\/\/([A-Za-z0-9\._\-\/\?=&;%,]+)/i', '<a href="$1://$2" target="_blank">$1://$2</a>', $str);
					}
				}

				$output = '';
				if(is_array($tweets)) {
					foreach($tweets as $tweet) {
						$h_time = sprintf( __('%s ago', 'ozy-coiffeur-essentials'), human_time_diff( date( 'U', strtotime( $tweet->created_at ) )));

						$output .= '<div>';
						$output .= '<div class="testimonial" style="color:'. esc_attr($forecolor) .'">'. makeLinks($tweet->text) .'<br>'. $h_time  .'</div>';
						$output .= '<div class="info">';
						$output .= '<span class="thumb"><span><img src="'. $tweet->user->profile_image_url .'" alt="'. $tweet->user->screen_name .'"/></span></span>';
						$output .= '<span class="username"><a href="http://twitter.com/'. $tweet->user->screen_name .'" style="color:'. esc_attr($forecolor) .'" target="_blank">'. $tweet->user->screen_name .'</a></span>';
						$output .= '</div>';
						$output .= '</div>';
					}
				
					return '<div class="royalSlider contentSlider ozy-testimonials">' . PHP_EOL . $output . PHP_EOL .'</div>';
				}else{
					return 'Possible Twitter data error.';
				}
			}
			
			return '<p>**Required Twitter parameters are not supplied. Please go to your admin panel, Settings > Coiffeur Essentials.**</p>';
		}

		add_shortcode('ozy_vc_twitter_ticker', 'ozy_vc_twitter_ticker');
		
		vc_map( array(
			"name" => __("Twitter Slider", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_twitter_ticker",
			"content_element" => true,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "colorpicker",
					"heading" => __("ForeColor", "ozy-coiffeur-essentials"),
					"param_name" => "forecolor",
					"value" => "",
					"admin_label" => false,
					"description" => __("Font color for rest of the slider", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Count", "ozy-coiffeur-essentials"),
					"param_name" => "count",
					"admin_label" => true,
					"value" => "10"
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Screenname", "ozy-coiffeur-essentials"),
					"param_name" => "screenname",
					"admin_label" => true,
					"value" => "ozythemes"
				),array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)
			)
		) );	
	}

	/**
	* Testimonials
	*/
	if (!function_exists('ozy_vc_testimonials')) {
		function ozy_vc_testimonials( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_testimonials', $atts);
			extract(shortcode_atts(array(
				'forecolor' => ''
			), $atts));		
			
			wp_enqueue_script('royalslider');
			wp_enqueue_style('royalslider');
			
			$GLOBALS['OZY_TESTIMONIAL_SLIDER_FORECOLOR'] = esc_attr($forecolor);
			
			return '<div class="royalSlider contentSlider ozy-testimonials wpb_content_element">' . PHP_EOL . do_shortcode( $content ) . PHP_EOL .'</div>';
		}

		add_shortcode('ozy_vc_testimonials', 'ozy_vc_testimonials');

		vc_map( array(
			"name" => __("Testimonials Slider", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_testimonials",
			"as_parent" => array('only' => 'ozy_vc_testimonial'), // Use only|except attributes to limit child shortcodes (separate multiple values with comma)
			"content_element" => true,
			"show_settings_on_create" => false,
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "colorpicker",
					"heading" => __("ForeColor", "ozy-coiffeur-essentials"),
					"param_name" => "forecolor",
					"value" => "",
					"admin_label" => false,
					"description" => __("Font color for rest of the slider", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)
			),
			"js_view" => 'VcColumnView'
		) );
	}

	if (!function_exists('ozy_vc_testimonial')) {
		function ozy_vc_testimonial( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_testimonial', $atts);
			extract(shortcode_atts(array(
				'title' => '',
				'subtitle' => '',
				'testimonial_content' => '',
				'image' => ''
			), $atts));
			
			$output  = '<div style="'. ($GLOBALS['OZY_TESTIMONIAL_SLIDER_FORECOLOR'] ? 'color:' . $GLOBALS['OZY_TESTIMONIAL_SLIDER_FORECOLOR'] : '') .'">';
			$output .= '<div class="testimonial">'. do_shortcode( $testimonial_content ) .'</div>';
			$output .= '<div class="info">';		
			$member_image = wp_get_attachment_image_src($image, 'full');
			if(isset($member_image[0])) {
				$output .= '<div class="thumb"><span><img src="'. $member_image[0] .'" alt="' . esc_attr($title) . '"/></span></div>';
			}
			$output .= '<div class="itext">';
			if(!empty($title)) $output .= esc_attr($title) . '<br/>';
			if(!empty($subtitle)) $output .= esc_attr($subtitle);
			$output .= '</div>';
			$output .= '</div>';
			$output .= '</div>';
			
			return $output;
		}

		add_shortcode( 'ozy_vc_testimonial', 'ozy_vc_testimonial' );
		
		vc_map( array(
			"name" => __("Testimonial", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_testimonial",
			"content_element" => true,
			"as_child" => array('only' => 'ozy_vc_testimonials'), // Use only|except attributes to limit parent (separate multiple values with comma)
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Title", "ozy-coiffeur-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Sub Title", "ozy-coiffeur-essentials"),
					"param_name" => "subtitle",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textarea",
					"holder" => "div",
					"class" => "",
					"heading" => __("Content", "ozy-coiffeur-essentials"),
					"param_name" => "testimonial_content",
					"description" => __("Testimonial content.", "ozy-coiffeur-essentials")
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Image", "ozy-coiffeur-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => "",
					"description" => __("Select an image to show as testimonial visual.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)
			)
		) );	
	}

	//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
	class WPBakeryShortCode_Ozy_Vc_Testimonials extends WPBakeryShortCodesContainer {
	}
	class WPBakeryShortCode_Ozy_Vc_Testimonial extends WPBakeryShortCode {
	}

	/**
	* Icon Title with Content
	*/
	if(!function_exists('ozy_title_with_icon_func')) {
		function ozy_title_with_icon_func( $atts, $content=null ) {
			$atts = vc_map_get_attributes('title_with_icon', $atts);
			extract( shortcode_atts( array(
				  'icon' => '',
				  'icon_size' => 'medium',
				  'icon_position' => 'left',
				  'size' => 'h1',
				  'title' => '',
				  'icon_type' => '',
				  'icon_color' => '',
				  'text_color' => '',
				  'icon_bg_color' => 'transparent',
				  'icon_shadow_color' => '',
				  'go_link' => '',
				  'go_target' => '_self',
				  'connected' => 'no',
				  'dot_bg_color' => 'transparent'
				), $atts ) 
			);

			global $ozyHelper;
			$element_id = 'tile-with-icon_icon' . rand(100,10000);
			$a_begin = $a_end = $add_style = "";
			if(trim($go_link) !== '') {
				$a_begin = '<a href="' . esc_attr($go_link) . '" '. ($go_target=='fancybox' || $go_target=='fancybox-media' ? 'class':'target') .'="' . esc_attr($go_target) . '">';
				$a_end   = '</a>';
			}

			if($icon_type === 'circle') {
				$icon_bg_color = 'transparent';
				$add_style = 'border-color:'. esc_attr($icon_color) .';';
			}
			
			$o_icon = ($icon ? $a_begin . '<span ' . ($icon_color ? ' style="'. $add_style .'color:'. $icon_color .' !important;background-color:'. $icon_bg_color .' !important;"' : '') . ' class="' . $icon . ' ' . esc_attr($icon_type) . ' ' . $icon_size . ' ' . '" '. (esc_attr($icon_shadow_color) ? 'data-color="'. esc_attr($icon_shadow_color) .'"':'') .'></span>' . $a_end : '');
			
			return '<div id="'. $element_id .'" class="title-with-icon-wrapper '. esc_attr($icon_type) . ' ' . esc_attr($icon_size) .' '. (esc_attr($connected) === 'yes' ? 'connected' : '') .'" data-color="'. esc_attr($dot_bg_color) .'"><div class="wpb_content_element title-with-icon clearfix ' . (trim($content) !== '' ? 'margin-bottom-0 ' : '') . ($icon_position === 'top' ? 'top-style' : '') . '">' . $o_icon . '<' . $size . (!$icon ? ' class="no-icon content-color"' : ' class="content-color"') . ' style="'. (esc_attr($text_color) ? 'color:' . esc_attr($text_color) : '') .'">' . $a_begin . $title . $a_end . '</' . $size . '></div>' . (trim($content) !== '' ? '<div class="wpb_content_element '. esc_attr($icon_position) .'-cs title-with-icon-content '. esc_attr($icon_size) .' clearfix" style="'. (esc_attr($text_color) ? 'color:' . esc_attr($text_color) : '') .'">' . wpb_js_remove_wpautop(do_shortcode($content)) . '</div>' : '') . '</div>';
		}
		
		add_shortcode( 'title_with_icon', 'ozy_title_with_icon_func' );
		
		vc_map( array(
			"name" => __("Title With Icon", "ozy-coiffeur-essentials"),
			"base" => "title_with_icon",
			"class" => "",
			"controls" => "full",
			'category' => 'by OZY',
			"icon" => "icon-wpb-ozy-el",
			"params" => array(
			  array(
				"type" => "select_an_icon",
				"heading" => __("Icon", "ozy-coiffeur-essentials"),
				"param_name" => "icon",
				"value" => '',
				"admin_label" => false,
				"description" => __("Title heading style.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => __("Icon Size", "ozy-coiffeur-essentials"),
				"param_name" => "icon_size",
				"value" => array(__("medium", "ozy-coiffeur-essentials") => "medium", __("large", "ozy-coiffeur-essentials") => "large", __("xlarge", "ozy-coiffeur-essentials") => "xlarge", __("xxlarge", "ozy-coiffeur-essentials") => "xxlarge", __("xxxlarge", "ozy-coiffeur-essentials") => "xxxlarge"),
				"admin_label" => false,
				"description" => __("Size of the Icon.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => __("Icon Position", "ozy-coiffeur-essentials"),
				"param_name" => "icon_position",
				"value" => array(__("left", "ozy-coiffeur-essentials") => "left", __("top", "ozy-coiffeur-essentials") => "top"),
				"admin_label" => false,
				"description" => __("Position of the Icon.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => __("Icon Alternative Color", "ozy-coiffeur-essentials"),
				"param_name" => "icon_color",
				"value" => "",
				"admin_label" => false,
				"description" => __("This field is not required.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => __("Icon Background Type", "ozy-coiffeur-essentials"),
				"param_name" => "icon_type",
				"value" => array(__("rectangle", "ozy-coiffeur-essentials") => "rectangle", __("rounded", "ozy-coiffeur-essentials") => "rounded", __("circle", "ozy-coiffeur-essentials") => "circle", __("clear", "ozy-coiffeur-essentials") => "clear"),
				"admin_label" => false,
				"description" => __("Position of the Icon.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => __("Icon Background Color", "ozy-coiffeur-essentials"),
				"param_name" => "icon_bg_color",
				"value" => "",
				"admin_label" => false,
				"description" => __("Background color of Icon.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => __("Icon Shadow Color", "ozy-coiffeur-essentials"),
				"param_name" => "icon_shadow_color",
				"value" => "",
				"admin_label" => false,
				"description" => __("Shadow color of Icon.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => __("Heading Style", "ozy-coiffeur-essentials"),
				"param_name" => "size",
				"value" => array("h1", "h2", "h3", "h4", "h5", "h6"),
				"admin_label" => false,
				"description" => __("Title heading style.", "ozy-coiffeur-essentials")
			  ),array(
				 "type" => "textfield",
				 "class" => "",
				 "heading" => __("Link", "ozy-coiffeur-essentials"),
				 "param_name" => "go_link",
				 "admin_label" => true,
				 "value" => "",
				 "description" => __("Enter full path.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => __("Link Target", "ozy-coiffeur-essentials"),
				"param_name" => "go_target",
				"value" => array("_self", "_blank", "_parent", "fancybox", "fancybox-media"),
				"admin_label" => false,
				"description" => __("Select link target window. fancybox will launch an lightbox window for images, and fancybox-media will launch a lightbox window for frames/video.", "ozy-coiffeur-essentials")
			  ),array(
				 "type" => "textfield",
				 "class" => "",
				 "heading" => __("Title", "ozy-coiffeur-essentials"),
				 "param_name" => "title",
				 "admin_label" => true,
				 "value" => __("Enter your title here", "ozy-coiffeur-essentials"),
				 "description" => __("Content of the title.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => __("Font Color", "ozy-coiffeur-essentials"),
				"param_name" => "text_color",
				"value" => "",
				"admin_label" => false,
				"description" => __("This option will affect Title and Content color.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "dropdown",
				"heading" => __("Connected", "ozy-coiffeur-essentials"),
				"param_name" => "connected",
				"value" => array("no", "yes"),
				"admin_label" => false,
				"description" => __("Select yes to connect elements to next one with a dashed border.", "ozy-coiffeur-essentials")
			  ),array(
				"type" => "colorpicker",
				"heading" => __("Border Color", "ozy-coiffeur-essentials"),
				"param_name" => "dot_bg_color",
				"value" => "",
				"admin_label" => false,
				"dependency" => Array('element' => "connected", 'value' => 'yes')
			  ),array(
				"type" => "textarea_html",
				"holder" => "div",
				"class" => "",
				"heading" => __("Content", "ozy-coiffeur-essentials"),
				"param_name" => "content",
				"value" => "",
				"description" => __("Type your content here.", "ozy-coiffeur-essentials")
			  )
		   )
		) );
	}

	/**
	* Before After Image Viewer
	*/
	if (!function_exists('ozy_vc_before_after')) {
		function ozy_vc_before_after( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_before_after', $atts);
			extract(shortcode_atts(array(
				'before' => '',
				'after'	=> '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}
				
			wp_enqueue_style('twentytwenty', get_template_directory_uri() . '/scripts/twentytwenty/css/twentytwenty.css');
			wp_enqueue_script('jquery.event.move', get_template_directory_uri() . '/scripts/twentytwenty/js/jquery.event.move.js', array('jquery'), null, true );	
			wp_enqueue_script('jquery.twentytwenty', get_template_directory_uri() . '/scripts/twentytwenty/js/jquery.twentytwenty.js', array('jquery'), null, true );	

			$before_large_image = wp_get_attachment_image_src($before, 'full');
			$after_large_image = wp_get_attachment_image_src($after, 'full');

			$output  = '<div class="ozy-before_after wpb_content_element '. $css_animation .'">';
			if($before_large_image[0] && $after_large_image[0]) {
				$output .= '<img src="'. esc_attr($before_large_image[0]) .'"/>';
				$output .= '<img src="'. esc_attr($after_large_image[0]) .'"/>';
			}else{
				$output .= __('No proper images supplied', 'ozy-coiffeur-essentials');
			}
			$output .= '</div>';
		
			return $output;
		}
		
		add_shortcode('ozy_vc_before_after', 'ozy_vc_before_after');

		vc_map( array(
		   "name" => __("Before / After Viewer", "ozy-coiffeur-essentials"),
		   "base" => "ozy_vc_before_after",
			"icon" => "icon-wpb-ozy-el",
			'category' => 'by OZY',
		   "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Title", "ozy-coiffeur-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => __("Only place holder.", "ozy-coiffeur-essentials")
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Before Image", "ozy-coiffeur-essentials"),
					"param_name" => "before",
					"admin_label" => false,
					"value" => "",
					"description" => __("Before image. Please select your images in same dimension for fine results.", "ozy-coiffeur-essentials")
				),array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("After Image", "ozy-coiffeur-essentials"),
					"param_name" => "after",
					"admin_label" => false,
					"value" => "",
					"description" => __("After image. Please select your images in same dimension for fine results.", "ozy-coiffeur-essentials")
				),$add_css_animation
		   )
		) );	
	}

	/**
	* Icon
	*/
	if (!function_exists('ozy_vc_icon')) {
		function ozy_vc_icon( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_icon', $atts);
			extract(shortcode_atts(array(
				'icon' => '',
				'size' => 'regular',
				'style' => '',
				'link' => '',
				'target' => '',
				'color' => '',
				'icon_shadow_color' => '',
				'textcolor' => '',
				'align' => 'left',
				'css_animation' => '',
				'el_class' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}
			
			$element_id = 'ozy_icon_'. rand(100,10000);
					
			$inline_style = 'style="';
			if(esc_attr($color)) {
				global $ozyHelper;
				switch(esc_attr($style)) {
					case 'square':
						$inline_style .= 'background-color:'. esc_attr($color).'!important';
						break;
					case 'circle':
						$inline_style .= 'background-color:'. esc_attr($color);
						break;
					case 'circle2':
						$inline_style .= 'border-color:'. esc_attr($color) .';color:'. esc_attr($color);
						break;
				}
				//$ozyHelper->set_footer_style('#'. $element_id .':hover{box-shadow:'. $ozyHelper->hex2rgba(esc_attr($color),'.2') .' 0 0 0 10px;}');				
			}
			
			if(esc_attr($textcolor)) {
				$inline_style .= ';color:'. esc_attr($textcolor);
			}
			
			if(esc_attr($align) === 'left' || esc_attr($align) === 'right') {
				$inline_style .= ';float:'. esc_attr($align);
			}
			
			$inline_style .= '"';
			
			$output = '';		
			if(esc_attr($link)) $output .= '<a href="'. esc_attr($link) .'" target="'. esc_attr($target) .'" class="'. esc_attr($el_class) .' ozy-icon-a">';
			$output .= '<span id="'. $element_id .'" class="ozy-icon '. (!esc_attr($link)? esc_attr($el_class) : '') .' wpb_content_element align-'. esc_attr($align) .' ' . esc_attr($size) .' ' . esc_attr($style) . ' icon '. esc_attr($icon) .' '. $css_animation .'" '. $inline_style .' '. (esc_attr($icon_shadow_color) ? 'data-color="'. esc_attr($icon_shadow_color) .'"':'') .'></span>';
			if(esc_attr($link)) $output .= '</a>';
			
			return $output;
		}

		add_shortcode('ozy_vc_icon', 'ozy_vc_icon');
		
		vc_map( array(
		   "name" => __("Icon", "ozy-coiffeur-essentials"),
		   "base" => "ozy_vc_icon",
		   "icon" => "icon-wpb-ozy-el",
		   'category' => 'by OZY',
		   "params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Title", "ozy-coiffeur-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => __("Only place holder.", "ozy-coiffeur-essentials")
				),array(
					"type" => "select_an_icon",
					"class" => "",
					"heading" => __("Icon", "ozy-coiffeur-essentials"),
					"param_name" => "icon",
					"admin_label" => true,
					"value" => "",
					"description" => __("Select a type icon from the opened window.", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"heading" => __("Size", "ozy-coiffeur-essentials"),
					"param_name" => "size",
					"value" => array("regular", "large", "xlarge", "xxlarge", "xxxlarge"),
					"admin_label" => false
				),array(
					"type" => "dropdown",
					"heading" => __("Style", "ozy-coiffeur-essentials"),
					"param_name" => "style",
					"value" => array("clean", "square", "circle", "circle2"),
					"admin_label" => false
				),array(
					"type" => "dropdown",
					"heading" => __("Align", "ozy-coiffeur-essentials"),
					"param_name" => "align",
					"value" => array("left", "center", "right"),
					"admin_label" => false
				),array(
					"type" => "textfield",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => false
				),array(
					"type" => "dropdown",
					"heading" => __("Target Window", "ozy-coiffeur-essentials"),
					"param_name" => "target",
					"value" => array("_self", "_blank"),
					"admin_label" => false
				),array(
					"type" => "colorpicker",
					"heading" => __("Background Color", "ozy-coiffeur-essentials"),
					"param_name" => "color",
					"admin_label" => false
				),array(
					"type" => "colorpicker",
					"heading" => __("Foreground Color", "ozy-coiffeur-essentials"),
					"param_name" => "textcolor",
					"admin_label" => false
				),array(
					"type" => "colorpicker",
					"heading" => __("Icon Shadow Color", "ozy-coiffeur-essentials"),
					"param_name" => "icon_shadow_color",
					"value" => "",
					"admin_label" => false,
					"description" => __("Shadow color of Icon.", "ozy-coiffeur-essentials")
				),$add_css_animation,
				array(
					"type" => "textfield",
					"heading" => __("Extra class name", "ozy-coiffeur-essentials"),
					"param_name" => "el_class",
					"description" => __("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", "ozy-coiffeur-essentials")
				)			
		   )
		) );
	}

	/**
	* Custom List
	*/
	if (!function_exists('ozy_vc_ul')) {
		function ozy_vc_ul( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_ul', $atts);
			extract(shortcode_atts(array(
				'icon' => '',
				'icon_color' => '',
				'ul_content' => '',
				'css_animation' => ''
			), $atts));

			if($content) $ul_content = $content; //this line covers new Content field after 2.0 version			
			
			$content = wpb_js_remove_wpautop($ul_content);
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}
			
			$tag = $style = '';		
			if(strtolower(strpos($content, '<ul'))) {
				$tag = 'ul';
			}else if(strtolower(strpos($content, '<ol'))) {
				$tag = 'ol';
			}
			if($icon_color) {
				$style = ' style="color:'. esc_attr($icon_color) .'"';
			}
			$content = ozy_strip_single($tag, $content);
			$content = str_replace('<li>' , '<li><span class="oic '. esc_attr($icon) .'"'. $style .'></span><span>', $content);
			$content = str_replace('</li>' , '</span></li>', $content);
			$content = ozy_strip_single('p', $content);
			if(!$tag) { 
				$tag = 'ul';
			}
			return '<'. $tag .' class="ozy-custom-list wpb_content_element '. $css_animation .'">'. $content . '</'. $tag .'>';
		}

		add_shortcode('ozy_vc_ul', 'ozy_vc_ul');
		
		vc_map( array(
			"name" => __("Custom List", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_ul",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Title", "ozy-coiffeur-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => __("Only place holder.", "ozy-coiffeur-essentials")
				),array(
					"type" => "select_an_icon",
					"class" => "",
					"heading" => __("Icon", "ozy-coiffeur-essentials"),
					"param_name" => "icon",
					"admin_label" => true,
					"value" => "",
					"description" => __("Select a type icon from the opened window.", "ozy-coiffeur-essentials")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Icon Color", "ozy-coiffeur-essentials"),
					"param_name" => "icon_color"
				),array(
					"type" => "textarea",
					"class" => "",
					"heading" => __("Content (OLD)", "ozy-coiffeur-essentials"),
					"param_name" => "ul_content",
					"admin_label" => false,
					"description" => __("Please do not use this field, only to cover old versions. Copy your content into next Content field.", "ozy-coiffeur-essentials"),
					"value" => ""
				),array(
					"type" => "textarea_html",
					"class" => "",
					"heading" => __("Content", "ozy-coiffeur-essentials"),
					"param_name" => "content",
					"admin_label" => false,
					"value" => ""
				),$add_css_animation
		   )
		) );	
	}

	function ozy_strip_single($tag,$string){
		$string=preg_replace('/<'.$tag.'[^>]*>/i', '', $string);
		$string=preg_replace('/<\/'.$tag.'>/i', '', $string);
		return $string;
	}

	/**
	* Visible Nearby Slider / Gallery Slider
	*/
	if (!function_exists('ozy_vc_gallery_slider')) {
		function ozy_vc_gallery_slider( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_gallery_slider', $atts);
			extract(shortcode_atts(array(
				'width' => '100%',
				'height' => '',
				'color' => '',
				'src' => '',
				'caption' => '',
				'css_animation' => ''
			), $atts));
			
			wp_enqueue_script('royalslider');
			wp_enqueue_style('royalslider');
			wp_enqueue_style('rs-minimal-white');
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}
			
			$style = $output = '';
			if($width) {
				$style .= 'width:' . esc_attr($width) . ';';
			}
			if($height) {
				$style .= 'height:' . esc_attr($height);
			}
			
			$src_arr = explode(',', $src);
			if(is_array($src_arr)) {
				foreach($src_arr as $s) {
					$attachment = get_post($s);
					if($attachment->guid) {
						$output .= '<a class="rsImg" href="'. $attachment->guid .'">';
						if(esc_attr($caption)) {
							if($attachment->post_excerpt) {
								$output .= '<span>'. $attachment->post_excerpt .'</span>';
							}
							if($attachment->post_title) {
								$output .= '<p'. (esc_attr($color) ? ' style="color:'. esc_attr($color) .';"' : '') .'>'. $attachment->post_title . '</p>';
							}
						}
						$output .= '</a>';
					}
				}
			}
			return '<div class="royalSlider visibleNearby rsMinW '. $css_animation .'" style="'. $style .'">' . $output .'</div>';
		}
		
		add_shortcode('ozy_vc_gallery_slider', 'ozy_vc_gallery_slider');
		
		vc_map( array(
			"name" => __("Visible Nearby Slider", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_gallery_slider",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Title", "ozy-coiffeur-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => __("Only place holder.", "ozy-coiffeur-essentials")
				),array(
					"type" => "attach_images",
					"class" => "",
					"heading" => __("Slider Images", "ozy-coiffeur-essentials"),
					"param_name" => "src",
					"admin_label" => false,
					"value" => "",
					"description" => __("Select images for your slider.", "ozy-coiffeur-essentials")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Caption Color", "ozy-coiffeur-essentials"),
					"param_name" => "color"
				),array(
					"type" => "dropdown",
					"heading" => __("Caption", "ozy-coiffeur-essentials"),
					"param_name" => "caption",
					"value" => array("off", "on"),
					"description" => __("Once this option selected, caption will be printed bottom of the images from Image's attributes", "ozy-coiffeur-essentials"),
					"admin_label" => true
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Width", "ozy-coiffeur-essentials"),
					"param_name" => "width",
					"admin_label" => true,
					"value" => "100%",
					"description" => __("Width of your slider", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Height", "ozy-coiffeur-essentials"),
					"param_name" => "height",
					"admin_label" => true,
					"value" => "",
					"description" => __("Height of your slider", "ozy-coiffeur-essentials")
				),$add_css_animation
		   )
		) );	
	}

	/**
	* Team Member
	*/
	if (!function_exists('ozy_vc_team_member')) {
		function ozy_vc_team_member( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_team_member', $atts);
			extract(shortcode_atts(array(
				'image' => '',
				'title' => '',
				'sub_title' => '',
				'excerpt' => '',			
				'twitter' => '',
				'facebook' => '',
				'linkedin' => '',
				'pinterest' => '',
				'link' => '',
				'css_animation' => ''
			), $atts));
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}	
			
			$output = PHP_EOL . '<div class="ozy-team_member '. $css_animation .'">' . PHP_EOL;
			$output.= '<figure>';
			$member_image = wp_get_attachment_image_src($image, 'full');
			if(isset($member_image[0])) {
				$output.= $link? '<a href="'. esc_attr($link) .'">' : '';
				$output.= '<img src="'. $member_image[0] .'" alt="'. esc_attr($title) .'">';
				$output.= $link? '</a>' : '';
			}
			$output.= '<figcaption>';
			$output.= esc_attr($title) ? '<h3>'. esc_attr($title) .'</h3>' : '';
			$output.= esc_attr($sub_title) ? '<h5 class="content-color-alternate">'. esc_attr($sub_title) .'</h5>' : '';
			$output.= '<p>'. esc_attr($excerpt) .'</p>';

			$output.= '<div>';
			$output.= esc_attr($twitter) ? '<a href="http://www.twitter.com/'. esc_attr($twitter) .'" target="_blank" class="symbol-twitter tooltip" title="twitter"><span class="symbol">twitter'.'</span></a>' : '';
			$output.= esc_attr($facebook) ? '<a href="http://www.facebook.com/'. esc_attr($facebook) .'" target="_blank" class="symbol-facebook tooltip" title="facebook"><span class="symbol">facebook'.'</span></a>' : '';
			$output.= esc_attr($linkedin) ? '<a href="http://www.linkedin.com/'. esc_attr($linkedin) .'" target="_blank" class="symbol-linkedin tooltip" title="linkedin"><span class="symbol">linkedin'.'</span></a>' : '';
			$output.= esc_attr($pinterest) ? '<a href="http://pinterest.com/'. esc_attr($pinterest) .'" target="_blank" class="symbol-pinterest tooltip" title="pinterest"><span class="symbol">pinterest'.'</span></a>' : '';
			$output.= '</div>';
			
			$output.= '</figcaption>';
			$output.= '</figure>';
			$output.= PHP_EOL . '</div>' . PHP_EOL;		
			
			return $output;
		}

		add_shortcode( 'ozy_vc_team_member', 'ozy_vc_team_member' );
		
		vc_map( array(
			"name" => __("Team Member", "ozy-coiffeur-essentials"),
			"base" => "ozy_vc_team_member",
			"icon" => "icon-wpb-ozy-el",
			"class" => '',
			"controls" => "full",
			'category' => 'by OZY',
			"params" => array(
				array(
					"type" => "attach_image",
					"class" => "",
					"heading" => __("Member Image", "ozy-coiffeur-essentials"),
					"param_name" => "image",
					"admin_label" => false,
					"value" => "",
					"description" => __("Select image for your team member.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Title", "ozy-coiffeur-essentials"),
					"param_name" => "title",
					"admin_label" => true,
					"value" => "",
					"description" => __("Title for your Team Member, like a name.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Sub Title", "ozy-coiffeur-essentials"),
					"param_name" => "sub_title",
					"admin_label" => true,
					"value" => "",
					"description" => __("Sub Title for your Team Member, like work title.", "ozy-coiffeur-essentials")
				),array(
					"type" => "textarea",
					"class" => "",
					"heading" => __("Excerpt", "ozy-coiffeur-essentials"),
					"param_name" => "excerpt",
					"admin_label" => true,
					"value" => ""
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Twitter", "ozy-coiffeur-essentials"),
					"param_name" => "twitter",
					"admin_label" => true,
					"value" => "",
					"description" => __("Enter your Twitter account name", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Facebook", "ozy-coiffeur-essentials"),
					"param_name" => "facebook",
					"admin_label" => true,
					"value" => "",
					"description" => __("Enter your Facebook account name", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("LinkedIn", "ozy-coiffeur-essentials"),
					"param_name" => "linkedin",
					"admin_label" => true,
					"value" => "",
					"description" => __("Enter your LinkedIn account name", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Pinterest", "ozy-coiffeur-essentials"),
					"param_name" => "pinterest",
					"admin_label" => true,
					"value" => "",
					"description" => __("Enter your Pinterest account name", "ozy-coiffeur-essentials")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Link", "ozy-coiffeur-essentials"),
					"param_name" => "link",
					"admin_label" => false,
					"value" => "",
					"description" => __("Define a path to details page", "ozy-coiffeur-essentials")
				),$add_css_animation
		   )
		) );	
	}

	/**
	* Divider
	*/
	if (!function_exists('ozy_vc_divider')) {
		function ozy_vc_divider( $atts, $content = null ) {
			$atts = vc_map_get_attributes('ozy_vc_divider', $atts);
			extract(shortcode_atts(array(
				'caption_size' => 'h3',
				'caption' 		=> '',
				'caption_align'	=> 'center',
				'caption_position' => '',
				'border_style'	=> 'solid',
				'border_size' => '1',
				'border_color' => '',
				'css_animation' => '',
				'more_custom' => 'off',
				'width' => '',
				'align' => 'center'
				), $atts ) 
			);
			
			if($css_animation) {
				wp_enqueue_script('waypoints');
				$css_animation = " wpb_animate_when_almost_visible wpb_" . esc_attr($css_animation) . " ";
			}
			
			$output = $more_custom_html = '';
			if(esc_attr($more_custom) == 'on' && esc_attr($width) && esc_attr($align)) {
				$more_custom_html = ';width:'. esc_attr($width) .';max-width:'. esc_attr($width) .';';
				switch(esc_attr($align)) {
					case 'center':
						$more_custom_html .= 'margin:20px auto;';
						break;
					case 'left':
						//$more_custom_html .= 'float:left;';
						break;
					case 'right':
						$more_custom_html .= 'float:right;';
						break;						
					default:
						$more_custom_html .= 'margin:0 auto;';
				}
			}
			if('top' === esc_attr($caption_position)){
				$output = ( trim( esc_attr( $caption ) ) ? '<'. esc_attr($caption_size) .' class="ozy-divider-cap-' . esc_attr($caption_align) . ' wpb_content_element">' . esc_attr( $caption ) . '</'. esc_attr($caption_size) .'>' : '' );
				$output.= '<div class="ozy-content-divider '. $css_animation .'" style="border-top-style:'. esc_attr($border_style) . ';border-top-width:' . ('double' == esc_attr($border_style)?'3':esc_attr($border_size)) .'px' . ('' != esc_attr($border_color)?';border-top-color:'. esc_attr($border_color) .'':'') . $more_custom_html .'"></div>';
			}else{
				$output = '<fieldset class="ozy-content-divider '. $css_animation .' wpb_content_element" style="border-top-style:'. esc_attr($border_style) . ';border-top-width:' . ('double' == esc_attr($border_style)?'3':esc_attr($border_size)) .'px' . ('' != esc_attr($border_color)?';border-top-color:'. esc_attr($border_color) .'':'') . $more_custom_html .'">' . ( trim( esc_attr( $caption ) ) ? '<legend class="d' . esc_attr($caption_align) . '" align="' . esc_attr($caption_align) . '">' . esc_attr( $caption ) . '</legend>' : '' ) . '</fieldset>';
			}
			return $output;
		}

		add_shortcode('ozy_vc_divider', 'ozy_vc_divider');

		vc_map( array(
		   "name" => __("Separator (Divider) With Caption", "ozy-coiffeur-essentials"),
		   "base" => "ozy_vc_divider",
		   "class" => "",
		   "controls" => "full",
		   'category' => 'by OZY',
		   "icon" => "icon-wpb-ozy-el",
		   "params" => array(
				array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Caption Size", "ozy-coiffeur-essentials"),
					"param_name" => "caption_size",
					"admin_label" => true,
					"value" => array("h3","h1","h2","h4","h5","h6")
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Caption", "ozy-coiffeur-essentials"),
					"param_name" => "caption",
					"admin_label" => true,
					"value" => __("Enter your caption here", "ozy-coiffeur-essentials"),
					"description" => __("Caption of the divider.", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Border Style", "ozy-coiffeur-essentials"),
					"param_name" => "border_style",
					"admin_label" => true,
					"value" => array("solid","dotted","dashed","double")
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Border Size", "ozy-coiffeur-essentials"),
					"param_name" => "border_size",
					"admin_label" => true,
					"value" => array("1","2","3","4","5","6","7","8","9","10")
				),array(
					"type" => "colorpicker",
					"class" => "",
					"heading" => __("Border Color", "ozy-coiffeur-essentials"),
					"param_name" => "border_color",
					"admin_label" => false,
					"value" => ""
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Caption Align", "ozy-coiffeur-essentials"),
					"param_name" => "caption_align",
					"admin_label" => true,
					"value" => array("center", "left", "right"),
					"description" => __("Caption align.", "ozy-coiffeur-essentials")
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Caption Position", "ozy-coiffeur-essentials"),
					"param_name" => "caption_position",
					"admin_label" => true,
					"value" => array("overlay", "top"),
					"description" => __("Caption position.", "ozy-coiffeur-essentials")
				),array(
					"type" => 'dropdown',
					"heading" => __("More Customization", "ozy-coiffeur-essentials"),
					"param_name" => "more_custom",
					"value" => array("off", "on"),
				),array(
					"type" => "textfield",
					"class" => "",
					"heading" => __("Width", "ozy-coiffeur-essentials"),
					"param_name" => "width",
					"admin_label" => true,
					"value" => "400px",
					"dependency" => Array('element' => "more_custom", 'value' => 'on')
				),array(
					"type" => "dropdown",
					"class" => "",
					"heading" => __("Align", "ozy-coiffeur-essentials"),
					"param_name" => "align",
					"admin_label" => true,
					"value" => array("center", "left", "right"),
					"dependency" => Array('element' => "more_custom", 'value' => 'on')
				),$add_css_animation	
			)
		) );
	}
}