<?php

return array(
	'id'          => 'ozy_coiffeur_meta_page',
	'types'       => array('page'),
	'title'       => __('Page Options', 'coiffeur'),
	'priority'    => 'high',
	'template'    => array(
		array(
			'type' => 'select',
			'name' => 'ozy_coiffeur_meta_page_custom_menu',
			'label' => __('Custom Menu', 'coiffeur'),
			'description' => __('You can select a custom menu for this page.', 'coiffeur'),
			'items' => array(
				'data' => array(
					array(
						'source' => 'function',
						'value' => 'vp_bind_ozy_coiffeur_list_wp_menus',
					),
				),
			),
			'default' => '-1',
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_use_alternate_menu',
			'label' => __('Use Alternate Menu Color Layout', 'coiffeur'),
			'description' => __('You can use alternate menu color layout as your default menu style. No effect will be applied for the menu on scroll. Only valid for this page.', 'coiffeur'),
		),
	
		array(
			'type' => 'select',
			'name' => 'ozy_coiffeur_meta_page_revolution_slider',
			'label' => __('Revolution Header Slider', 'coiffeur'),
			'description' => __('You can select a header slider if you have installed and activated Revolution Slider which comes bundled with your theme.', 'coiffeur'),
			'items' => array(
				'data' => array(
					array(
						'source' => 'function',
						'value' => 'vp_bind_ozy_coiffeur_revolution_slider',
					),
				),
			),
			'default' => '{{first}}',
		),
		array(
			'type' => 'select',
			'name' => 'ozy_coiffeur_meta_page_master_slider',
			'label' => __('Master Header Slider', 'coiffeur'),
			'description' => __('You can select a header slider if you have installed and activated Master Slider which comes bundled with your theme.', 'coiffeur'),
			'items' => array(
				'data' => array(
					array(
						'source' => 'function',
						'value' => 'vp_bind_ozy_coiffeur_master_slider',
					),
				),
			),
			'default' => '{{first}}',
		),		


		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_use_footer_slider',
			'label' => __('Use Footer Slider', 'coiffeur'),
			'description' => __('You can use footer slider with header slider too.', 'coiffeur'),
		),
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'ozy_coiffeur_meta_page_use_footer_slider_group',
			'title'     => __('Footer Slider', 'coiffeur'),
			'dependency' => array(
				'field'    => 'ozy_coiffeur_meta_page_use_footer_slider',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(
				array(
					'type' => 'select',
					'name' => 'ozy_coiffeur_meta_page_revolution_footer_slider',
					'label' => __('Revolution Footer Slider', 'coiffeur'),
					'description' => __('You can select a footer slider if you have installed and activated Revolution Slider which comes bundled with your theme.', 'coiffeur'),
					'items' => array(
						'data' => array(
							array(
								'source' => 'function',
								'value' => 'vp_bind_ozy_coiffeur_revolution_slider',
							),
						),
					),
					'default' => '{{first}}',
				),
				array(
					'type' => 'select',
					'name' => 'ozy_coiffeur_meta_page_master_footer_slider',
					'label' => __('Master Footer Slider', 'coiffeur'),
					'description' => __('You can select a footer slider if you have installed and activated Master Slider which comes bundled with your theme.', 'coiffeur'),
					'items' => array(
						'data' => array(
							array(
								'source' => 'function',
								'value' => 'vp_bind_ozy_coiffeur_master_slider',
							),
						),
					),
					'default' => '{{first}}',
				),				
			),
		),

		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_show_loader',
			'label' => __('Show Loading Screen', 'coiffeur'),
			'description' => __('Check this option to display a loading screen for this page only.', 'coiffeur'),
		),

		/*array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_hide_footer_widget_bar',
			'label' => __('Hide Footer Widget Bar', 'coiffeur'),
			'description' => __('Footer Widget bar will not be shown for this page only.', 'coiffeur'),
		),*/
		array(
			'type' => 'radiobutton',
			'name' => 'ozy_coiffeur_meta_page_hide_footer_widget_bar',
			'label' => __('Footer Bars Visiblity', 'coiffeur'),
			'description' => __('By this option you can hide footer bars as you wish.', 'coiffeur'),
			'items' => array(
				array(
					'value' => '-1',
					'label' => __('All Visible', 'coiffeur'),
				),
				array(
					'value' => '1',
					'label' => __('Hide Widget Bar', 'coiffeur'),
				),
				array(
					'value' => '2',
					'label' => __('Hide Widget Bar and Footer', 'coiffeur'),
				),
			),
			'default' => array(
				'-1',
			),
		),
		


		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_hide_title',
			'label' => __('Hide Page Title', 'coiffeur'),
			'description' => __('Page title will not be shown on the page.', 'coiffeur'),
		),
		
		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_use_no_content_padding',
			'label' => __('No content top padding', 'coiffeur'),
			'description' => __('Check this option to disable the padding top of your content (after page title).', 'coiffeur'),
		),		

		array(
			'type' => 'notebox',
			'name' => 'ozy_coiffeur_meta_page_no_menu_space_infobox',
			'label' => __('Use No Menu Space', 'coiffeur'),
			'description' => __('Following option will help you to create page with no space top of it, just like you can see our preview <a href=\'http://coiffeur.freevision.me/\' target=\'_blank\'>Home</a> and <a href=\'http://coiffeur.freevision.me/pages/about-us/\' target=\'_blank\'>About Us</a> pages.', 'coiffeur'),
			'status' => 'info',
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_no_menu_space',
			'label' => __('Use No Menu Space', 'coiffeur'),
			'description' => __('By checking this option you can make your content start from zero instead.', 'coiffeur'),
			/*'dependency' => array(
				'field'    => 'ozy_coiffeur_meta_page_hide_title',
				'function' => 'vp_dep_boolean',
			),*/
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_use_custom_title',
			'label' => __('Custom Header/Title', 'coiffeur'),
			'description' => __('There are several options to help you customize your page header.', 'coiffeur'),
		),
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'ozy_coiffeur_meta_page_use_custom_title_group',
			'title'     => __('Custom Header/Title Options', 'coiffeur'),
			'dependency' => array(
				'field'    => 'ozy_coiffeur_meta_page_use_custom_title',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(
				/*array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_custom_title_nopadding',
					'label' => __('No Padding', 'coiffeur'),
					'description' => __('Use this option to remove padding from content container. Usable when you like to use continious/same color from heading to content.', 'coiffeur'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => __('Left', 'coiffeur'),
						),
						array(
							'value' => 'right',
							'label' => __('Right', 'coiffeur'),
						),
						array(
							'value' => 'center',
							'label' => __('Center', 'coiffeur'),
						),
					),
					'default' => array(
						'left',
					),
				),*/		
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_custom_title_position',
					'label' => __('Title Position', 'coiffeur'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => __('Left', 'coiffeur'),
						),
						array(
							'value' => 'right',
							'label' => __('Right', 'coiffeur'),
						),
						array(
							'value' => 'center',
							'label' => __('Center', 'coiffeur'),
						),
					),
					'default' => array(
						'left',
					),
				),			
				array(
					'type'      => 'textbox',
					'name'      => 'ozy_coiffeur_meta_page_custom_title',
					'label'     => __('Page Title', 'coiffeur'),
				),
				array(
					'type'      => 'color',
					'name'      => 'ozy_coiffeur_meta_page_custom_title_color',
					'label'     => __('Title Color', 'coiffeur'),
					'default' => '',
					'format' => 'rgba'
				),				
				array(
					'type'      => 'textbox',
					'name'      => 'ozy_coiffeur_meta_page_custom_sub_title',
					'label'     => __('Sub Title', 'coiffeur'),
				),
				array(
					'type'      => 'color',
					'name'      => 'ozy_coiffeur_meta_page_custom_sub_title_color',
					'label'     => __('Sub Title Color', 'coiffeur'),
					'default' => '',
					'format' => 'rgba'
				),				
				array(
					'type'      => 'color',
					'name'      => 'ozy_coiffeur_meta_page_custom_title_bgcolor',
					'label'     => __('Header Background Color', 'coiffeur'),
					'default' => '',
					'format' => 'rgba'
				),				
				array(
					'type'      => 'upload',
					'name'      => 'ozy_coiffeur_meta_page_custom_title_bg',
					'label'     => __('Header Image', 'coiffeur'),
					'description'=> __('Please use images like 1600px, 2000px wide and have a minimum height like 475px for good results.', 'coiffeur'),
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_custom_title_bg_x_position',
					'label' => __('Background X-Position', 'coiffeur'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => __('Left', 'coiffeur'),
						),
						array(
							'value' => 'right',
							'label' => __('Right', 'coiffeur'),
						),
						array(
							'value' => 'center',
							'label' => __('Center', 'coiffeur'),
						),
						array(
							'value' => 'top',
							'label' => __('Top', 'coiffeur'),
						),
						array(
							'value' => 'bottom',
							'label' => __('Bottom', 'coiffeur'),
						),
					),
					'default' => array(
						'left',
					),
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_custom_title_bg_y_position',
					'label' => __('Background Y-Position', 'coiffeur'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => __('Left', 'coiffeur'),
						),
						array(
							'value' => 'right',
							'label' => __('Right', 'coiffeur'),
						),
						array(
							'value' => 'center',
							'label' => __('Center', 'coiffeur'),
						),
						array(
							'value' => 'top',
							'label' => __('Top', 'coiffeur'),
						),
						array(
							'value' => 'bottom',
							'label' => __('Bottom', 'coiffeur'),
						),
					),
					'default' => array(
						'top',
					),
				),				
				array(
					'type'      => 'textbox',
					'name'      => 'ozy_coiffeur_meta_page_custom_title_height',
					'label'     => __('Header Height', 'coiffeur'),
					'description'=> __('Height of your header in pixels? Don\'t include "px" in the string. e.g. 400', 'coiffeur'),
					'default'	=> 100,
					'validation' => 'numeric'
				),				
			),
		),		
		
	
		
		
		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_hide_content',
			'label' => __('Hide Page Content', 'coiffeur'),
			'description' => __('Page content will not be shown. Supposed to use with Video backgrounds or Fullscreen sliders.', 'coiffeur'),
		),		
		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_use_sidebar',
			'label' => __('Use Custom Sidebar', 'coiffeur'),
			'description' => __('You can use custom sidebar individually.', 'coiffeur'),
		),
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'ozy_coiffeur_meta_page_sidebar_group',
			'title'     => __('Custom Sidebar', 'coiffeur'),
			'dependency' => array(
				'field'    => 'ozy_coiffeur_meta_page_use_sidebar',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(
				array(
					'type' => 'radioimage',
					'name' => 'ozy_coiffeur_meta_page_sidebar_position',
					'label' => __('Sidebar Position', 'coiffeur'),
					'description' => __('Select one of available header type.', 'coiffeur'),
					'item_max_width' => '86',
					'items' => array(
						array(
							'value' => 'full',
							'label' => __('No Sidebar', 'coiffeur'),
							'img' => OZY_BASE_URL . 'admin/images/full-width.png',
						),
						array(
							'value' => 'left',
							'label' => __('Left Sidebar', 'coiffeur'),
							'img' => OZY_BASE_URL . 'admin/images/left-sidebar.png',
						),
						array(
							'value' => 'right',
							'label' => __('Right Sidebar', 'coiffeur'),
							'img' => OZY_BASE_URL . 'admin/images/right-sidebar.png',
						)
					),
					'default' => '{{first}}',
				),			
				array(
					'type' => 'select',
					'name' => 'ozy_coiffeur_meta_page_sidebar',
					'label' => __('Sidebar', 'coiffeur'),
					'items' => array(
						'data' => array(
							array(
								'source' => 'function',
								'value' => 'vp_bind_ozy_coiffeur_sidebars',
							),
						),
					),
				),											
			),
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_use_custom_style',
			'label' => __('Use Custom Style', 'coiffeur'),
			'description' => __('Options to customize your page individually.', 'coiffeur'),
		),
		array(
			'type'      => 'group',
			'repeating' => false,
			'length'    => 1,
			'name'      => 'ozy_coiffeur_meta_page_layout_group',
			'title'     => __('Layout Styling', 'coiffeur'),
			'dependency' => array(
				'field'    => 'ozy_coiffeur_meta_page_use_custom_style',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(					
				array(
					'type' => 'color',
					'name' => 'ozy_coiffeur_meta_page_layout_ascend_background',
					'label' => __('Background Color', 'coiffeur'),
					'description' => __('This option will affect, main wrapper\'s background color.', 'coiffeur'),
					'default' => 'rgba(255,255,255,1)',
					'format' => 'rgba',
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_coiffeur_meta_page_layout_transparent_background',
					'label' => __('Transparent Content Background', 'coiffeur'),
					'description' => __('If you want, you can use transparent background for your content.', 'coiffeur'),
					'default' => '0',
				)														
			),
		),
		array(
			'type' => 'toggle',
			'name' => 'ozy_coiffeur_meta_page_use_custom_background',
			'label' => __('Use Custom Background', 'coiffeur'),
			'description' => __('Lots of options to customize your page background individually.', 'coiffeur'),
		),		
		array(
			'type'      => 'group',
			'repeating' => false,
			'name'      => 'ozy_coiffeur_meta_page_background_group',
			'title'     => __('Background Styling', 'coiffeur'),
			'dependency' => array(
				'field'    => 'ozy_coiffeur_meta_page_use_custom_background',
				'function' => 'vp_dep_boolean',
			),
			'fields'    => array(					
				array(
					'type' => 'upload',
					'name' => 'ozy_coiffeur_meta_page_background_image',
					'label' => __('Custom Background Image', 'coiffeur'),
					'description' => __('Upload or choose custom page background image.', 'coiffeur'),
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_background_image_size',
					'label' => __('Background Image Size', 'coiffeur'),
					'description' => __('Only available on browsers which supports CSS3.', 'coiffeur'),
					'items' => array(
						array(
							'value' => '',
							'label' => __('-not set-', 'coiffeur'),
						),			
						array(
							'value' => 'cover',
							'label' => __('cover', 'coiffeur'),
						),
						array(
							'value' => 'contain',
							'label' => __('contain', 'coiffeur'),
						)
					),
					'default' => '{{first}}',
				),

				array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_background_image_pos_x',
					'label' => __('Background Position X', 'coiffeur'),
					'items' => array(
						array(
							'value' => 'left',
							'label' => __('left', 'coiffeur'),
						),			
						array(
							'value' => 'center',
							'label' => __('center', 'coiffeur'),
						),
						array(
							'value' => 'right',
							'label' => __('right', 'coiffeur'),
						)
					),
					'default' => 'left',
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_background_image_pos_y',
					'label' => __('Background Position Y', 'coiffeur'),
					'items' => array(
						array(
							'value' => 'top',
							'label' => __('top', 'coiffeur'),
						),			
						array(
							'value' => 'center',
							'label' => __('center', 'coiffeur'),
						),
						array(
							'value' => 'bottom',
							'label' => __('bottom', 'coiffeur'),
						)
					),
					'default' => 'top',
				),				
				
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_background_image_repeat',
					'label' => __('Background Image Repeat', 'coiffeur'),
					'items' => array(
						array(
							'value' => 'inherit',
							'label' => __('inherit', 'coiffeur'),
						),			
						array(
							'value' => 'no-repeat',
							'label' => __('no-repeat', 'coiffeur'),
						),
						array(
							'value' => 'repeat',
							'label' => __('repeat', 'coiffeur'),
						),
						array(
							'value' => 'repeat-x',
							'label' => __('repeat-x', 'coiffeur'),
						),
						array(
							'value' => 'repeat-y',
							'label' => __('repeat-y', 'coiffeur'),
						)
					),
					'default' => '{{first}}',
				),
				array(
					'type' => 'radiobutton',
					'name' => 'ozy_coiffeur_meta_page_background_image_attachment',
					'label' => __('Background Image Attachment', 'coiffeur'),
					'items' => array(
						array(
							'value' => '',
							'label' => __('-not set-', 'coiffeur'),
						),			
						array(
							'value' => 'fixed',
							'label' => __('fixed', 'coiffeur'),
						),
						array(
							'value' => 'scroll',
							'label' => __('scroll', 'coiffeur'),
						),
						array(
							'value' => 'local',
							'label' => __('local', 'coiffeur')
						)
					),
					'default' => '{{first}}',
				),										
				array(
					'type' => 'color',
					'name' => 'ozy_coiffeur_meta_page_background_color',
					'label' => __('Background Color', 'coiffeur'),
					'description' => __('This option will affect only page background.', 'coiffeur'),
					'default' => '#ffffff',
					'format' => 'hex',
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_coiffeur_meta_page_background_use_gmap',
					'label' => __('Use Google Map', 'coiffeur'),
					'description' => __('Instead of using a static background, you can use a Google Map as background.', 'coiffeur'),
				),					
				array(
					'type'      => 'group',
					'repeating' => false,
					'name'      => 'ozy_coiffeur_meta_page_background_gmap_group',
					'title'     => __('Google Map', 'coiffeur'),
					'dependency' => array(
						'field'    => 'ozy_coiffeur_meta_page_background_use_gmap',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'textbox',
							'name' => 'ozy_coiffeur_meta_page_background_gmap_address',
							'label' => __('iFrame Src', 'coiffeur'),
							'description' => __('Enter src attribute of your Google Map iFrame.', 'coiffeur'),
						)												
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_coiffeur_meta_page_background_use_slider',
					'label' => __('Use Background Slider', 'coiffeur'),
					'description' => __('Instead of using a static background, you can use background image slider.', 'coiffeur'),
				),					
				array(
					'type'      => 'group',
					'repeating' => true,
					'sortable' => true,
					'name'      => 'ozy_coiffeur_meta_page_background_slider_group',
					'title'     => __('Slider Image', 'coiffeur'),
					'dependency' => array(
						'field'    => 'ozy_coiffeur_meta_page_background_use_slider',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_meta_page_background_slider_image',
							'label' => __('Slider Image', 'coiffeur'),
							'description' => __('Upload or choose custom background image.', 'coiffeur'),
						)												
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_coiffeur_meta_page_background_use_video_self',
					'label' => __('Use Self Hosted Video', 'coiffeur'),
					'description' => __('Instead of using a static background, you can use self hosted video.', 'coiffeur'),
				),					
				array(
					'type'      => 'group',
					'repeating' => false,
					'sortable' => false,
					'name'      => 'ozy_coiffeur_meta_page_background_video_self_group',
					'title'     => __('Self Hosted Video', 'coiffeur'),
					'dependency' => array(
						'field'    => 'ozy_coiffeur_meta_page_background_use_video_self',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_meta_page_background_video_self_image',
							'label' => __('Poster Image', 'coiffeur'),
							'description' => __('Upload or choose a poster image.', 'coiffeur'),
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_meta_page_background_video_self_mp4',
							'label' => __('MP4 File', 'coiffeur'),
							'description' => __('Upload or choose a MP4 file.', 'coiffeur'),
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_meta_page_background_video_self_webm',
							'label' => __('WEBM File', 'coiffeur'),
							'description' => __('Upload or choose a WEBM file.', 'coiffeur'),
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_meta_page_background_video_self_ogv',
							'label' => __('OGV File', 'coiffeur'),
							'description' => __('Upload or choose an OGV file.', 'coiffeur'),
						)
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_coiffeur_meta_page_background_use_video_youtube',
					'label' => __('Use YouTube Video', 'coiffeur'),
					'description' => __('Instead of using a static background, you can use YouTube video.', 'coiffeur'),
				),					
				array(
					'type'      => 'group',
					'repeating' => false,
					'sortable' => false,
					'name'      => 'ozy_coiffeur_meta_page_background_video_youtube_group',
					'title'     => __('YouTube Video', 'coiffeur'),
					'dependency' => array(
						'field'    => 'ozy_coiffeur_meta_page_background_use_video_youtube',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_meta_page_background_video_youtube_image',
							'label' => __('Poster Image', 'coiffeur'),
							'description' => __('Upload or choose a poster image.', 'coiffeur'),
						),
						array(
							'type' => 'textbox',
							'name' => 'ozy_coiffeur_meta_page_background_video_youtube_id',
							'label' => __('YouTube Video ID', 'coiffeur'),
							'description' => __('Enter YouTube video ID. http://www.youtube.com/watch?v=<span style="color:red;">mYKA-VokOtA</span> text marked with red is the ID you have to be looking for.', 'coiffeur'),
						)
					),
				),
				array(
					'type' => 'toggle',
					'name' => 'ozy_coiffeur_meta_page_background_use_video_vimeo',
					'label' => __('Use Vimeo Video', 'coiffeur'),
					'description' => __('Instead of using a static background, you can use Vimeo video.', 'coiffeur'),
				),					
				array(
					'type'      => 'group',
					'repeating' => false,
					'sortable' => false,
					'name'      => 'ozy_coiffeur_meta_page_background_video_vimeo_group',
					'title'     => __('Vimeo Video', 'coiffeur'),
					'dependency' => array(
						'field'    => 'ozy_coiffeur_meta_page_background_use_video_vimeo',
						'function' => 'vp_dep_boolean',
					),
					'fields'    => array(					
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_meta_page_background_video_vimeo_image',
							'label' => __('Poster Image', 'coiffeur'),
							'description' => __('Upload or choose a poster image.', 'coiffeur'),
						),
						array(
							'type' => 'textbox',
							'name' => 'ozy_coiffeur_meta_page_background_video_vimeo_id',
							'label' => __('Vimeo Video ID', 'coiffeur'),
							'description' => __('Enter Vimeo video ID. http://vimeo.com/<span style="color:red;">71964690</span> text marked with red is the ID you have to be looking for.', 'coiffeur'),
						)
					),
				)
			),
		),
		array(
			'type' => 'radiobutton',
			'name' => 'ozy_coiffeur_meta_page_page_model',
			'label' => __('Default Page Model', 'coiffeur'),
			'items' => array(
				array(
					'value' => 'generic',
					'label' => __('Use From Theme Options', 'coiffeur'),
				),			
				array(
					'value' => 'boxed',
					'label' => __('Boxed', 'coiffeur'),
				),
				array(
					'value' => 'full',
					'label' => __('Full', 'coiffeur'),
				),
			),
			'default' => array(
				'{{first}}',
			),
		)				
	),	
);

/**
 * EOF
 */