<?php
$top_nav_info_box_array =		array(
									array(
										'type' => 'textbox',
										'name' => 'ozy_coiffeur_top_nav_info1',
										'label' => __('Phone', 'coiffeur'),
										'default' => __('Customer Support & Sales 08005877760', 'coiffeur')
									),
									array(
										'type' => 'textbox',
										'name' => 'ozy_coiffeur_top_nav_info2',
										'label' => __('Address', 'coiffeur'),
										'default' => __('Unit D2/D3, Wira Offie Park LS16 6EB', 'coiffeur')
									)
								);

$footer_copyright_array =		array(
									array(
										'type' => 'textbox',
										'name' => 'ozy_coiffeur_section_footer_copyright_text',
										'label' => __('Footer Text', 'coiffeur'),
										'default' => __('&copy; 2023 Coiffeur - All Rights Reserved', 'coiffeur')
									)
								);

$cookie_notice_array =	array(
							array(
								'type' => 'toggle',
								'name' => 'ozy_coiffeur_cookie_banner',
								'label' => esc_attr__('Enable Cookie Notice Banner?', 'coiffeur'),
								'description' => esc_attr__('Enable / Disable cookie notice banner site wide.', 'coiffeur'),
								'default' => '0'
							),
							array(
								'type' => 'codeeditor',
								'name' => 'ozy_coiffeur_cookie_notice',
								'label' => esc_attr__('Notice Text', 'coiffeur'),
								'theme' => 'mono_industrial',
								'mode' => 'html',
								'default' => wp_kses(__('We use cookies in accordance with our Cookie Notice. Please refer to our <a href="#">Cookie Notice</a> here for more information on how we use cookies and how to adjust your browser settings to block cookies. If you consent to the use of cookies, please click Accept. We will not ask for consent for strictly necessary cookies, but if you choose to block strictly necessary cookies this may affect your website experience.', 'coiffeur'),array('a' => array('href' => array(), 'target' => array())))
							),
							array(
								'type' => 'textbox',
								'name' => 'ozy_coiffeur_cookie_button',
								'label' => esc_attr__('Button Caption', 'coiffeur'),
								'default' => esc_attr__('ACCEPT', 'coiffeur')
							)
						);

if(ozy_is_wpml_active()){
	$languages = icl_get_languages('skip_missing=0&orderby=code');
	if(!empty($languages)){
		foreach($languages as $l){
			if(OZY_WPLANG != $l['language_code']) {
				array_push($top_nav_info_box_array, array(
													'type' => 'textbox',
													'name' => 'ozy_coiffeur_top_nav_info1' . $l['language_code'],
													'label' => __('Phone', 'coiffeur') . ' (' . strtoupper($l['native_name']) .')'
												));
				array_push($top_nav_info_box_array, array(
													'type' => 'textbox',
													'name' => 'ozy_coiffeur_top_nav_info2' . $l['language_code'],
													'label' => __('Address', 'coiffeur') . ' (' . strtoupper($l['native_name']) .')'
												));
				array_push($footer_copyright_array, array(
													'type' => 'textbox',
													'name' => 'ozy_coiffeur_section_footer_copyright_text' . $l['language_code'],
													'label' => __('Footer Text', 'coiffeur') . ' (' . strtoupper($l['native_name']) .')'
												));
				array_push($cookie_notice_array,
					array(
						'type' => 'codeeditor',
						'name' => 'ozy_coiffeur_cookie_notice' . $l['language_code'],
						'label' => esc_attr__('Notice Text', 'coiffeur') . '(' . strtoupper($l['native_name']) .')',
						'theme' => 'mono_industrial',
						'mode' => 'html',
					),array(
						'type' => 'textbox',
						'name' => 'ozy_coiffeur_cookie_button' . $l['language_code'],
						'label' => esc_attr__('Button Caption', 'coiffeur') . '(' . strtoupper($l['native_name']) .')',
						'default' => esc_attr__('ACCEPT', 'coiffeur')
					)
				);
			}
		}
	}
}

//return
$ozy_coiffeur_option_arr = array(
	'title' => __('COIFFEUR Option Panel', 'coiffeur'),
	'logo' => OZY_BASE_URL . 'admin/images/logo.png',
	'menus' => array(
		array(
			'title' => __('General Options', 'coiffeur'),
			'name' => 'ozy_coiffeur_general_options',
			'icon' => 'font-awesome:fa-gear',
			'controls' => array(
				array(
					'type' => 'section',
					'title' => esc_attr__('Cookie Notice Banner', 'coiffeur'),
					'fields' => $cookie_notice_array
				),

				array(
					'type' => 'section',
					'title' => __('General', 'coiffeur'),
					'fields' => array(
						array(
							'type' => 'toggle',
							'name' => 'ozy_coiffeur_back_to_top_button',
							'label' => __('Back To Top Button', 'coiffeur'),
							'description' => __('Enable / Disable Back To Top Button globally.', 'coiffeur'),
							'default' => '1',
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_favicon',
							'label' => __('Favicon', 'coiffeur'),
							'description' => __('Upload a 16px x 16px .png or .gif image, will be set as your favicon.', 'coiffeur'),
							'default' => get_stylesheet_directory_uri() . '/favico.png',
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_favicon_apple_small',
							'label' => __('Apple Touch Icon (small)', 'coiffeur'),
							'description' => __('Upload a 57px x 57px .png image, will be set as your small Apple Touch Icon.', 'coiffeur'),
							'default' => get_stylesheet_directory_uri() . '/images/favico_57.png',
						),array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_favicon_apple_medium',
							'label' => __('Apple Touch Icon (medium)', 'coiffeur'),
							'description' => __('Upload a 76px x 76px .png image, will be set as your large Apple Touch Icon (iPad).', 'coiffeur'),
							'default' => get_stylesheet_directory_uri() . '/images/favico_76.png',
						),array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_favicon_apple_large',
							'label' => __('Apple Touch Icon (large)', 'coiffeur'),
							'description' => __('Upload a 120px x 120px .png image, will be set as your large Apple Touch Icon (iPhone Retina).', 'coiffeur'),
							'default' => get_stylesheet_directory_uri() . '/images/favico_120.png',
						),array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_favicon_apple_xlarge',
							'label' => __('Apple Touch Icon (large)', 'coiffeur'),
							'description' => __('Upload a 152px x 152px .png image, will be set as your large Apple Touch Icon (iPad Retina).', 'coiffeur'),
							'default' => get_stylesheet_directory_uri() . '/images/favico_152.png',
						),
						array(
							'type' => 'codeeditor',
							'name' => 'ozy_coiffeur_custom_css',
							'label' => __('Custom CSS', 'coiffeur'),
							'description' => __('Write your custom css here. <strong>Please do not add "style" tags.</strong>', 'coiffeur'),
							'theme' => 'eclipse',
							'mode' => 'css',
						),
						array(
							'type' => 'codeeditor',
							'name' => 'ozy_coiffeur_custom_script',
							'label' => __('Custom JS', 'coiffeur'),
							'description' => __('Write your custom js here. Please do not add script tags into this box. <strong>Please do not add "script" tags.</strong>', 'coiffeur'),
							'theme' => 'mono_industrial',
							'mode' => 'javascript',
						),
					),
				),
			),
		),


		array(
			'title' => __('Typography', 'coiffeur'),
			'name' => 'ozy_coiffeur_typography',
			'icon' => 'font-awesome:fa-pencil',
			'controls' => array(
				array(
					'type' => 'section',
					'title' => __('Extended Parameters', 'coiffeur'),
					'fields' => array(
						array(
							'type' => 'textbox',
							'name' => 'ozy_coiffeur_typography_google_param',
							'description' => 'Add extra parameters here. By this option, you can load non-latin charset or more types byt available parameters. Use like ":400,100,300,700".',
							'default' => ':400,100,300,700'
						),
					)
				),
				array(
					'type' => 'section',
					'title' => __('Content Typography', 'coiffeur'),
					'fields' => array(
						array(
							'type' => 'html',
							'name' => 'ozy_coiffeur_typography_font_preview',
							'binding' => array(
								'field'    => 'ozy_coiffeur_typography_font_face,ozy_coiffeur_typography_font_style,ozy_coiffeur_typography_font_weight,ozy_coiffeur_typography_font_size, ozy_coiffeur_typography_font_line_height',
								'function' => 'vp_font_preview',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_font_face',
							'label' => __('Font Face', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_gwf_family',
									),
								),
							),
							'default' => 'Raleway'
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_font_style',
							'label' => __('Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_font_weight',
							'label' => __('Font Weight', 'coiffeur'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_font_face',
										'value' => 'vp_get_gwf_weight',
									),
								),
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_font_size',
							'label'   => __('Font Size (px)', 'coiffeur'),
							'min'     => '5',
							'max'     => '86',
							'default' => '14',
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_font_line_height',
							'label'   => __('Line Height (em)', 'coiffeur'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
					),
				),
				array(
					'type' => 'section',
					'title' => __('Heading Typography', 'coiffeur'),
					'fields' => array(
						array(
							'type' => 'html',
							'name' => 'ozy_coiffeur_typography_heading_font_preview',
							'binding' => array(
								'field'    => 'ozy_coiffeur_typography_heading_font_face,ozy_coiffeur_typography_heading_font_style,ozy_coiffeur_typography_heading_font_weight,ozy_coiffeur_typography_heading_h1_font_size',
								'function' => 'vp_font_preview_simple',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_face',
							'label' => __('Font Face', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_gwf_family',
									),
								),
							),
							'default' => 'Old Standard TT'
						)/*,
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_heading_font_style',
							'label' => __('Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),*/
						/*array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_heading_font_weight',
							'label' => __('Font Weight', 'coiffeur'),
							'default' => '300',
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_heading_font_face',
										'value' => 'vp_get_gwf_weight',
									),
								),
							),
						),*/
					),
				),
				array(
					'type' => 'section',
					'title' => __('H1 Options', 'coiffeur'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_h1_font_size',
							'label'   => __('H1 Size (px)', 'coiffeur'),
							'min'     => '5',
							'max'     => '128',
							'default' => '40',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_heading_h1_font_style',
							'label' => __('H1 Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_weight_h1',
							'label' => __('H1 Weight', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'700',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_line_height_h1',
							'label'   => __('H1 Line Height (em)', 'coiffeur'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_ls_h1',
							'label' => __('H1 Letter Spacing', 'coiffeur'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => __('H2 Options', 'coiffeur'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_h2_font_size',
							'label'   => __('H2 Size (px)', 'coiffeur'),
							'min'     => '5',
							'max'     => '128',
							'default' => '30',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_heading_h2_font_style',
							'label' => __('H2 Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_weight_h2',
							'label' => __('H2 Weight', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'700',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_line_height_h2',
							'label'   => __('H2 Line Height (em)', 'coiffeur'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_ls_h2',
							'label' => __('H2 Letter Spacing', 'coiffeur'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => __('H3 Options', 'coiffeur'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_h3_font_size',
							'label'   => __('H3 Size (px)', 'coiffeur'),
							'min'     => '5',
							'max'     => '128',
							'default' => '22',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_heading_h3_font_style',
							'label' => __('H3 Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_weight_h3',
							'label' => __('H3 Weight', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'700',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_line_height_h3',
							'label'   => __('H3 Line Height (em)', 'coiffeur'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_ls_h3',
							'label' => __('H3 Letter Spacing', 'coiffeur'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => __('H4 Options', 'coiffeur'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_h4_font_size',
							'label'   => __('H4 Size (px)', 'coiffeur'),
							'min'     => '5',
							'max'     => '128',
							'default' => '18',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_heading_h4_font_style',
							'label' => __('H4 Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_weight_h4',
							'label' => __('H4 Weight', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'700',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_line_height_h4',
							'label'   => __('H4 Line Height (em)', 'coiffeur'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_ls_h4',
							'label' => __('H4 Letter Spacing', 'coiffeur'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => __('H5 Options', 'coiffeur'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_h5_font_size',
							'label'   => __('H5 Size (px)', 'coiffeur'),
							'min'     => '5',
							'max'     => '128',
							'default' => '16',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_heading_h5_font_style',
							'label' => __('H5 Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_weight_h5',
							'label' => __('H5 Weight', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'400',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_line_height_h5',
							'label'   => __('H5 Line Height (em)', 'coiffeur'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_ls_h5',
							'label' => __('H5 Letter Spacing', 'coiffeur'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),
				array(
					'type' => 'section',
					'title' => __('H6 Options', 'coiffeur'),
					'fields' => array(
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_h6_font_size',
							'label'   => __('H6 Size (px)', 'coiffeur'),
							'min'     => '5',
							'max'     => '128',
							'default' => '14',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_typography_heading_h6_font_style',
							'label' => __('H6 Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_typography_heading_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'italic',
							),
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_weight_h6',
							'label' => __('H6 Weight', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_weight_list',
									),
								),
							),
							'default' => array(
								'700',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_typography_heading_line_height_h6',
							'label'   => __('H6 Line Height (em)', 'coiffeur'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_typography_heading_font_ls_h6',
							'label' => __('H6 Letter Spacing', 'coiffeur'),
							'default' => 'normal',
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_font_letter_spacing_list',
									),
								),
							),
						),
					),
				),


				array(
					'type' => 'section',
					'title' => __('Primary Menu Typography', 'coiffeur'),
					'name' => 'ozy_coiffeur_primary_menu_section_typography',
					'fields' => array(
						array(
							'type' => 'select',
							'name' => 'ozy_coiffeur_primary_menu_typography_font_face',
							'label' => __('Font Face', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'function',
										'value' => 'vp_get_gwf_family',
									),
								),
							),
							'default' => 'Raleway'
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_primary_menu_typography_font_style',
							'label' => __('Font Style', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_primary_menu_typography_font_face',
										'value' => 'vp_get_gwf_style',
									),
								),
							),
							'default' => array(
								'normal',
							),
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_primary_menu_typography_font_weight',
							'label' => __('Font Weight', 'coiffeur'),
							'items' => array(
								'data' => array(
									array(
										'source' => 'binding',
										'field' => 'ozy_coiffeur_primary_menu_typography_font_face',
										'value' => 'vp_get_gwf_weight',
									),
								),
							),
							'default' => array(
								'600',
							),
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_primary_menu_typography_font_size',
							'label'   => __('Font Size (px)', 'coiffeur'),
							'min'     => '5',
							'max'     => '128',
							'default' => '12',
						),
						array(
							'type'    => 'slider',
							'name'    => 'ozy_coiffeur_primary_menu_typography_line_height',
							'label'   => __('Line Height (em)', 'coiffeur'),
							'min'     => '0',
							'max'     => '3',
							'default' => '1.5',
							'step'    => '0.1',
						),
					),
				),

			),
		),


		array(
			'title' => __('Layout', 'coiffeur'),
			'name' => 'ozy_coiffeur_layout',
			'icon' => 'font-awesome:fa-magic',
			'menus' => array(
				array(
					'title' => __('Primary Menu / Logo', 'coiffeur'),
					'name' => 'ozy_coiffeur_primary_menu',
					'icon' => 'font-awesome:fa-cogs',
					'controls' => array(

						array(
							'type' => 'section',
							'title' => __('Top Info Bar', 'coiffeur'),
							'name' => 'ozy_coiffeur_section_top_nav_info_box_layout',
							'fields' => $top_nav_info_box_array
						),

						array(
							'type' => 'section',
							'title' => __('Primary Menu', 'coiffeur'),
							'name' => 'ozy_coiffeur_section_header_layout',
							'fields' => array(
								array(
									'type'    => 'slider',
									'name'    => 'ozy_coiffeur_primary_menu_height',
									'label'   => __('Menu / Logo Height', 'coiffeur'),
									'description'   => __('Set this value to fit at least same as your logo height for perfect results', 'coiffeur'),
									'min'     => '40',
									'max'     => '500',
									'default' => '120',
								),
								array(
									'type' => 'radiobutton',
									'name' => 'ozy_coiffeur_primary_menu_search',
									'label' => __('Search Button / Box', 'coiffeur'),
									'items' => array(
										array(
											'value' => '1',
											'label' => __('On', 'coiffeur'),
										),
										array(
											'value' => '-1',
											'label' => __('Off', 'coiffeur'),
										)
									),
									'default' => array(
										'1',
									),
								),
								array(
									'type' => 'radiobutton',
									'name' => 'ozy_coiffeur_primary_menu_side_menu',
									'label' => __('Side Menu Button', 'coiffeur'),
									'description' => __('Disabling this will not disable mobile menu, only on desktop mode', 'coiffeur'),
									'items' => array(
										array(
											'value' => '1',
											'label' => __('On', 'coiffeur'),
										),
										array(
											'value' => '-1',
											'label' => __('Off', 'coiffeur'),
										)
									),
									'default' => array(
										'1',
									),
								),
								array(
									'type' => 'radiobutton',
									'name' => 'ozy_coiffeur_primary_menu_align',
									'label' => __('Menu Align', 'coiffeur'),
									'items' => array(
										array(
											'value' => 'left',
											'label' => __('Left', 'coiffeur'),
										),
										array(
											'value' => 'right',
											'label' => __('Right', 'coiffeur'),
										)
									),
									'validation' => 'required',
									'default' => array(
										'right',
									),
								)
							),
						),
						array(
							'type' => 'section',
							'title' => __('Logo', 'coiffeur'),
							'name' => 'ozy_coiffeur_section_image_logo',
							'description' => __('You can use custom image logo for your site. To use this option, first activate \'Use Custom Logo\' switch', 'coiffeur'),
							'fields' => array(
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_use_custom_logo',
									'label' => __('Use Custom Logo', 'coiffeur'),
									'default' => 1,
									'description' => __('Use custom logo or text logo', 'coiffeur'),
								),
								array(
									'type' => 'upload',
									'name' => 'ozy_coiffeur_custom_logo',
									'label' => __('Custom Logo', 'coiffeur'),
									'default' => OZY_BASE_URL . 'images/logo.png',
									'dependency' => array(
										'field' => 'ozy_coiffeur_use_custom_logo',
										'function' => 'vp_dep_boolean',
									),
									'description' => __('Upload or choose custom logo', 'coiffeur'),
								),
								array(
									'type' => 'upload',
									'name' => 'ozy_coiffeur_custom_logo_alternate',
									'label' => __('Custom Logo (Alternate)', 'coiffeur'),
									'default' => OZY_BASE_URL . 'images/logo-alternate.png',
									'dependency' => array(
										'field' => 'ozy_coiffeur_use_custom_logo',
										'function' => 'vp_dep_boolean',
									),
									'description' => __('Upload or choose custom logo', 'coiffeur'),
								),
								array(
									'type' => 'upload',
									'name' => 'ozy_coiffeur_custom_logo_retina',
									'label' => __('Custom Logo Retina', 'coiffeur'),
									'default' => OZY_BASE_URL . 'images/logo@2x.png',
									'dependency' => array(
										'field' => 'ozy_coiffeur_use_custom_logo',
										'function' => 'vp_dep_boolean',
									),
									'description' => __('Upload or choose custom 2x bigger logo', 'coiffeur'),
								),
								array(
									'type' => 'upload',
									'name' => 'ozy_coiffeur_custom_logo_retina_alternate',
									'label' => __('Custom Logo Retina (Alternate)', 'coiffeur'),
									'default' => OZY_BASE_URL . 'images/logo-alternate@2x.png',
									'dependency' => array(
										'field' => 'ozy_coiffeur_use_custom_logo',
										'function' => 'vp_dep_boolean',
									),
									'description' => __('Upload or choose custom 2x bigger logo', 'coiffeur'),
								),
							),
						),
					),
				),


				array(
					'title' => __('Footer', 'coiffeur'),
					'name' => 'ozy_coiffeur_footer',
					'icon' => 'font-awesome:fa-cog',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => __('Footer Layout', 'coiffeur'),
							'name' => 'ozy_coiffeur_section_footer_copyright',
							'fields' => $footer_copyright_array
						),
						array(
							'type' => 'section',
							'title' => __('Footer Layout', 'coiffeur'),
							'name' => 'ozy_coiffeur_section_footer_layout',
							'fields' => array(
								array(
									'type' => 'slider',
									'name' => 'ozy_coiffeur_footer_height',
									'label' => __('Footer Height', 'coiffeur'),
									'description' => __('Select height of your footer. Minimum value set to 30 and maximum set to 360. Will be processed in pixels.', 'coiffeur'),
									'min' => '30',
									'max' => '360',
									'step' => '1',
									'default' => '56',
								),
							),
						),

					),
				),


				array(
					'title' => __('Content / Page / Post', 'coiffeur'),
					'name' => 'ozy_coiffeur_page',
					'icon' => 'font-awesome:fa-pencil',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => __('Page Position / Layout', 'coiffeur'),
							'name' => 'ozy_coiffeur_page_section_position',
							'description' => __('Select position for your page content', 'coiffeur'),
							'fields' => array(
								/*array(
									'type' => 'radiobutton',
									'name' => 'ozy_coiffeur_page_width',
									'label' => __('Default Width', 'coiffeur'),
									'description' => __('Only available for desktop resolations.', 'coiffeur'),
									'items' => array(
										array(
											'value' => '1140',
											'label' => __('1140px', 'coiffeur'),
										),
										array(
											'value' => '960',
											'label' => __('960px', 'coiffeur'),
										),
										array(
											'value' => '861',
											'label' => __('861px', 'coiffeur'),
										),
									),
									'default' => array(
										'1140',
									),
								),*/
								array(
									'type' => 'radiobutton',
									'name' => 'ozy_coiffeur_page_model',
									'label' => __('Default Page Model', 'coiffeur'),
									'items' => array(
										array(
											'value' => 'boxed',
											'label' => __('Boxed', 'coiffeur'),
										),
										array(
											'value' => 'full',
											'label' => __('Full', 'coiffeur'),
										),
									),
									'default' => array(
										'full',
									),
								),
							),
						),
						array(
							'type' => 'section',
							'title' => __('Custom 404 Page', 'coiffeur'),
							'name' => 'ozy_coiffeur_page_section_404_page',
							'description' => __('Select a page to use as your custom 404 (not found) page', 'coiffeur'),
							'fields' => array(
								array(
									'type' => 'select',
									'name' => 'ozy_coiffeur_page_404_page_id',
									'label' => __('Custom 404 Page', 'coiffeur'),
									'description' => __('Select a page to use as custom 4040 page.', 'coiffeur'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_coiffeur_pages',
											),
										),
									),
								)
							),
						),
						array(
							'type' => 'section',
							'title' => __('Page', 'coiffeur'),
							'name' => 'ozy_coiffeur_page_section_page_sidebar_position',
							'description' => __('Select position for your page sidebar', 'coiffeur'),
							'fields' => array(
								array(
									'type' => 'radioimage',
									'name' => 'ozy_coiffeur_page_page_sidebar_position',
									'label' => __('Default Sidebar Position', 'coiffeur'),
									'description' => __('Select one of available header type.', 'coiffeur'),
									'item_max_width' => '86',
									'items' => array(
										array(
											'value' => 'full',
											'label' => __('No Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/full-width.png',
										),
										array(
											'value' => 'left',
											'label' => __('Left Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/left-sidebar.png',
										),
										array(
											'value' => 'right',
											'label' => __('Right Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/right-sidebar.png',
										)
									),
									'default' => array(
										'{{first}}',
									),
								),
								array(
									'type' => 'select',
									'name' => 'ozy_coiffeur_page_page_sidebar_id',
									'label' => __('Default Sidebar', 'coiffeur'),
									'description' => __('This option could be overriden individually.', 'coiffeur'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_coiffeur_sidebars',
											),
										),
									),
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_page_page_comment',
									'label' => __('Comments Section', 'coiffeur'),
									'description' => __('Enable / Disable comment section on the pages', 'coiffeur'),
									'default' => '0',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_page_page_author',
									'label' => __('Author Section', 'coiffeur'),
									'description' => __('Enable / Disable author section on the pages', 'coiffeur'),
									'default' => '0',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_page_page_comment_closed',
									'label' => __('Show Comments Closed Message', 'coiffeur'),
									'description' => __('Whenever comments closed on a page or post a message appears, you can hide it.', 'coiffeur'),
									'default' => '0',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_page_page_share',
									'label' => __('Share Buttons', 'coiffeur'),
									'description' => __('Enable / Disable share buttons for pages.', 'coiffeur'),
									'default' => '0',
								)
							),
						),
						array(
							'type' => 'section',
							'title' => __('Blog', 'coiffeur'),
							'name' => 'ozy_coiffeur_page_section_blog_sidebar_position',
							'description' => __('Select position for your blog page sidebar', 'coiffeur'),
							'fields' => array(
								array(
									'type' => 'radioimage',
									'name' => 'ozy_coiffeur_page_blog_sidebar_position',
									'label' => __('Defaul Sidebar Position', 'coiffeur'),
									'description' => __('Select one of available header type.', 'coiffeur'),
									'item_max_width' => '86',
									'items' => array(
										array(
											'value' => 'full',
											'label' => __('No Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/full-width.png',
										),
										array(
											'value' => 'left',
											'label' => __('Left Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/left-sidebar.png',
										),
										array(
											'value' => 'right',
											'label' => __('Right Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/right-sidebar.png',
										)
									),
									'default' => array(
										'{{first}}',
									),
								),
								array(
									'type' => 'select',
									'name' => 'ozy_coiffeur_page_blog_sidebar_id',
									'label' => __('Default Sidebar', 'coiffeur'),
									'description' => __('This option could be overriden individually.', 'coiffeur'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_coiffeur_sidebars',
											),
										),
									),
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_page_blog_comment',
									'label' => __('Comments Section', 'coiffeur'),
									'description' => __('Enable / Disable comment section on the blog posts', 'coiffeur'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_page_blog_author',
									'label' => __('Author Section', 'coiffeur'),
									'description' => __('Enable / Disable author section on the blog posts', 'coiffeur'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_page_blog_share',
									'label' => __('Share Buttons', 'coiffeur'),
									'description' => __('Enable / Disable share buttons for posts.', 'coiffeur'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_page_blog_related_posts',
									'label' => __('Related Posts', 'coiffeur'),
									'description' => __('Enable / Disable related posts.', 'coiffeur'),
									'default' => '1',
								),
								array(
									'type' => 'select',
									'name' => 'ozy_coiffeur_page_blog_list_page_id',
									'label' => __('Default Listing Page', 'coiffeur'),
									'description' => __('Select a page to use as "Return to Blog" link.', 'coiffeur'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_coiffeur_pages',
											),
										),
									),
								)
							),
						),
						array(
							'type' => 'section',
							'title' => __('WooCommerce', 'coiffeur'),
							'name' => 'ozy_coiffeur_page_section_woocommerce_sidebar_position',
							'description' => __('Select position for your WooCommerce page sidebar', 'coiffeur'),
							'fields' => array(
								array(
									'type' => 'radioimage',
									'name' => 'ozy_coiffeur_page_woocommerce_sidebar_position',
									'label' => __('Default Sidebar Position', 'coiffeur'),
									'description' => __('Select one of available header type.', 'coiffeur'),
									'item_max_width' => '86',
									'items' => array(
										array(
											'value' => 'full',
											'label' => __('No Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/full-width.png',
										),
										array(
											'value' => 'left',
											'label' => __('Left Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/left-sidebar.png',
										),
										array(
											'value' => 'right',
											'label' => __('Right Sidebar', 'coiffeur'),
											'img' => OZY_BASE_URL . 'admin/images/right-sidebar.png',
										)
									),
									'default' => array(
										'{{first}}',
									),
								),
								array(
									'type' => 'select',
									'name' => 'ozy_coiffeur_page_woocommerce_sidebar_id',
									'label' => __('Default Sidebar', 'coiffeur'),
									'description' => __('This option could be overriden individually.', 'coiffeur'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_bind_ozy_coiffeur_sidebars',
											),
										),
									),
								),
								array(
									'type' => 'radiobutton',
									'name' => 'ozy_coiffeur_page_woocommerce_column_count',
									'label' => __('Column Count (Large View)', 'coiffeur'),
									'items' => array(
										array(
											'value' => '3',
											'label' => __('3 columns', 'coiffeur'),
										),
										array(
											'value' => '2',
											'label' => __('2 columns', 'coiffeur'),
										),
									),
									'default' => array(
										'3',
									),
								),
								array(
									'type' => 'radiobutton',
									'name' => 'ozy_coiffeur_page_woocommerce_column_count_mobile',
									'label' => __('Column Count (Mobile View)', 'coiffeur'),
									'items' => array(
										array(
											'value' => '1',
											'label' => __('1 column', 'coiffeur'),
										),
										array(
											'value' => '2',
											'label' => __('2 columns', 'coiffeur'),
										),
									),
									'default' => array(
										'1',
									),
								),								
							),
						),
					),
				),

				array(
					'title' => __('Miscellaneous', 'coiffeur'),
					'name' => 'ozy_coiffeur_misc',
					'icon' => 'font-awesome:fa-puzzle-piece',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => __('Fancy Box (Lightbox)', 'coiffeur'),
							'name' => 'ozy_coiffeur_section_fancybox_layout',
							'fields' => array(
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_fancbox_media',
									'label' => __('Video Support', 'coiffeur'),
									'description' => __('By enabling this option Fancybox will start to support popular media links.', 'coiffeur'),
									'default' => '1',
								),
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_fancbox_thumbnail',
									'label' => __('Thumbnail', 'coiffeur'),
									'description' => __('Enable this option to show thumnails under your Fancybox window.', 'coiffeur'),
									'default' => '0',
								),
							),
						),
					),
				),



				array(
					'title' => __('Countdown Page', 'coiffeur'),
					'name' => 'ozy_coiffeur_countdown',
					'icon' => 'font-awesome:fa-clock-o',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => __('Countdown Page Options', 'coiffeur'),
							'name' => 'ozy_coiffeur_section_countdown',
							'fields' => array(
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_countdown_year',
									'label' => __('End Year', 'coiffeur'),
									'description' => __('Enter the Year of the date counter will count to.', 'coiffeur'),
									'default' => date('Y', time())
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_countdown_month',
									'label' => __('End Month', 'coiffeur'),
									'description' => __('Enter the Month of the date counter will count to.', 'coiffeur'),
									'default' => date('m', time())
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_countdown_day',
									'label' => __('End Day', 'coiffeur'),
									'description' => __('Enter the Day of the date counter will count to.', 'coiffeur'),
									'default' => '15'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_countdown_hour',
									'label' => __('End Hour', 'coiffeur'),
									'description' => __('Enter the Hour of the date counter will count to.', 'coiffeur'),
									'default' => '12'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_countdown_minute',
									'label' => __('End Minute', 'coiffeur'),
									'description' => __('Enter the Minute of the date counter will count to.', 'coiffeur'),
									'default' => '12'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_countdown_second',
									'label' => __('End Second', 'coiffeur'),
									'description' => __('Enter the Second of the date counter will count to.', 'coiffeur'),
									'default' => '00'
								)/*,
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_countdown_minute',
									'label' => __('URL to go on complete', 'coiffeur'),
									'value' => ''
								)*/
							),
						),

					),
				),





			),
		),
		array(
			'name' => 'ozy_coiffeur_color_options',
			'title' => __('Color Options', 'coiffeur'),
			'icon' => 'font-awesome:fa-eye',
			'controls' => array(

				array(
					'type' => 'section',
					'title' => __('GENERIC', 'coiffeur'),
					'fields' => array(
						/*array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_header_background_color',
							'label' => __('Header Background', 'coiffeur'),
							'description' => __('Change this color to alter the accent color globally for your site.', 'coiffeur'),
							'format' => 'rgba',
							'binding' => array(
								'field' => 'ozy_coiffeur_color_preset',
								'function' => 'vp_bind_ozy_coiffeur_header_background',
							),
						),*/
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_content_background_color',
							'label' => __('Content Background', 'coiffeur'),
							'format' => 'rgba',
							'default' => 'rgba(255,255,255,1)'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_content_color',
							'label' => __('Content Color', 'coiffeur'),
							'description' => __('Font color of the content', 'coiffeur'),
							'format' => 'hex',
							'default' => '#000000'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_content_color_alternate',
							'label' => __('Alternate Color #1', 'coiffeur'),
							'description' => __('Like link color, hover color and input elements active border', 'coiffeur'),
							'format' => 'hex',
							'default' => '#f33337'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_content_color_alternate2',
							'label' => __('Alternate Color #2', 'coiffeur'),
							'description' => __('Like footer, footer sidebar title color, text color and seperator color', 'coiffeur'),
							'format' => 'hex',
							'default' => '#000000'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_content_color_alternate3',
							'label' => __('Alternate Color #3', 'coiffeur'),
							'description' => __('Like footer sidebar link color', 'coiffeur'),
							'format' => 'hex',
							'default' => '#ffffff'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_content_background_color_alternate',
							'label' => __('Alternate Background Color', 'coiffeur'),
							'description' => __('Like comments background color', 'coiffeur'),
							'format' => 'rgba',
							'default' => 'rgba(240,240,240,1)'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_separator_color',
							'label' => __('Separator / Border Color', 'coiffeur'),
							'description' => __('Used for, Primary menu, in page Seperators and Comments bottom border', 'coiffeur'),
							'default' => 'rgba(240,240,240,1)',
							'format' => 'rgba'
						),
					),
				),

				array(
					'type' => 'section',
					'title' => __('Primary Menu', 'coiffeur'),
					'name' => 'ozy_coiffeur_primary_menu_section_colors',
					'fields' => array(
						array(
							'type' => 'toggle',
							'name' => 'ozy_coiffeur_primary_menu_section_colors_transparent_header',
							'label' => __('Transparent Header?', 'coiffeur'),
							'description' => __('Turn on use transparent header. Recommended to keep as ON.', 'coiffeur'),
							'default' => '1'
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_logo_color',
							'label' => __('Text Logo Color', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
							'description' => 'Available only when one or both logo image not supplied',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_font_color',
							'label' => __('Font Color', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_font_color_hover',
							'label' => __('Font Color : Hover / Active', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_background_color',
							'label' => __('Background Color', 'coiffeur'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_background_color_hover',
							'label' => __('Background Color : Hover / Active', 'coiffeur'),
							'default' => 'rgba(32,32,32,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_icon_color',
							'label' => __('Icon Color', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_separator_color_2',
							'label' => __('Separator Color', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),

						array(
							'type' => 'toggle',
							'name' => 'ozy_coiffeur_primary_menu_section_colors_enable_alternate',
							'label' => __('Enable Alternate Colors', 'coiffeur'),
							'description' => __('Turn on use different scheme for alternate menu and header layout colors.', 'coiffeur'),
							'default' => '1',
						),


					),
				),


				array(
					'type' => 'section',
					'title' => __('Primary Menu / Alternate', 'coiffeur'),
					'name' => 'ozy_coiffeur_primary_menu_section_colors2',
					'dependency' => array(
						'field' => 'ozy_coiffeur_primary_menu_section_colors_enable_alternate',
						'function' => 'vp_dep_boolean',
					),
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_logo_color_2',
							'label' => __('Text Logo Color', 'coiffeur'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
							'description' => 'Available only when one or both logo image not supplied',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_font_color_2',
							'label' => __('Font Color', 'coiffeur'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_font_color_hover_2',
							'label' => __('Font Color : Hover / Active', 'coiffeur'),
							'default' => 'rgba(243,51,55,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_background_color_2',
							'label' => __('Background Color', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_background_color_hover_2',
							'label' => __('Background Color : Hover / Active', 'coiffeur'),
							'default' => 'rgba(32,32,32,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_icon_color_2',
							'label' => __('Icon Color', 'coiffeur'),
							'default' => 'rgba(32,32,32,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_primary_menu_separator_color_2_2',
							'label' => __('Separator Color', 'coiffeur'),
							'default' => 'rgba(32,32,32,1)',
							'format' => 'rgba',
						),
					),
				),



				array(
					'type' => 'section',
					'title' => __('Footer', 'coiffeur'),
					'name' => 'ozy_coiffeur_footer_section_colors',
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_footer_color_1',
							'label' => __('Background Color', 'coiffeur'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_footer_color_2',
							'label' => __('Foreground Color', 'coiffeur'),
							'default' => '#ffffff',
							'format' => 'hex',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_footer_color_3',
							'label' => __('Alternate Color', 'coiffeur'),
							'default' => '#8c8c8c',
							'format' => 'hex',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_footer_color_4',
							'label' => __('Separator Color', 'coiffeur'),
							'default' => '#3b3b3b',
							'format' => 'hex',
						)
					),
				),



				array(
					'type' => 'section',
					'title' => __('Form', 'coiffeur'),
					'name' => 'ozy_coiffeur_form_section_coloring',
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_form_font_color',
							'label' => __('Font Color', 'coiffeur'),
							'default' => 'rgba(35,35,35,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_form_background_color',
							'label' => __('Background Color', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_form_button_font_color',
							'label' => __('Font Color (Button)', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_form_button_font_color_hover',
							'label' => __('Font Color : Hover / Active (Button)', 'coiffeur'),
							'default' => 'rgba(255,255,255,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_form_button_background_color',
							'label' => __('Background Color (Button)', 'coiffeur'),
							'default' => 'rgba(0,0,0,1)',
							'format' => 'rgba',
						),
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_form_button_background_color_hover',
							'label' => __('Background Color : Hover / Active (Button)', 'coiffeur'),
							'default' => 'rgba(243,51,55,1)',
							'format' => 'rgba',
						),
					),
				),


				array(
					'type' => 'section',
					'title' => __('Background Styling', 'coiffeur'),
					'fields' => array(
						array(
							'type' => 'color',
							'name' => 'ozy_coiffeur_body_background_color',
							'label' => __('Background Color', 'coiffeur'),
							'description' => __('This option will affect only page background.', 'coiffeur'),
							'default' => '#000000',
							'format' => 'hex',
						),
						array(
							'type' => 'upload',
							'name' => 'ozy_coiffeur_body_background_image',
							'label' => __('Custom Background Image', 'coiffeur'),
							'description' => __('Upload or choose custom page background image.', 'coiffeur'),
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_body_background_image_size',
							'label' => __('Background Image Size', 'coiffeur'),
							'description' => __('Only available on browsers which supports CSS3.', 'coiffeur'),
							'items' => array(
								array(
									'value' => '',
									'label' => __('-not set-', 'coiffeur'),
								),
								array(
									'value' => 'cover',
									'label' => __('cover', 'coiffeur'),
								),
								array(
									'value' => 'contain',
									'label' => __('contain', 'coiffeur'),
								)
							),
							'default' => '{{first}}',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_body_background_image_repeat',
							'label' => __('Background Image Repeat', 'coiffeur'),
							'items' => array(
								array(
									'value' => 'inherit',
									'label' => __('inherit', 'coiffeur'),
								),
								array(
									'value' => 'no-repeat',
									'label' => __('no-repeat', 'coiffeur'),
								),
								array(
									'value' => 'repeat',
									'label' => __('repeat', 'coiffeur'),
								),
								array(
									'value' => 'repeat-x',
									'label' => __('repeat-x', 'coiffeur'),
								),
								array(
									'value' => 'repeat-y',
									'label' => __('repeat-y', 'coiffeur'),
								)
							),
							'default' => '{{first}}',
						),
						array(
							'type' => 'radiobutton',
							'name' => 'ozy_coiffeur_body_background_image_attachment',
							'label' => __('Background Image Attachment', 'coiffeur'),
							'items' => array(
								array(
									'value' => '',
									'label' => __('-not set-', 'coiffeur'),
								),
								array(
									'value' => 'fixed',
									'label' => __('fixed', 'coiffeur'),
								),
								array(
									'value' => 'scroll',
									'label' => __('scroll', 'coiffeur'),
								),
								array(
									'value' => 'local',
									'label' => __('local', 'coiffeur')
								)
							),
							'default' => '{{first}}',
						),
					),
				),

			),
		),

		array(
			'title' => __('Social', 'coiffeur'),
			'name' => 'ozy_coiffeur_typography',
			'icon' => 'font-awesome:fa-group',
			'menus' => array(
				array(
					'title' => __('Accounts', 'coiffeur'),
					'name' => 'ozy_coiffeur_social_accounts',
					'icon' => 'font-awesome:fa-heart-o',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => __('Social Accounts', 'coiffeur'),
							'description' => __('Enter social account names/IDs box below', 'coiffeur'),
							'fields' => array(
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_fivehundredpx',
									'label' => __('500px', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_behance',
									'label' => __('Behance', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_blogger',
									'label' => __('Blogger', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_delicious',
									'label' => __('Delicious', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_deviantart',
									'label' => __('DeviantArt', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_digg',
									'label' => __('Digg', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_dribble',
									'label' => __('Dribble', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_email',
									'label' => __('Email', 'coiffeur'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_facebook',
									'label' => __('Facebook', 'coiffeur'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_flickr',
									'label' => __('Flickr', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_forrst',
									'label' => __('Forrst', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_foursquare',
									'label' => __('Foursquare', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_github',
									'label' => __('Github', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_googleplus',
									'label' => __('Google+', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_instagram',
									'label' => __('Instagram', 'coiffeur'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_lastfm',
									'label' => __('Last.FM', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_linkedin',
									'label' => __('LinkedIn', 'coiffeur')
								),

								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_myspace',
									'label' => __('MySpace', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_pinterest',
									'label' => __('Pinterest', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_rss',
									'label' => __('RSS', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_soundcloud',
									'label' => __('SoundCloud', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_stumbleupon',
									'label' => __('StumbleUpon', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_tumblr',
									'label' => __('Tumblr', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_twitter',
									'label' => __('Twitter', 'coiffeur'),
									'default' => '#'
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_vimeo',
									'label' => __('Vimeo', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_wordpress',
									'label' => __('WordPress', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_yahoo',
									'label' => __('Yahoo!', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_yelp',
									'label' => __('Yelp (Please use full URL)', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_youtube',
									'label' => __('YouTube', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_vk',
									'label' => __('VK', 'coiffeur')
								),
								array(
									'type' => 'textbox',
									'name' => 'ozy_coiffeur_social_accounts_snapchat',
									'label' => __('Snapchat (enter full URL)', 'coiffeur')
								),								
							),
						),
					),
				),
				array(
					'title' => __('General', 'coiffeur'),
					'name' => 'ozy_coiffeur_social_general',
					'icon' => 'font-awesome:fa-group',
					'controls' => array(
						array(
							'type' => 'section',
							'title' => __('Social Icons', 'coiffeur'),
							'fields' => array(
								array(
									'type' => 'toggle',
									'name' => 'ozy_coiffeur_social_use',
									'label' => __('Social Share Buttons', 'coiffeur'),
									'description' => __('Enable / Disable social share buttons.', 'coiffeur'),
									'default' => '1',
								),
								array(
									'type' => 'sorter',
									'name' => 'ozy_coiffeur_social_icon_order',
									'max_selection' => 20,
									'label' => __('Icon List / Order', 'coiffeur'),
									'description' => __('Select visible icons and sort.', 'coiffeur'),
									'items' => array(
										'data' => array(
											array(
												'source' => 'function',
												'value' => 'vp_get_social_medias',
											),
										),
									),
									'default' => array('email', 'facebook', 'instagram', 'twitter')
								),
								array(
									'type' => 'select',
									'name' => 'ozy_coiffeur_social_icon_target',
									'label' => __('Target Window', 'coiffeur'),
									'description' => __('Where links will be opened?', 'coiffeur'),
									'items' => array(
										array(
											'value' => '_blank',
											'label' => __('Blank Window / New Tab', 'coiffeur'),
										),
										array(
											'value' => '_self',
											'label' => __('Self Window', 'coiffeur'),
										),
									),
									'default' => array(
										'_blank',
									),
								),
							),
						),
					),
				),
			),
		),
	)
);

return $ozy_coiffeur_option_arr;

/**
 *EOF
 */
