<?php
/**
* Constants
*/
define( 'OZY_BASE_DIR', get_template_directory() . '/' );
define( 'OZY_BASE_URL', get_template_directory_uri() . '/' );
define( 'OZY_CSS_DIRECTORY_URL', get_stylesheet_directory_uri() . '/');
define( 'OZY_THEME_VERSION', '8.0' );
define( 'OZY_THEMENAME', 'COIFFEUR' ); //used in TGM Plugin Activation

/**
* Globals
*/
$ozy_data = new stdClass();

locate_template('functions/classes/helper.php', true, true);

global $ozyHelper,
	$ozy_temporary_post_title,
	$ozy_temporary_post_format,
	$ozy_global_params;

$ozyHelper = new myHelper;

/**
* WPML Plugin Check
*/
if(class_exists('SitePress') && function_exists("icl_get_languages") && defined("ICL_LANGUAGE_CODE") && defined('ICL_LANGUAGE_NAME') && function_exists('icl_object_id')){
	global $sitepress;
	define( 'OZY_WPLANG', $sitepress->get_default_language());
	define( 'OZY_HOME_URL', esc_url(apply_filters( 'wpml_home_url', get_option( 'home' ) ) . '/') );
}else if(function_exists('pll_default_language') && function_exists('pll_home_url')){
	define( 'OZY_WPLANG', pll_default_language());
	define( 'OZY_HOME_URL', esc_url( pll_home_url() . '/' ) );
}else{
	define( 'OZY_WPLANG', substr(get_locale(), 0, 2));
	define( 'OZY_HOME_URL', esc_url(home_url('/') . '/') );
}

$ozy_data->wpml_current_language_	= '';

if(defined("ICL_LANGUAGE_CODE") && ICL_LANGUAGE_CODE != OZY_WPLANG) {
	$ozy_data->wpml_current_language_ = '_' . ICL_LANGUAGE_CODE;
}

/**
* Sets up theme defaults and registers support for various WordPress features.
*/
add_action('after_setup_theme', 'ozy_theme_setup');
function ozy_theme_setup() {
	// Load Languages
	load_theme_textdomain('coiffeur', get_template_directory() . '/lang/');

	// Adds Post Format support
	// learn more: http://codex.wordpress.org/Post_Formats
	add_theme_support( 'post-formats', array(
		'aside',
		'gallery',
		'link',
		'image',
		'quote',
		'status',
		'video',
		'audio',
		'chat' )
	);

	// Declare Automatic Feed Links support
	add_theme_support( 'automatic-feed-links' );

	// Declare WooCommerce support
	add_theme_support( 'woocommerce' );
	add_theme_support( 'wc-product-gallery-zoom' );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );

	// Post thumbnail support
	add_theme_support( 'post-thumbnails' );

	// Custom menu support
	if ( function_exists( 'register_nav_menus' ) ) {
		register_nav_menus(
			array(
			  'header-menu' => 'Primary Menu',
			  'logged-in-menu' => 'Logged In Primary Menu'
			)
		);
	}

	// Add custom thumbnail sizes
	if ( function_exists( 'add_image_size' ) ) {
		add_image_size( 'boxyboxy', 480, 480, true );
		add_image_size( 'showbiz', 720, 720, true ); /*466x466 older version*/
		add_image_size( 'blog', 1144, 9999, false );
	}

	// Enable shortcodes in the widgets
	add_filter('widget_text', 'shortcode_unautop');
	add_filter('widget_text', 'do_shortcode');

	// Removes detailed login error information for security
	add_filter('login_errors', function($a) { return null; });

	// WordPress 4.1+ title tag support
	add_theme_support("title-tag");

	// Default media sizes
	global $content_width;
	if (!isset($content_width)) $content_width = 1140;
	
	// Opting out of the block-based widgets editor WP 5.8+
	remove_theme_support( 'widgets-block-editor' );	
}

/**
* Include Custom Post Types
* Currently using to add Sidebars post type
*/
require_once 'functions/custom-post-types.php';

/**
* TGM & Plugins
*/
require_once 'functions/extender.php';

/**
* Include Vafpress Framework
*/
require_once 'framework/bootstrap.php';

/**
* Include Custom Data Sources
*/
require_once 'admin/data_sources.php';

/**
* Mobile Check Class
*/
require_once 'functions/classes/mobile-check.php';

/**
* Theme options initializing here
*/
$tmpl_opt = OZY_BASE_DIR . 'admin/option/option.php';

/**
* Main functions / actions / hooks
*/
include_once('functions/functions.php');

/**
* Include Dynamic Sidebars
*/
require_once 'functions/sidebars.php';

/**
* Dashboard motification class
*/
include_once('functions/classes/class-freevision-dashboard-notifications.php');

/**
* Create instance of Theme Options
*/
$theme_options = new VP_Option(array(
	'is_dev_mode' 			=> false, // dev mode, default to false
	'option_key' 			=> 'vpt_ozy_coiffeur_option', // options key in db, required
	'page_slug' 			=> 'vpt_option', // options page slug, required
	'template' 				=> $tmpl_opt, // template file path or array, required
	'menu_page' 			=> 'themes.php', // parent menu slug or supply `array` (can contains 'icon_url' & 'position') for top level menu
	'use_auto_group_naming' => true, // default to true
	'use_exim_menu' 		=> true, // default to true, shows export import menu
	'minimum_role' 			=> 'edit_theme_options', // default to 'edit_theme_options'
	'layout' 				=> 'fixed', // fluid or fixed, default to fixed
	'page_title' 			=> __( 'Theme Options', 'coiffeur' ), // page title
	'menu_label' 			=> __( 'Theme Options', 'coiffeur' ), // menu label
));

/**
* Load option based css
*/
locate_template('functions/option-based-css.php', true, true);

/**
* Custom Menu Items
*/
if(defined('OZY_COIFFEUR_ESSENTIALS_ACTIVATED')) {
	require_once 'functions/menu-item-custom-fields/menu-item-custom-fields.php';
	require_once 'functions/menu-item-custom-fields/menu-item-custom-fields-megamenu.php';
}

/**
* Visual Composer Add-On visual shortcodes
*/
global $ozy_data;
$ozy_data->vc_active = false;

//if(function_exists('wpb_js_composer_check_version_schedule_deactivation')) { wpb_js_composer_check_version_schedule_deactivation(); }

function ozy_init_vc_shortcodes() {
	if(function_exists('vc_map') &&
		function_exists('vc_set_as_theme')) {

		/* Make visual composer part of the theme */
		vc_set_as_theme();

		//Remove frontend editor
		if(function_exists('vc_disable_frontend')){vc_disable_frontend();}

		global $ozy_data;
		include_once('functions/vc_extend.php');

		$ozy_data->vc_active = true;
	}
}
add_action( 'init', 'ozy_init_vc_shortcodes', 99 );

/**
* Disabling the auto-update feature Master Slider
*/
add_filter( 'masterslider_disable_auto_update', '__return_true' );

/**
* Customize Tag Cloud widget
*/
function ozy_tag_cloud_fix($tag_string){
   return preg_replace("/style='font-size:.+pt;'/", '', $tag_string);
}
add_filter('wp_generate_tag_cloud', 'ozy_tag_cloud_fix',10,3);

function ozy_get_default_language_code() {
	$lang_code = get_bloginfo("language");
	if(strpos($lang_code, '-')) {
		$lang_code = explode('-', $lang_code);
		return $lang_code[0];
	}
	return $lang_code;
}

function ozy_is_wpml_active() {
	if(function_exists("icl_get_languages") && defined("ICL_LANGUAGE_CODE") && defined("ICL_LANGUAGE_NAME")) {
		return true;
	}
	return false;
}

function ozy_is_date_between($dt_start, $dt_check, $dt_end) {
    if(strtotime($dt_check) >= strtotime($dt_start) && strtotime($dt_check) <= strtotime($dt_end)) {
        return true;
	}
    return false;
}
