<?php

include_once('classes/tgm-plugin-activation.php');

/**
* TGM Plugin activator
*/
function coiffeur_register_required_plugins() {
	$ext_plugin_path = coiffeur_settings(); if($ext_plugin_path == false) return;

	$plugins = array(
		array(
			'name'     	=> 'WPBakery Page Builder',
			'slug'     	=> 'js_composer',
			'source'   	=> $ext_plugin_path . 'js_composer.zip',
			'required' 	=> true,
			'force_deactivation' => true,
			'version'	=> '8.6.1'
		),array(
			'name'     	=> 'Coiffeur Essentials',
			'slug'     	=> 'ozy-coiffeur-essentials',
			'source'   	=> $ext_plugin_path . 'ozy-coiffeur-essentials.zip',
			'required' 	=> true,
			'force_deactivation' => true,
			'version'	=> '3.3'
		),array(
			'name'     	=> 'Classic Editor',
			'slug'     	=> 'classic-editor',
			'required' 	=> true,
			'force_deactivation' => false,
			//'version'	=> '1.6.3'
		),array(
			'name'     	=> 'Essential Grid',
			'slug'     	=> 'essential-grid',
			'source'   	=> $ext_plugin_path . 'essential-grid.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '3.1.9.3'
		),array(
			'name'     	=> 'Master Slider',
			'slug'     	=> 'masterslider',
			'source'   	=> $ext_plugin_path . 'masterslider.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '3.7.8'
		),array(
			'name'     	=> 'WooCommerce',
			'slug'     	=> 'woocommerce',
			'required' 	=> false,
			'force_deactivation' => false,
			//'version'	=> '8.1.0'
		),array(
			'name'     	=> 'Envato Market',
			'slug'     	=> 'envato-market',
			//'source'   	=> $ext_plugin_path . 'envato-market.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			//'version'	=> '2.0.8'
		),array(
			'name'     	=> 'Contact Form 7',
			'slug'     	=> 'contact-form-7',
			'required' 	=> false,
			'force_deactivation' => true,
			//'version'	=> '5.8.2'
		),array(
			'name'     	=> 'Mailchimp Widget',
			'slug'     	=> 'mailchimp-widget',
			'source'   	=> $ext_plugin_path . 'mailchimp-widget.zip',
			'required' 	=> false,
			'force_deactivation' => true,
			'version'	=> '2.1.1'
		)
	);

	$config = array(
		'domain'       		=> 'coiffeur',         			// Text domain - likely want to be the same as your theme.
		'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
		'menu'         		=> 'install-required-plugins', 	// Menu slug
		'has_notices'      	=> true,                       	// Show admin notices or not
		'is_automatic'    	=> false,					   	// Automatically activate plugins after installation or not
		'message' 			=> '',							// Message to output right before the plugins table
		'strings'      		=> array(
			'page_title'                       	=> __( 'Install Required Plugins', 'coiffeur' ),
			'menu_title'                       	=> __( 'Install Plugins', 'coiffeur' ),
			'installing'                       	=> __( 'Installing Plugin: %s', 'coiffeur' ), // %1$s = plugin name
			'oops'                             	=> __( 'Something went wrong with the plugin API.', 'coiffeur' ),
			'notice_can_install_required'     	=> _n_noop( '<span class="required-plugin-line">This theme requires the following plugin for the perfect results:</span> %1$s.', 'This theme requires the following plugins: %1$s.', 'coiffeur' ), // %1$s = plugin name(s)
			'notice_can_install_recommended'	=> _n_noop( 'This theme recommends the following plugin for the perfect results: %1$s.', 'This theme recommends the following plugins for the perfect results: %1$s.', 'coiffeur' ), // %1$s = plugin name(s)
			'notice_cannot_install'  			=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'coiffeur' ), // %1$s = plugin name(s)
			'notice_can_activate_required'    	=> _n_noop( '<span class="required-plugin-line">The following required plugin is currently inactive:</span> %1$s.', 'The following required plugins are currently inactive: %1$s.', 'coiffeur' ), // %1$s = plugin name(s)
			'notice_can_activate_recommended'	=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'coiffeur' ), // %1$s = plugin name(s)
			'notice_cannot_activate' 			=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'coiffeur' ), // %1$s = plugin name(s)
			'notice_ask_to_update' 				=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'coiffeur' ), // %1$s = plugin name(s)
			'notice_cannot_update' 				=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'coiffeur' ), // %1$s = plugin name(s)
			'install_link' 					  	=> _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'coiffeur' ),
			'activate_link' 				  	=> _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'coiffeur' ),
			'return'                           	=> __( 'Return to Required Plugins Installer', 'coiffeur' ),
			'plugin_activated'                 	=> __( 'Plugin activated successfully.', 'coiffeur' ),
			'complete' 							=> __( 'All plugins installed and activated successfully. %s', 'coiffeur' ), // %1$s = dashboard link
			'nag_type'							=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
		)
	);

	tgmpa( $plugins, $config );

}

add_action('tgmpa_register', 'coiffeur_register_required_plugins');

?>
