<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => esc_html__( 'General', 'minimog' ),
	'id'         => 'header_general',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'     => 'header_general_settings',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'General', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'global_header',
			'type'    => 'select',
			'title'   => esc_html__( 'Global Header Style', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'global_header' ),
			'options' => Minimog_Header::instance()->get_list(),
		),
		array(
			'id'      => 'global_header_overlay',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Global Header Overlay', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'No', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'global_header_overlay' ),
		),
		array(
			'id'      => 'global_header_skin',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Global Header Skin', 'minimog' ),
			'options' => array(
				'dark'  => esc_html__( 'Dark', 'minimog' ),
				'light' => esc_html__( 'Light', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'global_header_skin' ),
		),
		array(
			'id'      => 'header_text',
			'type'    => 'textarea',
			'title'   => esc_html__( 'Text', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'header_text' ),
		),
		array(
			'id'      => 'header_info_list_secondary_style',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Info List Style (Secondary)', 'minimog' ),
			'options' => array(
				''   => sprintf( __( 'Style %s', 'minimog' ), '01' ),
				'02' => sprintf( __( 'Style %s', 'minimog' ), '02' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'header_info_list_secondary_style' ),
		),
		array(
			'id'           => 'header_info_list_secondary',
			'type'         => 'repeater',
			'title'        => esc_html__( 'Info List (Secondary)', 'minimog' ),
			'item_name'    => esc_html__( 'Item', 'minimog' ),
			'bind_title'   => 'text',
			'group_values' => true,
			'fields'       => array(
				array(
					'id'    => 'text',
					'type'  => 'textarea',
					'title' => esc_html__( 'Title', 'minimog' ),
				),
				array(
					'id'    => 'sub_title',
					'type'  => 'text',
					'title' => esc_html__( 'Sub title', 'minimog' ),
				),
				array(
					'id'    => 'url',
					'type'  => 'text',
					'title' => esc_html__( 'Link Url', 'minimog' ),
				),
				array(
					'id'          => 'icon_class',
					'title'       => esc_html__( 'Icon CSS class', 'minimog' ),
					'description' => 'Input valid font-icon CSS classes. Leave it blank if to use below image/svg below.',
					'type'        => 'text',
				),
				array(
					'id'          => 'icon',
					'title'       => 'Icon',
					'type'        => 'media',
					'description' => 'Select an image or a svg file.',
					'compiler'    => 'true',
					'mode'        => false,
				),
				array(
					'id'          => 'item_class',
					'title'       => esc_html__( 'Item CSS class', 'minimog' ),
					'description' => 'Add custom CSS class to the item',
					'type'        => 'text',
				),
			),
			'default'      => [
				'Redux_repeater_data' => [
					[
						'title' => '',
					],
				],
				'text'                => [
					'Find a Store',
				],
				'sub_title'           => [
					'',
				],
				'url'                 => [
					'#',
				],
				'icon_class'          => [
					'fas fa-map-marker-alt',
				],
				'icon'                => [
					[
						'id'  => '',
						'url' => '',
					],
				],
				'item_class'          => [
					'',
				],
			],
		),
		array(
			'id'    => 'header_button_text',
			'type'  => 'text',
			'title' => esc_html__( 'Button Text', 'minimog' ),
		),
		array(
			'id'    => 'header_button_link',
			'type'  => 'text',
			'title' => esc_html__( 'Button Link', 'minimog' ),
		),
		array(
			'id'    => 'header_button_link_rel',
			'type'  => 'text',
			'title' => esc_html__( 'Button Link Relationship (XFN)', 'minimog' ),
		),
		array(
			'id'      => 'header_button_link_target',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Open link in a new tab.', 'minimog' ),
			'options' => [
				'0' => esc_html__( 'No', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_button_link_target' ),
		),
		array(
			'id'      => 'header_button_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Button Style', 'minimog' ),
			'options' => Minimog_Header::instance()->get_button_style(),
			'default' => Minimog_Redux::get_default_setting( 'header_button_style' ),
		),
		array(
			'id'             => 'header_height',
			'type'           => 'dimensions',
			'units'          => array( 'px', ),
			'units_extended' => false,
			'title'          => esc_html__( 'Header Min Height', 'minimog' ),
			'subtitle'       => esc_html__( 'Control min height of header in desktop device.', 'minimog' ),
			'width'          => false,
		),
		array(
			'id'                => 'header_style_navigation_typography',
			'type'              => 'typography',
			'title'             => esc_html__( 'Navigation Typography', 'minimog' ),
			'google'            => true,
			'font_family_clear' => true,
			'default'           => Minimog_Redux::get_default_setting( 'header_style_navigation_typography' ),
			'letter-spacing'    => true,
			'text-transform'    => true,
			'text-align'        => false,
			'preview'           => false,
			'color'             => false,
		),
		array(
			'id'      => 'header_icons_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Icon Style', 'minimog' ),
			'options' => [
				'text'        => esc_html__( 'Text', 'minimog' ),
				'icon-set-01' => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '01' ),
				'icon-set-02' => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '02' ),
				'icon-set-03' => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '03' ),
				'icon-set-04' => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '04' ),
				'icon-set-05' => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '05' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_icons_style' ),
		),
		array(
			'id'      => 'header_icons_display',
			'type'    => 'button_set',
			'title'   => 'Icon Display',
			'options' => array(
				'icon' => 'Icon',
				'text' => 'Text on desktop',
			),
			'default' => Minimog_Redux::get_default_setting( 'header_icons_display' ),
		),
		array(
			'id'      => 'header_cart_icon_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Mini Cart Icon', 'minimog' ),
			'options' => [
				'text'                 => esc_html__( 'Text', 'minimog' ),
				'icon-set-01'          => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '01' ),
				'icon-set-02'          => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '02' ),
				'icon-set-03'          => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '03' ),
				'icon-set-04'          => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '04' ),
				'icon-set-05'          => sprintf( esc_html__( 'Icon set %s', 'minimog' ), '05' ),
				'icon-circle-price-01' => esc_html__( 'Icon Circle - Price - 01', 'minimog' ),
				'icon-circle-price-02' => esc_html__( 'Icon Circle - Price - 02', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_cart_icon_style' ),
		),
		array(
			'id'      => 'header_cart_icon_display',
			'type'    => 'button_set',
			'title'   => 'Mini Cart Icon Display',
			'options' => array(
				'icon' => 'Icon',
				'text' => 'Text on desktop',
			),
			'default' => Minimog_Redux::get_default_setting( 'header_cart_icon_display' ),
		),
		array(
			'id'      => 'header_wishlist_icon_type',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Wishlist Icon', 'minimog' ),
			'options' => [
				'star'  => esc_html__( 'Star', 'minimog' ),
				'heart' => esc_html__( 'Heart', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_wishlist_icon_type' ),
		),
		array(
			'id'      => 'header_icons_badge_size',
			'type'    => 'select',
			'title'   => esc_html__( 'Icon Badge Size', 'minimog' ),
			'options' => [
				'normal' => esc_html__( 'Normal', 'minimog' ),
				'large'  => esc_html__( 'Large', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_icons_badge_size' ),
		),
		array(
			'id'      => 'header_navigation_item_hover_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Nav Item Hover Style', 'minimog' ),
			'options' => [
				''          => esc_html__( 'None', 'minimog' ),
				'thin-line' => esc_html__( 'Thin Underline', 'minimog' ),
				'line'      => esc_html__( 'Thick Underline', 'minimog' ),
				'wave'      => esc_html__( 'Wave', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_navigation_item_hover_style' ),
		),
		array(
			'id'      => 'header_search_form_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Search Form Style', 'minimog' ),
			'options' => [
				'normal'                 => esc_html__( 'Default', 'minimog' ),
				'button-fill'            => esc_html__( 'Submit Button Fill', 'minimog' ),
				'thick-bottom-line'      => esc_html__( 'Thick Bottom Line', 'minimog' ),
				'thick-border'           => esc_html__( 'Thick Border', 'minimog' ),
				'thick-border-with-text' => esc_html__( 'Thick Border With Text', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'header_search_form_style' ),
		),

		array(
			'id'     => 'section_start_header_dark_skin',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Header Dark Version', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'header_style_dark_background',
			'title'   => esc_html__( 'Background', 'minimog' ),
			'type'    => 'background',
			'default' => array(
				'background-color' => '#fff',
			),
		),
		array(
			'id'       => 'header_style_dark_box_shadow',
			'type'     => 'box_shadow',
			'title'    => esc_html__( 'Box Shadow', 'minimog' ),
			'subtitle' => esc_html__( 'Input box shadow for header', 'minimog' ),
			'class'    => 'field-header-shadow',
			'default'  => [
				'inset'        => false,
				'drop'         => true,
				'inset-shadow' => array(
					'checked'    => false,
					'color'      => '#ABABAB',
					'horizontal' => 0,
					'vertical'   => 0,
					'blur'       => 10,
					'spread'     => 0,
				),
				'drop-shadow'  => array(
					'checked'    => false,
					'color'      => 'rgba(0, 0, 0, 0.03)',
					'horizontal' => 0,
					'vertical'   => 4,
					'blur'       => 4,
					'spread'     => 0,
				),
			],
		),
		array(
			'id'          => 'header_style_dark_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_link_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_link_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_nav_link_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Nav Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_nav_link_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Nav Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_nav_line_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Nav Line Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_icon_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Icon Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_icon_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Icon Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_icon_badge_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Icon Badge Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_icon_badge_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Icon Badge Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_tag_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Tag Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_tag_bg_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Tag Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_form_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Form Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_form_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Form Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_form_border_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Form Border Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_dark_form_submit_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Form Submit Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'    => 'header_above_style_dark_background',
			'title' => esc_html__( 'Header Above Background', 'minimog' ),
			'type'  => 'background',
		),
		array(
			'id'          => 'header_above_style_dark_border_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Header Above Border Bottom Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_above_style_dark_item_separator_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Header Above Item Separator Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_above_style_dark_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Header Above Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_above_style_dark_link_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Header Above Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_above_style_dark_link_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Header Above Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'    => 'header_below_style_dark_border',
			'type'  => 'border',
			'title' => esc_html__( 'Header Below Border', 'minimog' ),
		),
		array(
			'id'    => 'header_below_style_dark_inner_border',
			'type'  => 'border',
			'title' => esc_html__( 'Header Below Inner Border', 'minimog' ),
		),

		// Light Version.
		array(
			'id'     => 'section_start_header_01_light_skin',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Header Light Version', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'    => 'header_style_light_background',
			'title' => esc_html__( 'Background', 'minimog' ),
			'type'  => 'background',
		),
		array(
			'id'       => 'header_style_light_box_shadow',
			'type'     => 'box_shadow',
			'title'    => esc_html__( 'Box Shadow', 'minimog' ),
			'subtitle' => esc_html__( 'Input box shadow for header', 'minimog' ),
			'class'    => 'field-header-shadow',
			'default'  => [
				'inset'        => false,
				'drop'         => false,
				'inset-shadow' => array(
					'checked'    => false,
					'color'      => '#ABABAB',
					'horizontal' => 0,
					'vertical'   => 0,
					'blur'       => 10,
					'spread'     => 0,
				),
				'drop-shadow'  => array(
					'checked'    => false,
					'color'      => 'rgba(0, 0, 0, 0.03)',
					'horizontal' => 0,
					'vertical'   => 4,
					'blur'       => 4,
					'spread'     => 0,
				),
			],
		),
		array(
			'id'          => 'header_style_light_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_link_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_link_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_nav_link_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Nav Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_nav_link_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Nav Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_nav_line_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Nav Line Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_icon_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Icon Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_icon_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Icon Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_icon_badge_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Icon Badge Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_icon_badge_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Icon Badge Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_tag_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Tag Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_tag_bg_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Tag Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_form_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Form Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_form_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Form Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_form_border_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Form Border Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_form_submit_text_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Form Submit Text Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'    => 'header_below_style_light_border',
			'type'  => 'border',
			'title' => esc_html__( 'Header Below Border', 'minimog' ),
		),
		array(
			'id'    => 'header_below_style_light_inner_border',
			'type'  => 'border',
			'title' => esc_html__( 'Header Below Inner Border', 'minimog' ),
		),
	),
) );
