<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'  => esc_html__( 'Sidebars', 'minimog' ),
	'id'     => 'panel_sidebars',
	'icon'   => 'eicon-sidebar',
	'fields' => array(
		array(
			'id'    => 'sidebar_instruction',
			'type'  => 'info',
			'style' => 'info',
			'title' => esc_html__( 'IMPORTANT NOTE: ', 'minimog' ),
			'desc'  => sprintf( '<div class="desc">%s<br/>%s</div>',
				esc_html__( 'Sidebar 2 can only be used if sidebar 1 is selected.', 'minimog' ),
				esc_html__( 'Sidebar position option will control the position of sidebar 1. If sidebar 2 is selected, it will display on the opposite side.', 'minimog' )
			),
		),
		array(
			'id'          => 'sidebars_below_content_mobile',
			'type'        => 'button_set',
			'title'       => esc_html__( 'Sidebars Below Content', 'minimog' ),
			'description' => esc_html__( 'Move sidebars display after main content on smaller screens.', 'minimog' ),
			'options'     => array(
				'0' => esc_html__( 'No', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'sidebars_below_content_mobile' ),
		),
		array(
			'id'             => 'single_sidebar_width',
			'type'           => 'dimensions',
			'units'          => array( '%' ),
			'units_extended' => 'false',
			'title'          => esc_html__( 'Single Sidebar Width', 'minimog' ),
			'description'    => esc_html__( 'Controls the width of the sidebar when only one sidebar is present.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'single_sidebar_width' ),
		),
		array(
			'id'             => 'single_sidebar_offset',
			'type'           => 'dimensions',
			'units'          => array( 'px' ),
			'units_extended' => 'false',
			'title'          => esc_html__( 'Single Sidebar Offset', 'minimog' ),
			'description'    => esc_html__( 'Controls the offset of the sidebar when only one sidebar is present.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'single_sidebar_offset' ),
		),
		array(
			'id'             => 'dual_sidebar_width',
			'type'           => 'dimensions',
			'units'          => array( '%' ),
			'units_extended' => 'false',
			'title'          => esc_html__( 'Dual Sidebar Width', 'minimog' ),
			'description'    => esc_html__( 'Controls the width of sidebars when dual sidebars are present.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'dual_sidebar_width' ),
		),
		array(
			'id'             => 'dual_sidebar_offset',
			'type'           => 'dimensions',
			'units'          => array( 'px' ),
			'units_extended' => 'false',
			'title'          => esc_html__( 'Dual Sidebar Offset', 'minimog' ),
			'description'    => esc_html__( 'Controls the offset of sidebars when dual sidebars are present.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'dual_sidebar_offset' ),
		),
	),
) );
