<?php
$sidebar_positions   = Minimog_Helper::get_list_sidebar_positions();
$registered_sidebars = Minimog_Redux::instance()->get_registered_widgets_options();

Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => esc_html__( 'Single Product', 'minimog' ),
	'id'         => 'single_product',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'     => 'section_start_single_product_header',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Header Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'product_single_header_type',
			'type'        => 'select',
			'title'       => esc_html__( 'Header Style', 'minimog' ),
			'placeholder' => esc_html__( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_list( true ),
		),
		array(
			'id'          => 'product_single_header_overlay',
			'type'        => 'select',
			'title'       => esc_html__( 'Header Overlay', 'minimog' ),
			'placeholder' => esc_html__( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_overlay_list(),
		),
		array(
			'id'          => 'product_single_header_skin',
			'type'        => 'select',
			'title'       => esc_html__( 'Header Skin', 'minimog' ),
			'placeholder' => esc_html__( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Header::instance()->get_skin_list(),
		),
		array(
			'id'     => 'section_start_product_single_title_bar',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Title Bar Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'product_single_title_bar_layout',
			'type'        => 'select',
			'title'       => esc_html__( 'Title Bar Style', 'minimog' ),
			'placeholder' => esc_html__( 'Use Global Setting', 'minimog' ),
			'options'     => Minimog_Title_Bar::instance()->get_list( true ),
			'default'     => Minimog_Redux::get_default_setting( 'product_single_title_bar_layout' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'product_single_title_bar_title',
			'title'       => esc_html__( 'Heading Text', 'minimog' ),
			'description' => esc_html__( 'Leave blank to use post title.', 'minimog' ),
		),
		array(
			'id'     => 'section_start_product_single_sidebar',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Sidebar Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'product_page_sidebar_1',
			'type'    => 'select',
			'title'   => esc_html__( 'Sidebar 1', 'minimog' ),
			'options' => $registered_sidebars,
			'default' => Minimog_Redux::get_default_setting( 'product_page_sidebar_1' ),
		),
		array(
			'id'      => 'product_page_sidebar_2',
			'type'    => 'select',
			'title'   => esc_html__( 'Sidebar 2', 'minimog' ),
			'options' => $registered_sidebars,
			'default' => Minimog_Redux::get_default_setting( 'product_page_sidebar_2' ),
		),
		array(
			'id'      => 'product_page_sidebar_position',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Sidebar Position', 'minimog' ),
			'options' => $sidebar_positions,
			'default' => Minimog_Redux::get_default_setting( 'product_page_sidebar_position' ),
		),
		array(
			'id'             => 'product_page_single_sidebar_width',
			'type'           => 'dimensions',
			'units'          => array( '%' ),
			'units_extended' => 'false',
			'title'          => esc_html__( 'Single Sidebar Width', 'minimog' ),
			'description'    => esc_html__( 'Controls the width of the sidebar when only one sidebar is present. Leave blank to use global setting.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'product_page_single_sidebar_width' ),
		),
		array(
			'id'             => 'product_page_single_sidebar_offset',
			'type'           => 'dimensions',
			'units'          => array( 'px' ),
			'units_extended' => 'false',
			'title'          => esc_html__( 'Single Sidebar Offset', 'minimog' ),
			'description'    => esc_html__( 'Controls the offset of the sidebar when only one sidebar is present. Leave blank to use global setting.', 'minimog' ),
			'height'         => false,
			'default'        => Minimog_Redux::get_default_setting( 'product_page_single_sidebar_offset' ),
		),
		array(
			'id'      => 'product_page_sidebar_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Sidebar Style', 'minimog' ),
			'options' => Minimog_Sidebar::instance()->get_supported_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'product_page_sidebar_style' ),
		),
		array(
			'id'     => 'section_start_product_single_layout',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Layout Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'single_product_site_layout',
			'type'    => 'select',
			'title'   => esc_html__( 'Site Layout', 'minimog' ),
			'options' => Minimog_Site_Layout::instance()->get_container_wide_list(),
			'default' => Minimog_Redux::get_default_setting( 'single_product_site_layout' ),
		),
		array(
			'id'      => 'single_product_summary_layout',
			'type'    => 'select',
			'title'   => esc_html__( 'Product Summary Layout', 'minimog' ),
			'options' => Minimog_Site_Layout::instance()->get_container_wide_list(),
			'default' => Minimog_Redux::get_default_setting( 'single_product_summary_layout' ),
		),
		array(
			'id'      => 'single_product_images_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Product Images Style', 'minimog' ),
			'options' => [
				'slider'   => esc_html__( 'Slider', 'minimog' ),
				'carousel' => esc_html__( 'Carousel', 'minimog' ),
				'grid'     => esc_html__( 'Grid', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_images_style' ),
		),
		array(
			'id'       => 'single_product_slider_vertical',
			'type'     => 'button_set',
			'title'    => esc_html__( 'Vertical Slider', 'minimog' ),
			'options'  => array(
				'0' => esc_html__( 'Horizontal', 'minimog' ),
				'1' => esc_html__( 'Vertical', 'minimog' ),
			),
			'default'  => Minimog_Redux::get_default_setting( 'single_product_slider_vertical' ),
			'required' => array(
				[ 'single_product_images_style', '=', 'slider' ],
			),
		),
		array(
			'id'       => 'single_product_slider_thumbnails_mobile_disable',
			'type'     => 'button_set',
			'title'    => esc_html__( 'Disable Slider Thumbnails On Mobile', 'minimog' ),
			'options'  => array(
				'0' => esc_html__( 'No', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			),
			'default'  => Minimog_Redux::get_default_setting( 'single_product_slider_thumbnails_mobile_disable' ),
			'required' => array(
				[ 'single_product_images_style', '=', 'slider' ],
			),
		),
		array(
			'id'       => 'single_product_image_grid_to_slider_on_mobile',
			'type'     => 'button_set',
			'title'    => esc_html__( 'Grid to Slider On Mobile', 'minimog' ),
			'options'  => array(
				'0' => esc_html__( 'No', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			),
			'default'  => Minimog_Redux::get_default_setting( 'single_product_image_grid_to_slider_on_mobile' ),
			'required' => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'          => 'single_product_image_grid_alternating',
			'type'        => 'select',
			'title'       => esc_html__( 'Grid Alternating?', 'minimog' ),
			'description' => esc_html__( 'Even rows has more or less than odd rows 1 column', 'minimog' ),
			'options'     => [
				'0'  => esc_attr__( 'Disabled', 'minimog' ),
				'1'  => esc_attr__( 'Normal Alternating', 'minimog' ),
				'-1' => esc_attr__( 'Reverse Alternating', 'minimog' ),
			],
			'default'     => Minimog_Redux::get_default_setting( 'single_product_image_grid_alternating' ),
			'required'    => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_lg_columns',
			'title'         => esc_html__( 'Grid Columns', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_lg_columns' ),
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_lg_gutter',
			'title'         => esc_html__( 'Grid Gutter', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_lg_gutter' ),
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_md_columns',
			'title'         => esc_html__( 'Grid Columns (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_md_columns' ),
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_md_gutter',
			'title'         => esc_html__( 'Grid Gutter (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_md_gutter' ),
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_sm_columns',
			'title'         => esc_html__( 'Grid Columns (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_sm_columns' ),
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'            => 'single_product_image_grid_sm_gutter',
			'title'         => esc_html__( 'Grid Gutter (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'single_product_image_grid_sm_gutter' ),
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_images_style', '=', 'grid' ],
			),
		),
		array(
			'id'      => 'single_product_images_wide',
			'type'    => 'select',
			'title'   => esc_html__( 'Product Images Wide', 'minimog' ),
			'options' => [
				'narrow'   => esc_html__( 'Narrow', 'minimog' ),
				'normal'   => esc_html__( 'Normal', 'minimog' ),
				'extended' => esc_html__( 'Extended', 'minimog' ),
				'wide'     => esc_html__( 'Wide', 'minimog' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_images_wide' ),
		),
		array(
			'id'      => 'single_product_images_offset',
			'type'    => 'select',
			'title'   => esc_html__( 'Product Images Offset', 'minimog' ),
			'options' => [
				'0'  => esc_html__( 'No Offset', 'minimog' ),
				'20' => sprintf( esc_html__( 'Offset %s', 'minimog' ), '20px' ),
				'30' => sprintf( esc_html__( 'Offset %s', 'minimog' ), '30px' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_images_offset' ),
		),
		array(
			'id'      => 'single_product_summary_offset',
			'type'    => 'select',
			'title'   => esc_html__( 'Product Summary Offset', 'minimog' ),
			'options' => [
				'0'  => esc_html__( 'No Offset', 'minimog' ),
				'20' => sprintf( esc_html__( 'Offset %s', 'minimog' ), '20px' ),
				'30' => sprintf( esc_html__( 'Offset %s', 'minimog' ), '30px' ),
				'40' => sprintf( esc_html__( 'Offset %s', 'minimog' ), '40px' ),
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_summary_offset' ),
		),
		array(
			'id'      => 'single_product_sticky_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Sticky Images & Summary', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'None', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_sticky_enable' ),
		),
		array(
			'id'     => 'section_start_single_product_buy_now',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Buy Now Button', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'single_product_buy_now_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Visibility', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_buy_now_enable' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'single_product_buy_now_text',
			'title'       => esc_html__( 'Button Text', 'minimog' ),
			'description' => esc_html__( 'Leave blank to use default.', 'minimog' ),
		),
		array(
			'id'     => 'section_start_single_product_trust_badge',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Trust Badge', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'single_product_trust_badge_enable',
			'type'        => 'button_set',
			'title'       => esc_html__( 'Visibility', 'minimog' ),
			'description' => esc_html__( 'Turn on to display the trust badge below Add to cart button.', 'minimog' ),
			'options'     => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'single_product_trust_badge_enable' ),
		),
		array(
			'id'      => 'single_product_trust_badge_image',
			'type'    => 'media',
			'title'   => esc_html__( 'Image', 'minimog' ),
			'default' => Minimog_Redux::get_default_setting( 'single_product_trust_badge_image' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'single_product_trust_badge_text',
			'title'       => esc_html__( 'Text', 'minimog' ),
			'description' => esc_html__( 'Leave blank to use default.', 'minimog' ),
		),
		array(
			'id'     => 'section_start_product_single_other_settings',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Other Settings', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'single_product_sticky_bar_enable',
			'type'        => 'button_set',
			'title'       => esc_html__( 'Sticky Product', 'minimog' ),
			'description' => esc_html__( 'Turn on to show product sticky bar when scroll down.', 'minimog' ),
			'options'     => array(
				'0' => esc_html__( 'None', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'single_product_sticky_bar_enable' ),
		),
		array(
			'id'      => 'single_product_tabs_style',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Product Tabs Style', 'minimog' ),
			'options' => array(
				'tabs'    => esc_html__( 'Tabs', 'minimog' ),
				'toggles' => esc_html__( 'Toggles', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_tabs_style' ),
		),
		array(
			'id'      => 'single_product_review_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Product Reviews Style', 'minimog' ),
			'options' => [
				'01' => '01',
				'02' => '02',
			],
			'default' => Minimog_Redux::get_default_setting( 'single_product_review_style' ),
		),
		array(
			'id'      => 'product_content_position',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Product Content Position', 'minimog' ),
			'options' => array(
				''              => esc_html__( 'In Product Data Tabs/Toggles', 'minimog' ),
				'below_summary' => esc_html__( 'Below Product Summary', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'product_content_position' ),
		),
		array(
			'id'      => 'single_product_short_description_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Short Description', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_short_description_enable' ),
		),
		array(
			'id'          => 'single_product_total_sales_enable',
			'type'        => 'button_set',
			'title'       => esc_html__( 'Total Sales', 'minimog' ),
			'description' => esc_html__( 'Turn on to show product total sales.', 'minimog' ),
			'options'     => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'single_product_total_sales_enable' ),
		),
		array(
			'id'      => 'single_product_low_stock_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Low stock bar', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_low_stock_enable' ),
		),
		array(
			'id'      => 'single_product_live_view_visitors_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Live view Visitors', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_live_view_visitors_enable' ),
		),
		array(
			'id'            => 'single_product_live_view_visitors_range',
			'type'          => 'slider',
			'title'         => esc_html__( 'Live View Visitors Range', 'minimog' ),
			'default'       => Minimog_Redux::get_default_setting( 'single_product_live_view_visitors_range' ),
			'min'           => 1,
			'step'          => 1,
			'max'           => 1000,
			'display_value' => 'text',
			'handles'       => 2,
		),
		array(
			'id'      => 'single_product_shipping_class_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Shipping Class Info', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_shipping_class_enable' ),
		),
		array(
			'id'      => 'single_product_shipping_estimated_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Shipping Estimated Info', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_shipping_estimated_enable' ),
		),
		array(
			'id'      => 'single_product_shipping_n_returns_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Free Shipping & Returns Info', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_shipping_n_returns_enable' ),
		),
		array(
			'id'      => 'single_product_meta_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Product Meta', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_meta_enable' ),
		),
		array(
			'id'      => 'single_product_categories_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Categories', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_categories_enable' ),
		),
		array(
			'id'      => 'single_product_tags_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Tags', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_tags_enable' ),
		),
		array(
			'id'          => 'single_product_brands_tab_enable',
			'type'        => 'button_set',
			'title'       => esc_html__( 'Brands Tab', 'minimog' ),
			'description' => esc_html__( 'Show product brand in tab', 'minimog' ),
			'options'     => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default'     => Minimog_Redux::get_default_setting( 'single_product_brands_tab_enable' ),
		),
		array(
			'id'      => 'single_product_compare_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Compare Link', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_compare_enable' ),
		),
		array(
			'id'      => 'single_product_sharing_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Sharing', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_sharing_enable' ),
		),
		array(
			'id'     => 'section_start_single_product_product_loop',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Product Loop', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'single_product_up_sells_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Up-sells Products', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_up_sells_enable' ),
		),
		array(
			'id'       => 'single_product_up_sells_position',
			'type'     => 'select',
			'title'    => esc_html__( 'Up-sells Products Position', 'minimog' ),
			'options'  => [
				'in_linked_product_tabs' => esc_html__( 'In Linked Product Tabs', 'minimog' ),
				'below_product_tabs'     => esc_html__( 'Below Product Tabs', 'minimog' ),
				'below_product_images'   => esc_html__( 'Below Product Images', 'minimog' ),
				'below_product_summary'  => esc_html__( 'Below Product Summary', 'minimog' ),
				'below_product_details'  => esc_html__( 'Below Product Details', 'minimog' ),
			],
			'default'  => Minimog_Redux::get_default_setting( 'single_product_up_sells_position' ),
			'required' => array(
				[ 'single_product_up_sells_enable', '=', '1' ],
			),
		),
		array(
			'id'      => 'single_product_related_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Related products', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_related_enable' ),
		),
		array(
			'id'       => 'single_product_related_position',
			'type'     => 'select',
			'title'    => esc_html__( 'Related Products Position', 'minimog' ),
			'options'  => [
				'below_product_tabs'     => esc_html__( 'Below Product Tabs', 'minimog' ),
				'in_linked_product_tabs' => esc_html__( 'In Linked Product Tabs', 'minimog' ),
			],
			'default'  => Minimog_Redux::get_default_setting( 'single_product_related_position' ),
			'required' => array(
				[ 'single_product_related_enable', '=', '1' ],
			),
		),
		array(
			'id'            => 'product_related_number',
			'title'         => esc_html__( 'Number related products', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'product_related_number' ),
			'min'           => 1,
			'max'           => 30,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_related_enable', '=', '1' ],
			),
		),
		array(
			'id'      => 'single_product_recent_viewed_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Recent viewed products', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'Hide', 'minimog' ),
				'1' => esc_html__( 'Show', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'single_product_recent_viewed_enable' ),
		),
		array(
			'id'       => 'single_product_recent_viewed_position',
			'type'     => 'select',
			'title'    => esc_html__( 'Recent Viewed Products Position', 'minimog' ),
			'options'  => [
				'in_linked_product_tabs' => esc_html__( 'In Linked Product Tabs', 'minimog' ),
				'below_product_tabs'     => esc_html__( 'Below Product Tabs', 'minimog' ),
			],
			'default'  => Minimog_Redux::get_default_setting( 'single_product_recent_viewed_position' ),
			'required' => array(
				[ 'single_product_recent_viewed_enable', '=', '1' ],
			),
		),
		array(
			'id'            => 'recent_viewed_products_per_page',
			'title'         => esc_html__( 'Number recent viewed products', 'minimog' ),
			'type'          => 'slider',
			'default'       => Minimog_Redux::get_default_setting( 'recent_viewed_products_per_page' ),
			'min'           => 1,
			'max'           => 30,
			'step'          => 1,
			'display_value' => 'text',
			'required'      => array(
				[ 'single_product_recent_viewed_enable', '=', '1' ],
			),
		),
		array(
			'id'      => 'single_product_loop_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Product Loop Style', 'minimog' ),
			'options' => Minimog_Woo::instance()->get_shop_loop_carousel_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'single_product_loop_style' ),
		),
		array(
			'id'      => 'single_product_loop_caption_style',
			'type'    => 'select',
			'title'   => esc_html__( 'Caption Style', 'minimog' ),
			'options' => Minimog_Woo::instance()->get_shop_loop_caption_style_options(),
			'default' => Minimog_Redux::get_default_setting( 'single_product_loop_caption_style' ),
		),
		array(
			'id'            => 'single_product_loop_lg_columns',
			'title'         => esc_html__( 'Grid Columns', 'minimog' ),
			'type'          => 'slider',
			'default'       => 4,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_lg_gutter',
			'title'         => esc_html__( 'Grid Gutter', 'minimog' ),
			'type'          => 'slider',
			'default'       => 30,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_md_columns',
			'title'         => esc_html__( 'Grid Columns (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 3,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_md_gutter',
			'title'         => esc_html__( 'Grid Gutter (Tablet)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 20,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_sm_columns',
			'title'         => esc_html__( 'Grid Columns (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 2,
			'min'           => 1,
			'max'           => 6,
			'step'          => 1,
			'display_value' => 'text',
		),
		array(
			'id'            => 'single_product_loop_sm_gutter',
			'title'         => esc_html__( 'Grid Gutter (Mobile)', 'minimog' ),
			'type'          => 'slider',
			'default'       => 16,
			'min'           => 0,
			'max'           => 100,
			'step'          => 1,
			'display_value' => 'text',
		),
	),
) );
