<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => esc_html__( 'Category Menu', 'minimog' ),
	'desc'       => 'Display a category menu on site header. This feature only supported for Header Style 06, 08, 10, 11',
	'id'         => 'category_menu',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'     => 'section_start_header_category_general',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'General', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'      => 'header_category_menu_enable',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Enable', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'No', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'header_category_menu_enable' ),
		),
		array(
			'id'      => 'header_category_menu_sticky_homepage',
			'type'    => 'button_set',
			'title'   => esc_html__( 'Sticky on homepage?', 'minimog' ),
			'options' => array(
				'0' => esc_html__( 'No', 'minimog' ),
				'1' => esc_html__( 'Yes', 'minimog' ),
			),
			'default' => Minimog_Redux::get_default_setting( 'header_category_menu_sticky_homepage' ),
		),
		array(
			'type'        => 'text',
			'id'          => 'header_category_menu_toggler_text',
			'title'       => esc_html__( 'Toggle Button Text', 'minimog' ),
			'description' => esc_html__( 'Leave blank to use default.', 'minimog' ),
			'default'     => '',
		),
		array(
			'id'     => 'section_start_header_category_dark_version',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Header Dark Version', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_border_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Border', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_hover_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Hover Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_toggle_hover_border_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Hover Border', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'     => 'section_start_header_category_light_version',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Header Light Version', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_border_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Border', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_hover_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Hover Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_style_light_category_menu_toggle_hover_border_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Toggler Hover Border', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'     => 'section_start_header_category_dropdown',
			'type'   => 'tm_heading',
			'title'  => esc_html__( 'Dropdown Menu', 'minimog' ),
			'indent' => true,
		),
		array(
			'id'          => 'header_category_menu_background_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Menu Background Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_border_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Menu Border Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_hover_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Hover Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_hover_background',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Hover Background', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_arrow_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Arrow Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'          => 'header_category_menu_link_hover_arrow_color',
			'type'        => 'color',
			'title'       => esc_html__( 'Link Hover Arrow Color', 'minimog' ),
			'color_alpha' => true,
		),
		array(
			'id'      => 'header_category_menu_link_hover_shadow',
			'type'    => 'switch',
			'title'   => esc_html__( 'Link Hover Shadow', 'minimog' ),
			'default' => false,
		),
		array(
			'id'            => 'header_category_menu_link_rounded',
			'type'          => 'slider',
			'title'         => esc_html__( 'Link Hover Rounded', 'minimog' ),
			'default'       => 5,
			'min'           => 0,
			'step'          => 1,
			'max'           => 50,
			'display_value' => 'text',
		),
	),
) );
