<?php
Redux::set_section( Minimog_Redux::OPTION_NAME, array(
	'title'      => esc_html__( 'Typography', 'minimog' ),
	'id'         => 'typography',
	'subsection' => true,
	'fields'     => array(
		array(
			'id'    => 'typography_instruction',
			'type'  => 'info',
			'style' => 'info',
			'title' => esc_html__( 'IMPORTANT NOTE: ', 'minimog' ),
			'desc'  => esc_html__( 'This section contains general typography options. Additional typography options for specific areas can be found within other sections. Example: For breadcrumb typography options go to the breadcrumb section.', 'minimog' ),
		),
		array(
			'id'       => 'section_typography_body_heading',
			'type'     => 'tm_heading',
			'collapse' => 'show',
			'title'    => esc_html__( 'Body & Heading Typography', 'minimog' ),
			'subtitle' => esc_html__( 'These settings control the typography for headings and text.', 'minimog' ),
			'indent'   => true,
		),
		array(
			'id'                => 'typography_body',
			'type'              => 'typography',
			// Enable all Google Font style/weight variations to be added to the page.
			'all-styles'        => true,
			'all-subsets'       => true,
			'title'             => esc_html__( 'Body Typography', 'minimog' ),
			'subtitle'          => esc_html__( 'These settings control the typography for all body text.', 'minimog' ),
			'google'            => true,
			'font_family_clear' => true,
			'default'           => Minimog_Redux::get_default_setting( 'typography_body' ),
			'color'             => false,
			'text-align'        => false,
		),
		array(
			'id'                => 'typography_heading',
			'type'              => 'typography',
			'title'             => esc_html__( 'Heading', 'minimog' ),
			'subtitle'          => esc_html__( 'These settings control the typography for all heading text.', 'minimog' ),
			'google'            => true,
			'font_family_clear' => false,
			'default'           => Minimog_Redux::get_default_setting( 'typography_heading' ),
			'color'             => false,
			'text-align'        => false,
			'font-size'         => false,
			'line-height'       => false,
			'letter-spacing'    => true,
		),
		array(
			'id'          => 'typography_heading_weight_2',
			'type'        => 'select',
			'title'       => esc_html__( 'Heading Weight 2', 'minimog' ),
			'description' => esc_html__( 'Select other weight of heading typography', 'minimog' ),
			'options'     => [
				'400' => esc_html__( 'Regular 400', 'minimog' ),
				'500' => esc_html__( 'Medium 500', 'minimog' ),
				'600' => esc_html__( 'Semi-Bold 600', 'minimog' ),
				'700' => esc_html__( 'Bold 700', 'minimog' ),
				'800' => esc_html__( 'Extra Bold 800', 'minimog' ),
				'900' => esc_html__( 'Black 900', 'minimog' ),
			],
			'default'     => Minimog_Redux::get_default_setting( 'typography_heading_weight_2' ),
		),
		array(
			'id'                => 'typography_heading2',
			'type'              => 'typography',
			'title'             => esc_html__( 'Heading 2', 'minimog' ),
			'subtitle'          => esc_html__( 'These settings control the typography for all heading 2 text.', 'minimog' ),
			'google'            => true,
			'font_family_clear' => false,
			'color'             => false,
			'text-align'        => false,
			'font-size'         => false,
			'line-height'       => false,
			'letter-spacing'    => false,
		),

		/**
		 * Button Typography
		 */
		array(
			'id'       => 'section_button_typography',
			'type'     => 'tm_heading',
			'collapse' => 'show',
			'title'    => esc_html__( 'Button Typography', 'minimog' ),
			'subtitle' => esc_html__( 'These settings control the typography for all buttons.', 'minimog' ),
			'indent'   => true,
		),
		array(
			'id'          => 'button_typography_inherit',
			'type'        => 'button_set',
			'title'       => esc_html__( 'Font Family', 'minimog' ),
			'description' => esc_html__( 'Select inherit to use same font family as Body.', 'minimog' ),
			'options'     => [
				'0' => esc_html__( 'Custom', 'minimog' ),
				'1' => esc_html__( 'Inherit', 'minimog' ),
			],
			'default'     => '1',
			'class'       => 'row-no-border',
		),
		array(
			'id'                => 'button_typography',
			'type'              => 'typography',
			'title'             => esc_html__( 'Typography', 'minimog' ),
			'google'            => true,
			'font_family_clear' => false,
			'default'           => Minimog_Redux::get_default_setting( 'button_typography' ),
			'letter-spacing'    => true,
			'text-transform'    => true,
			'color'             => false,
			'text-align'        => false,
			'line-height'       => false,
			'required'          => array(
				[ 'button_typography_inherit', '=', '0' ],
			),
		),
		array(
			'id'       => 'button_typography_custom_weight',
			'type'     => 'select',
			'title'    => esc_html__( 'Font Weight', 'minimog' ),
			'class'    => 'row-no-border',
			'options'  => Minimog_Redux::get_all_font_variations(),
			'default'  => Minimog_Redux::get_default_setting( 'button_typography_custom_weight' ),
			'required' => array(
				[ 'button_typography_inherit', '=', '1' ],
			),
		),
		array(
			'id'                => 'button_typography_custom',
			'type'              => 'typography',
			'title'             => esc_html__( 'Other', 'minimog' ),
			'google'            => false,
			'font_family_clear' => false,
			'default'           => Minimog_Redux::get_default_setting( 'button_typography_custom' ),
			'font-family'       => false,
			'font-weight'       => false,
			'font-variant'      => false,
			'font-style'        => false,
			'subsets'           => false,
			'preview'           => false,
			'color'             => false,
			'text-align'        => false,
			'line-height'       => false,
			'letter-spacing'    => true,
			'text-transform'    => true,
			'required'          => array(
				[ 'button_typography_inherit', '=', '1' ],
			),
		),

		/**
		 * Form Typography
		 */
		array(
			'id'       => 'section_form_typography',
			'type'     => 'tm_heading',
			'collapse' => 'show',
			'title'    => esc_html__( 'Form Typography', 'minimog' ),
			'subtitle' => esc_html__( 'These settings control the typography for form inputs.', 'minimog' ),
			'indent'   => true,
		),
		array(
			'id'          => 'form_typography_inherit',
			'type'        => 'button_set',
			'title'       => esc_html__( 'Font Family', 'minimog' ),
			'description' => esc_html__( 'Select inherit to use same font family as Body.', 'minimog' ),
			'options'     => [
				'0' => esc_html__( 'Custom', 'minimog' ),
				'1' => esc_html__( 'Inherit', 'minimog' ),
			],
			'default'     => '1',
			'class'       => 'row-no-border',
		),
		array(
			'id'                => 'form_typography',
			'type'              => 'typography',
			'title'             => esc_html__( 'Typography', 'minimog' ),
			'google'            => true,
			'font_family_clear' => false,
			'default'           => Minimog_Redux::get_default_setting( 'form_typography' ),
			'color'             => false,
			'text-align'        => false,
			'letter-spacing'    => false,
			'text-transform'    => false,
			'line-height'       => false,
			'required'          => array(
				[ 'form_typography_inherit', '=', '0' ],
			),
		),
		array(
			'id'       => 'form_typography_custom_weight',
			'type'     => 'select',
			'title'    => esc_html__( 'Font Weight', 'minimog' ),
			'class'    => 'row-no-border',
			'options'  => Minimog_Redux::get_all_font_variations(),
			'default'  => Minimog_Redux::get_default_setting( 'form_typography_custom_weight' ),
			'required' => array(
				[ 'form_typography_inherit', '=', '1' ],
			),
		),
		array(
			'id'                => 'form_typography_custom',
			'type'              => 'typography',
			'title'             => esc_html__( 'Other', 'minimog' ),
			'google'            => false,
			'font_family_clear' => false,
			'default'           => Minimog_Redux::get_default_setting( 'form_typography_custom' ),
			'font-family'       => false,
			'font-weight'       => false,
			'font-variant'      => false,
			'font-style'        => false,
			'subsets'           => false,
			'preview'           => false,
			'color'             => false,
			'text-align'        => false,
			'letter-spacing'    => false,
			'text-transform'    => false,
			'line-height'       => false,
			'required'          => array(
				[ 'form_typography_inherit', '=', '1' ],
			),
		),
	),
) );
